// 获取工程情况分析饼图
function getProject_analyze_chart(chartData) {
    var dom = document.getElementById("project_analyze_chart");
    var myChart = echarts.init(dom);
    option = null;

    option = {
        color: ['#ff7171', '#4ddef6'],
        series: [{
            name: '工程情况分析',
            type: 'pie',
            radius: ['65%', '80%'],
            avoidLabelOverlap: false,
            label: {
                show: false,
                position: 'center'
            },
            emphasis: {
                label: {
                    show: true,
                    fontSize: 15,
                    fontWeight: 'bold',
                    formatter: [
                        '{a|{d}%}',
                        '{b|{b}}'
                    ].join('\n'),
                    rich: {
                        a: {
                            color: '#61baff',
                            fontSize: 15,
                            lineHeight: 30
                        },
                        b: {
                            color: '#fff',
                            fontSize: 10
                        }
                    },
                },
            },
            labelLine: {
                show: false
            },
            data: [
                { value: chartData.num3, name: '不合格' },
                { value: chartData.num2, name: '合格' },
            ]
        }]
    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 桩基检测1
function getPileFoundationDetection_1(type, chartData) {
    var dom = document.getElementById("pileFoundationDetection_1"),
        data;
    if (type == 0) { //本月
        data = [
            { value: chartData.num4, name: '不合格' },
            { value: chartData.num3, name: '合格' },
        ]
    } else {
        // 本年
        data = [
            { value: chartData.num8, name: '不合格' },
            { value: chartData.num7, name: '合格' },
        ]
    }
    var myChart = echarts.init(dom);
    option = null;
    option = {
        color: ['#ffbe71', '#4df6c0'],
        animation: false,
        tooltip: {
            trigger: 'item',
            formatter: '{a} <br/>{b} : {c} ({d}%)'
        },
        series: [{
            name: '桩基检测',
            // startAngle: '20',
            type: 'pie',
            radius: '75%',
            center: ['50%', '60%'],
            data,
            labelLine: {
                lineStyle: {
                    color: '#80a5ee'
                }
            },
            label: {
                normal: {
                    formatter: '{a|{b}:{c}\n\n占比：{d}%}',
                    rich: {
                        a: {
                            color: '#80a5ee',
                            fontSize: 8
                        }
                    }
                }
            }
        }]
    };


    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 桩基检测2
function getPileFoundationDetection_2(type, chartData) {
    var dom = document.getElementById("pileFoundationDetection_2"),
        data;
    var myChart = echarts.init(dom);
    if (type == 0) {
        // 本月
        data = [{
            value: chartData.num3,
            name: '一类'
        }, {
            value: chartData.num4,
            name: '二类 '
        }, {
            value: chartData.num5,
            name: '其他'
        }]
    } else {
        // 本年
        [{
            value: chartData.num8,
            name: '一类'
        }, {
            value: chartData.num9,
            name: '二类 '
        }, {
            value: chartData.num10,
            name: '其他'
        }]
    }
    option = null;
    option = {
        color: ['#ff7171', '#ffcd76', '#76c3ff'],
        animation: false,
        tooltip: {
            trigger: 'item',
            formatter: '{a} <br/>{b} : {c} ({d}%)'
        },
        series: [{
            name: '桩基检测',
            // startAngle: '0',
            type: 'pie',
            radius: '75%',
            center: ['50%', '50%'],
            data,
            labelLine: {
                lineStyle: {
                    color: '#80a5ee'
                }
            },
            label: {
                normal: {
                    formatter: '{a|{b}:{c}\n\n占比：{d}%}',
                    rich: {
                        a: {
                            color: '#80a5ee',
                            lineHeight: 10,
                            fontSize: 8
                        }
                    }
                }
            }
        }]
    };
    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 钢结构1
function getSiteStructureTest1(type, chartData) {
    var dom = document.getElementById("siteStructureTest1"),
        data;
    if (type == 0) {
        // 本月
        data = [
            { value: chartData.num3, name: '不合格' },
            { value: chartData.num2, name: '合格' },
        ]
    } else {
        //本年
        data = [
            { value: chartData.num6, name: '不合格' },
            { value: chartData.num5, name: '合格' },
        ]
    }
    var myChart = echarts.init(dom);
    option = null;

    option = {
        color: ['#ff7171', '#4ddef6'],
        tooltip: {
            trigger: 'item',
            formatter: '{b} : {d}%'
        },
        series: [{
            name: '钢结构',
            type: 'pie',
            radius: ['50%', '60%'],
            avoidLabelOverlap: false,
            label: {
                show: false,
                position: 'center'
            },
            emphasis: {
                label: {
                    show: true,
                    fontSize: '20',
                    fontWeight: 'bold',
                    formatter: [
                        '{a|无损检测}',
                    ].join('\n'),
                    rich: {
                        a: {
                            color: '#61baff',
                            fontSize: 12,
                        },
                    },
                },
            },
            labelLine: {
                show: false
            },
            data
        }]
    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.dispatchAction({
            type: 'showTip',
            seriesIndex: 0,
            dataIndex: index
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 钢结构2
function getSiteStructureTest2(type, chartData) {
    var dom = document.getElementById("siteStructureTest2"),
        data;
    if (type == 0) {
        // 本月
        data = [
            { value: chartData.num3, name: '不合格' },
            { value: chartData.num2, name: '合格' },
        ]
    } else {
        // 本年
        data = [
            { value: chartData.num6, name: '不合格' },
            { value: chartData.num5, name: '合格' },
        ]
    }
    var myChart = echarts.init(dom);
    option = null;

    option = {
        color: ['#ff7171', '#4ddef6'],
        tooltip: {
            trigger: 'item',
            formatter: '{b} : {d}%'
        },
        series: [{
            name: '钢结构',
            type: 'pie',
            radius: ['50%', '60%'],
            avoidLabelOverlap: false,
            label: {
                show: false,
                position: 'center'
            },
            emphasis: {
                label: {
                    show: true,
                    fontSize: '20',
                    fontWeight: 'bold',
                    formatter: [
                        '{a|涂装检测}',
                    ].join('\n'),
                    rich: {
                        a: {
                            color: '#61baff',
                            fontSize: 12,
                        },
                    },
                },
            },
            labelLine: {
                show: false
            },
            data
        }]
    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.dispatchAction({
            type: 'showTip',
            seriesIndex: 0,
            dataIndex: index
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 市政工程1
function getSiteEnergyTest1(type, chartData) {
    var dom = document.getElementById("siteEnergyTest1"),
        data;
    var myChart = echarts.init(dom);
    if (type == 0) {
        data = [
            { value: chartData.num3, name: '不合格' },
            { value: chartData.num2, name: '合格' },
        ]
    } else {
        data = [
            { value: chartData.num6, name: '不合格' },
            { value: chartData.num5, name: '合格' },
        ]
    }
    option = null;

    option = {
        color: ['#ff7171', '#4ddef6'],
        tooltip: {
            trigger: 'item',
            formatter: '{b} : {d}%'
        },
        series: [{
            name: '市政结构',
            type: 'pie',
            radius: ['50%', '60%'],
            avoidLabelOverlap: false,
            label: {
                show: false,
                position: 'center'
            },
            emphasis: {
                label: {
                    show: true,
                    fontSize: '20',
                    fontWeight: 'bold',
                    formatter: [
                        '{a|弯沉}',
                    ].join('\n'),
                    rich: {
                        a: {
                            color: '#61baff',
                            fontSize: 12,
                        },
                    },
                },
            },
            labelLine: {
                show: false
            },
            data
        }]
    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.dispatchAction({
            type: 'showTip',
            seriesIndex: 0,
            dataIndex: index
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 市政工程2
function getSiteEnergyTest2(type, chartData) {
    var dom = document.getElementById("siteEnergyTest2"),
        data;
    var myChart = echarts.init(dom);
    option = null;
    if (type == 0) {
        data = [
            { value: chartData.num3, name: '不合格' },
            { value: chartData.num2, name: '合格' },
        ]
    } else {
        data = [
            { value: chartData.num6, name: '不合格' },
            { value: chartData.num5, name: '合格' },
        ]
    }

    option = {
        color: ['#ff7171', '#4ddef6'],
        tooltip: {
            trigger: 'item',
            formatter: '{b} : {d}%'
        },
        series: [{
            name: '市政结构',
            type: 'pie',
            radius: ['50%', '60%'],
            avoidLabelOverlap: false,
            label: {
                show: false,
                position: 'center'
            },
            emphasis: {
                label: {
                    show: true,
                    fontSize: '20',
                    fontWeight: 'bold',
                    formatter: [
                        '{a|路面厚度}',
                    ].join('\n'),
                    rich: {
                        a: {
                            color: '#61baff',
                            fontSize: 12,
                        },
                    },
                },
            },
            labelLine: {
                show: false
            },
            data
        }]
    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.dispatchAction({
            type: 'showTip',
            seriesIndex: 0,
            dataIndex: index
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 累计受理委托1
function getTestUnitAnalyze1(type, chartData1, chartData2) {
    var dom = document.getElementById("testUnitAnalyze1");
    var myChart = echarts.init(dom),
        data;
    option = null;
    if (type == 0) {
        // 本月
        data = [{
            value: chartData2.num1,
            name: '现场检测'
        }, {
            value: chartData1.num1,
            name: '试验室检测 '
        }]
    } else {
        // 本年
        data = [{
            value: chartData2.num2,
            name: '现场检测'
        }, {
            value: chartData1.num2,
            name: '试验室检测 '
        }]
    }

    option = {
        color: ['#ffbe71', '#4df6c0'],
        series: [{
            name: '桩基检测',
            type: 'pie',
            startAngle: 0,
            radius: '45%',
            center: ['50%', '40%'],
            labelLine: {
                normal: {
                    length: 20,
                    length2: 10,
                    lineStyle: {
                        color: '#fff'
                    }
                }

            },
            label: {
                normal: {
                    formatter: '{a|{b}}\n{b|累计：{c}次}\n{b|占比：{d}%}',
                    backgroundColor: 'rgba(0,0,0,0.7)',
                    padding: 5,
                    fontSize: 6,
                    rich: {
                        a: {
                            color: "white",
                            fontSize: 10,
                        },
                        b: {
                            color: '#80a5ee',
                            fontSize: 10,
                        }
                    }
                }
            },
            data
        }]

    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 累计受理委托2
function getTestUnitAnalyze2(type, chartData) {
    var dom = document.getElementById("testUnitAnalyze2");
    var myChart = echarts.init(dom),
        data;
    option = null;
    if (type == 0) {
        // 本月
        data = [{
            value: chartData.num2,
            name: '不合格'
        }, {
            value: chartData.num3,
            name: '合格 '
        }]
    } else {
        // 本年
        data = [{
            value: chartData.num5,
            name: '不合格'
        }, {
            value: chartData.num6,
            name: '合格 '
        }]
    }
    option = {
        color: ['#ff7171', '#76c3ff'],
        series: [{
            name: '桩基检测',
            type: 'pie',
            startAngle: 0,
            radius: '45%',
            center: ['50%', '40%'],
            labelLine: {
                normal: {
                    length: 20,
                    length2: 10,
                    lineStyle: {
                        color: '#fff'
                    }
                }

            },
            label: {
                normal: {
                    formatter: '{a|{b}}\n{b|累计：{c}次}\n{b|占比：{d}%}',
                    backgroundColor: 'rgba(0,0,0,0.6)',
                    padding: 5,
                    fontSize: 6,
                    rich: {
                        a: {
                            color: "white",
                            fontSize: 10,
                        },
                        b: {
                            color: '#80a5ee',
                            fontSize: 10,
                        }
                    }
                }
            },
            data
        }]

    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 两材两块信息
function getlclkInfo(type, chartData1, chartData2, chartData3) {
    var dom = document.getElementById("lclkInfo");
    var myChart = echarts.init(dom),
        data1, data2;
    option = null;
    if (type == 0) {
        // 本月
        data1 = [chartData1.num2, chartData2.num2, chartData3.num2];
        data2 = [chartData1.num3, chartData2.num3, chartData3.num3];
    } else {
        // 本年
        data1 = [chartData1.num5, chartData2.num5, chartData3.num5];
        data2 = [chartData1.num6, chartData2.num6, chartData3.num6];
    }
    option = {
        color: ['#4ddef6', '#ff7171'],
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'shadow' // 默认为直线，可选为：'line' | 'shadow'
            }
        },
        grid: {
            left: '3%',
            right: '0%',
            bottom: '0%',
            top: '0%',
            containLabel: true
        },
        xAxis: [{
            type: 'category',
            data: ['试块', '原材', '焊接'],
            "splitLine": {
                "show": false
            },
            "axisLine": { //y轴
                "show": false
            },
            "axisTick": { //y轴刻度线
                "show": false
            },
            "splitLine": { //网格线
                "show": false
            },
            axisLabel: {
                color: '#80a5ee'
            }
        }],
        yAxis: [{
            type: 'value',
            axisLabel: {
                "show": false
            },
            "splitLine": {
                "show": false
            },
            "axisLine": { //y轴
                "show": false
            },
            "axisTick": { //y轴刻度线
                "show": false
            },
            "splitLine": { //网格线
                "show": false
            }
        }],
        series: [{
                name: '合格',
                type: 'bar',
                data: data1,
                barWidth: 10
            },
            {
                name: '不合格',
                type: 'bar',
                data: data2,
                barWidth: 10
            },
        ]
    };


    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        var index = 0;
        var monthly_detect_timer = setInterval(function() {
            myChart.dispatchAction({
                type: 'showTip',
                seriesIndex: 0,
                dataIndex: index
            });
            index++;
            let dataLen = option.series.length;
            for (let i = 0; i < dataLen; i++) {
                if (index > option.series[i].data.length - 1) {
                    index = 0;
                }
            }
        }, 5000)
    }
}
// 行为监管情况
function getBehavior() {
    var dom = document.getElementById("behavior");
    var myChart = echarts.init(dom);
    option = null;

    option = {
        color: ['#ff7171', '#4ddef6'],
        tooltip: {
            trigger: 'item',
            formatter: '{b} : {d}%'
        },
        series: [{
            name: '现场节能检验',
            type: 'pie',
            radius: ['70%', '80%'],
            center: ['50%', '60%'],
            avoidLabelOverlap: false,
            label: {
                show: false,
                position: 'center'
            },
            emphasis: {
                label: {
                    show: true,
                    fontSize: '20',
                    fontWeight: 'bold',
                    formatter: [
                        '{a|现场检\n测行为}',
                    ].join('\n'),
                    rich: {
                        a: {
                            color: '#61baff',
                            fontSize: 12,
                        },
                    },
                },
            },
            labelLine: {
                show: false
            },
            data: [
                { value: 60, name: '不规范' },
                { value: 320, name: '行为规范' },
            ]
        }]
    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.dispatchAction({
            type: 'showTip',
            seriesIndex: 0,
            dataIndex: index
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 表格滚动方法
function tableScroll(data) {
    var MyMarhq = '';
    clearInterval(MyMarhq);
    $('.tbl-body tbody').empty();
    $('.tbl-header tbody').empty();
    var str = '';
    var Items = data;
    $.each(Items, function(i, item) {
        str = '<tr>' +
            '<td title="' + item.project_name + '">' + item.project_name + '</td>' +
            '<td title="' + item.project_name + '">' + item.test_item + '</td>' +
            '<td title="' + item.customer_name + '">' + item.customer_name + '</td>' +
            '<td title="' + item.test_result + '">' + item.test_result + '</td>' +
            '</tr>'

        $('.tbl-body tbody').append(str);
        $('.tbl-header tbody').append(str);
    });

    if (Items.length > 4) {
        $('.tbl-body tbody').html($('.tbl-body tbody').html() + $('.tbl-body tbody').html());
        $('.tbl-body').css('top', '0');
        var tblTop = 0;
        var speedhq = 50; // 数值越大越慢
        var outerHeight = $('.tbl-body tbody').find("tr").outerHeight();

        function Marqueehq() {

            if (tblTop <= -outerHeight * Items.length) {
                tblTop = 0;
            } else {
                tblTop -= 1;
            }
            $('.tbl-body').css('top', tblTop + 'px');
        }

        MyMarhq = setInterval(Marqueehq, speedhq);

        // 鼠标移上去取消事件
        $(".tbl-header tbody").hover(function() {
            clearInterval(MyMarhq);
        }, function() {
            clearInterval(MyMarhq);
            MyMarhq = setInterval(Marqueehq, speedhq);
        })
    }
}
// 行为黑红名单
function behaviorScroll() {
    var MyMarhq = '';
    clearInterval(MyMarhq);
    $('#behaviorList .behaviorContent').empty();
    var str = '';
    $.ajax({
        url: baseUrl + '/ajax/GetStationDeduction.ashx',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        success: function(res) {

            var Items = res;
            //     [{ "company_name": "杭州建设小学一期建设工程", "behavior": "建筑企业不良记录对社会产生十分不好的影响", "test_result": "2020-01-29" },
            //     { "company_name": "杭州宇振建筑工程检测有限公司", "behavior": "各个企业都会对生产产生不同程度的影响各异", "test_result": "2019-05-16" },
            //     { "company_name": "杭州华新检测技术股份有限公司", "behavior": "污水排放量超标，导致干扰居民正常生活习惯", "test_result": "2020-09-12" },
            //     { "company_name": "杭州南兴建设工程检测有限公司", "behavior": "随便随便随便随便随便随便吧不不不", "test_result": "2018-09-28" },
            //     { "company_name": "杭州千家网络有限公司", "behavior": "空气质量安全引起重视", "test_result": "2018-12-05" },
            // ]
            $.each(Items, function(i, item) {
                str =
                    ' <div class="border-bottom"><span class="right-float text-cyan" title="' + item.de_date + '">' + item.de_date + '</span><div class="panel text-cyan"><div class="dot"></div><span title="' + item.company_name + '">' + item.company_name + '</span></div><div class="panel" title="' + item.behavior + '">不良行为：' + item.behavior + '</div></div>'

                $('#behaviorList .behaviorContent').append(str);
            });

            if (Items.length > 4) {
                $('#behaviorList .behaviorContent').html($('#behaviorList .behaviorContent').html() + $('#behaviorList .behaviorContent').html());
                $('#behaviorList .behaviorContent').css('top', '0');
                var tblTop = 0;
                var speedhq = 50; // 数值越大越慢
                var outerHeight = $('#behaviorList .behaviorContent .border-bottom').outerHeight();
                console.log()

                function Marqueehq() {
                    if (tblTop <= -outerHeight * Items.length) {
                        tblTop = 0;
                    } else {
                        tblTop -= 1;
                    }
                    $('#behaviorList .behaviorContent').css('top', tblTop + 'px');
                }

                MyMarhq = setInterval(Marqueehq, speedhq);

                // 鼠标移上去取消事件
                $("#behaviorList .border-bottom").hover(function() {
                    clearInterval(MyMarhq);
                }, function() {
                    clearInterval(MyMarhq);
                    MyMarhq = setInterval(Marqueehq, speedhq);
                })
            }
        }
    })
}
// 地图加载方法
function getMap(type, data) {
    console.log(type, data);
    var map = new AMap.Map("container", {
            resizeEnable: true,
            showLabel: true,
            center: [120.217108, 30.215689],
            zoom: 12,
            zooms: [3, 18]
        }),
        lnglats = data;
    var infoWindow = new AMap.InfoWindow({
        offset: new AMap.Pixel(0, -30)
    });
    var icon_1 = new AMap.Icon({
        size: new AMap.Size(40, 40),
        image: '../static/images/ico_gdlx.gif',
        imageSize: new AMap.Size(40, 40)
    });
    var icon_2 = new AMap.Icon({
        size: new AMap.Size(40, 40),
        image: '../static/images/ico_gdzc.gif',
        imageSize: new AMap.Size(40, 40)
    });
    var icon_3 = new AMap.Icon({
        size: new AMap.Size(40, 40),
        image: '../static/images/ico_gdwdyc.gif',
        imageSize: new AMap.Size(40, 40)
    });
    var icon_4 = new AMap.Icon({
        size: new AMap.Size(40, 40),
        image: '../static/images/ico_gdsdyc.gif',
        imageSize: new AMap.Size(40, 40)
    });
    var icon_5 = new AMap.Icon({
        size: new AMap.Size(40, 40),
        image: '../static/images/ico_dwlx.gif',
        imageSize: new AMap.Size(40, 40)
    });
    var icon_6 = new AMap.Icon({
        size: new AMap.Size(40, 40),
        image: '../static/images/ico_dwzc.gif',
        imageSize: new AMap.Size(40, 40)
    });
    var icon_7 = new AMap.Icon({
        size: new AMap.Size(40, 40),
        image: '../static/images/ico_dwwdyc.gif',
        imageSize: new AMap.Size(40, 40)
    });
    var icon_8 = new AMap.Icon({
        size: new AMap.Size(40, 40),
        image: '../static/images/ico_dwsdyc.gif',
        imageSize: new AMap.Size(40, 40)
    });
    map.setMapStyle('amap://styles/d41ab1f283b2ce07473956f464efa575');
    if (lnglats.length > 0) {
        for (var i = 0, marker; i < lnglats.length; i++) {
            var content = '加载中...';
            if (type == 1) {
                var marker = new AMap.Marker({
                    position: [lnglats[i].mapx, lnglats[i].mapy],
                    icon: lnglats[i].equ_type == 1 ? icon_1 : lnglats[i].equ_type == 2 ? icon_2 : lnglats[i].equ_type == 3 ? icon_3 : lnglats[i].equ_type == 4 ? icon_4 : lnglats[i].equ_type == 5 ? icon_5 : lnglats[i].equ_type == 6 ? icon_6 : lnglats[i].equ_type == 7 ? icon_7 : icon_8,
                    map: map
                });
                $('.map-legend').removeClass('hidden');
                content = '<div class="map-info"><div class="text-cyan border-bottom num">' + lnglats[i].customer_name + '</div><div class="flex-content-row border-bottom" style="text-align:center"><div class="border-right" style="width:50%"><div class="num text-red" style="font-size: 1.5rem;">' + lnglats[i].temperature + '℃</div><div>标养室温度</div></div><div style="width:50%"><div class="num text-red" style="font-size: 1.5rem;">' + lnglats[i].humidity + '%</div><div>标养室湿度</div></div></div><div style="text-align: right;"><span class="font_family icon-wenshidu"></span>数据更新时间：' + lnglats[i].collect_datetime + '</div></div>';
            } else if (type == 0) {
                var marker = new AMap.Marker({
                    position: [lnglats[i].mapx, lnglats[i].mapy],
                    icon: lnglats[i].equ_type == 1 ? icon_1 : lnglats[i].equ_type == 2 ? icon_2 : lnglats[i].equ_type == 3 ? icon_3 : lnglats[i].equ_type == 4 ? icon_4 : lnglats[i].equ_type == 5 ? icon_5 : lnglats[i].equ_type == 6 ? icon_6 : lnglats[i].equ_type == 7 ? icon_7 : icon_8,
                    map: map
                });
                $('.map-legend').addClass('hidden');
                content = '<div class="map-info-2"><div class="flex-content-row"><div class="map-info-box left-box"><div class="border-bottom text-cyan" style="padding:1rem">' + lnglats[i].op_name + '（' + lnglats[i].jc_item +'）</div><div class="flex-content-row"><div class="left-detail"><img src="' + lnglats[i].Portrait + '"></div><div class="right-detail"><div><span class="font_family icon-lianxifangshi-2 text-blue"></span>' + lnglats[i].op_mobile + '</div><div><span class="font_family icon-fangjian-2-2 text-blue"></span>' + lnglats[i].customer_name + '</div><div><span class="font_family icon-jianzhu-6-3 text-blue"></span>' + lnglats[i].location + '</div></div></div></div><div class="text-cyan right-box map-info-box" onclick="videoConect(\''+lnglats[i].op_code+'\')"><div class="font_family icon-shipindianhua--2" style="font-size: 5rem;"></div><div>视频连线</div></div></div></div>';
            } else if( type == 2){
                var marker = new AMap.Marker({
                    position: [lnglats[i].mapx, lnglats[i].mapy],
                    icon: icon_2,
                    map: map
                });
                content = '<div class="map-info-2"><div class="flex-content-row"><div class="map-info-box left-box"><div class="border-bottom text-cyan" style="padding:1rem">' + lnglats[i].pile_no +'</div><div class="flex-content-row"><div class="right-detail"><div><span class="font_family icon-leidatance text-blue"></span>检测方法：' + lnglats[i].test_type + '</div><div><span class="font_family icon-24gf-fileText text-blue"></span>预估荷载：' + lnglats[i].max_load + '</div><div><span class="font_family icon-24gf-playSquare text-blue"></span>开始时间：' + lnglats[i].start_time + '</div><div><span class="font_family icon-yunshangchuan text-blue"></span>上传时间：' + lnglats[i].upload_time + '</div><div><span class="font_family icon-zhaopian_huabanfuben text-blue"></span>现场照片：<span style="color: #00FFFF;cursor: pointer;" onclick="show_picView_Popup(\''+lnglats[i].SceneTask_id+'\')">点击查看<span></div></div></div></div><div class="text-cyan right-box map-info-box" onclick="show_spjk_popup(\''+ lnglats[i].SceneTask_id +'\')"><div class="font_family icon-jiankong3" style="font-size: 5rem;"></div><div>视频监控</div></div></div></div>';
            }
            marker.content = content;
            marker.on('mouseover', markerClick);
            marker.emit('click', {
                target: marker
            });


        }
    }

    function markerClick(e) {
        infoWindow.setContent(e.target.content);
        infoWindow.open(map, e.target.getPosition());
    }
    // map.setFitView();

}
// 监督检查情况
function getSp_check() {
    var dom = document.getElementById("sp_check");
    var myChart = echarts.init(dom);
    option = null;

    option = {
        color: ['#ff7171', '#ffcd76', '#76c3ff'],
        series: [{
            name: '桩基检测',
            type: 'pie',
            radius: '55%',
            center: ['50%', '50%'],
            startAngle: '150',
            labelLine: {
                normal: {
                    length: 18,
                    length2: 70,
                    lineStyle: {
                        color: '#80a5ee'
                    }
                }

            },
            label: {
                normal: {
                    formatter: '{a|{b}：{c} \n 占比：{d}%}',
                    borderWidth: 10,
                    borderRadius: 4,
                    padding: [0, -70],
                    rich: {
                        a: {
                            color: '#80a5ee',
                            fontSize: 10,
                            lineHeight: 20
                        }
                    }
                }
            },
            data: [{
                value: 16,
                name: '砼强度'
            }, {
                value: 319,
                name: '保护层厚度 '
            }, {
                value: 125,
                name: '市政工程厚度'
            }]
        }]

    };

    if (option && typeof option === "object") {
        myChart.setOption(option, true);
        let index = 0;
        myChart.dispatchAction({
            type: 'highlight',
            seriesIndex: 0,
            dataIndex: 0
        });
        myChart.on("mouseover", function(e) {

            if (e.dataIndex != index) {
                myChart.dispatchAction({
                    type: "downplay",
                    seriesIndex: 0,
                    dataIndex: index
                });
            }
        });
        myChart.on("mouseout", function(e) {
            index = e.dataIndex;
            myChart.dispatchAction({
                type: "highlight",
                seriesIndex: 0,
                dataIndex: e.dataIndex
            });
        });
    }
}
// 获取地图legend列表
function getMapList(map_pageIndex, map_pageSize, customer_type, status, customer_name) {
    $('.map-box tbody').html('');
    $('.img_loading').removeClass('hidden');
    $('.nodata').addClass('hidden');
    $('.map_total_count').html('0');
    let senddata = {
        page_size: map_pageSize,
        map_page_index: map_pageIndex,
        customer_type: customer_type, //  标养室类别  10- 工地 2- 检测
        status: status, //  状态   0在线  1离线
        customer_name: customer_name, //检测单位名称
    }
    $.ajax({
        url: baseUrl + '/ajax/GetEquipmentWSD.ashx',
        dataType: "jsonp",
        async: false,
        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        data: senddata,
        success: res => {
            console.log('GetEquipmentWSD=>send:', senddata);
            var hum_color, tem_color;
            console.log('GetEquipmentWSD=>res:', res);
            $('.img_loading').addClass('hidden');
            if (res.length > 0) {
                for (let i = 0; i < res.length; i++) {
                    if (res[i].hum_satus == 0) { hum_color = 'text-green' } else { hum_color = 'text-red' };
                    if (res[i].temp_satus == 0) { tem_color = 'text-green' } else { tem_color = 'text-red' }
                    $('.map-box tbody').append('<tr><td>' + res[i].row_id + '</td><td>' + res[i].customer_type + '</td><td>' + res[i].customer_name + '</td><td>' + res[i].collect_datetime + '</td><td class="' + tem_color + '">' + res[i].temperature + '℃</td><td class="' + hum_color + '">' + res[i].humidity + '%</td><td>' + res[i].collect_status + '</td></tr>')
                }
                $('.map_total_page').html(res[0].pages);
                $('.map_total_count').html(res[0].counts);
            } else {
                $('.nodata').removeClass('hidden');
            }
            $('.map_page_index').html(map_pageIndex);
            $('.map_page_size').html(map_pageSize);
        }
    })
}
// 获取其他不合格列表
function getOtherList(type, other_pageIndex, other_pageSize, jcitem_val, projectname_val, jcunit_val) {
    $('.other-box tbody').html('');
    $('.img_loading').removeClass('hidden');
    $('.nodata').addClass('hidden');
    let senddata = {
        type: type,
        test_item: jcitem_val,
        project_name: projectname_val,
        customer_name: jcunit_val,
        page_size: other_pageSize,
        page_index: other_pageIndex
    }
    $.ajax({
        url: baseUrl + '/ajax/GetCollectSampleList.ashx',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        data: senddata,
        success: res => {
            console.log('otherList:', res);
            $('.img_loading').addClass('hidden');
            if (res.length > 0) {
                for (let i = 0; i < res.length; i++) {
                    $('.other-box tbody').append(' <tr><td>' + res[i].sample_no + '</td><td>' + res[i].test_item + '</td><td title="' + res[i].project_name + '">' + res[i].project_name + '</td><td>' + res[i].sample_part + '</td><td>' + res[i].customer_name + '</td><td class="text-green">' + res[i].test_result + '</td></tr>')
                }
                $('.other_total_page').html(res[0].pages);
                $('.other_total_count').html(res[0].counts);
            } else {
                $('.nodata').removeClass('hidden');
            }
            $('.other_page_index').html(other_pageIndex);
            $('.other_page_size').html(other_pageSize);
        }
    })
}
// 获取开展服务列表
function getServiceList(service_pageIndex, service_pageSize, service_customer) {
    $('.service-box tbody').html('');
    $('.img_loading').removeClass('hidden');
    $('.nodata').addClass('hidden');
    let senddata = {
        page_index: service_pageIndex,
        page_size: service_pageSize,
        customer_name: service_customer
    }
    console.log('senddata:', senddata);
    $.ajax({
        url: baseUrl + '/ajax/GetStationBusinessList.ashx',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        data: senddata,
        success: res => {
            console.log('serviceList:', res);
            $('.img_loading').addClass('hidden');
            if (res.length > 0) {
                for (let i = 0; i < res.length; i++) {
                    $('.service-box tbody').append('<tr><td>' + res[i].customer_name + '</td><td>' + res[i].address + '</td><td>' + res[i].relation_name + '</td><td>' + res[i].relation_phone + '</td><td>' + res[i].credit_code + '</td></tr>')
                }
                $('.service_total_page').html(res[0].pages);
                $('.service_total_count').html(res[0].counts);
            } else {
                $('.nodata').removeClass('hidden');
            }
            $('.service_page_index').html(service_pageIndex);
            $('.service_page_size').html(service_pageSize);
        }
    })
}