$().ready(function() {
    var device_width = window.screen.width,
        screenType;
    if (device_width > 1800) {
        screenType = 'type1';
    } else if (device_width >= 1600 && device_width <= 1800) {
        screenType = 'type2';
    } else {
        screenType = 'type3';
    }
    getData();
    getMapData_people();
    getBehavior();
    getSp_check();
    get_unqua_info_today();
    get_rt1(0);
    get_rt2(0);
    behaviorScroll();
    setInterval(() => {
        if ($('.left-bar').hasClass('activeImg')) {
            console.log('检测人员动态跟踪');
            getMapData_people();
        } else if($('.right-bar').hasClass('activeImg')){
            console.log('标养室智慧物联');
            getMapData_room();
        } else if($('.right2-bar').hasClass('activeImg')){
            console.log("桩基检测")
            getMapData_ZJJC();
        }
    }, 300000);
    setInterval(() => {
        getData();
        if ($('.left-bar').hasClass('activeImg')) {
            getMapData_people();
        } else if($('.right-bar').hasClass('activeImg')){
            getMapData_room();
        } else if($('.right2-bar').hasClass('activeImg')){
            console.log("桩基检测")
            getMapData_ZJJC();
        }
        getBehavior();
        getSp_check();
        get_unqua_info_today();
        get_rt1(0);
        get_rt2(0);
        behaviorScroll();
    }, 3600000);
    getHeader();
})
window.onresize = function() {
        location.reload();
    }
//var baseUrl = 'https://detect.cnjsjd.net';
var baseUrl = '';
function getProjectPileCount(){
    $.ajax({
        url: baseUrl + "/Ajax/AppModules/ZjzCenter/Pile/GetProjectPileCount.ashx",
        type: "get",
        dataType: "json",
        success: function(data) {
            setProjectPileCount(data);
        },
        error: function(jqXHR) {
            console.log("发生错误：" + jqXHR.status);
        }
    })
}
function setProjectPileCount(data){
    $("#op_name").html(data.data[0].op_name);
    $("#area").html(data.data[0].area);
}

// 获取基本信息
function getHeader(){
    $(".header-item").html(`
        <div class="name">
            <p class="icon_font icon-ilogo-2"></p>
            <p class="icon_font icon-vertical_line"></p>
            <p><span id='area' style='display:none;'></span>检测监管云平台</p>
        </div>
        <div class="right-item">
            <div class="tab" id="head-tab">
                <div class="sub-tab hiddenImportant">
                    <p class="tab-item"><a href='#'>见证检测</a></p>
                    <span class="icon_font icon-vertical_line"></span>
                </div>
                <div class="sub-tab hiddenImportant">
                    <p class="tab-item"><a href='/screen/xcjc/pages/index.html'>现场检测</a></p>
                    <span class="icon_font icon-vertical_line"></span>
                </div>
                <div class="sub-tab hiddenImportant">
                    <p class="tab-item"><a href='/screen/pages/zjjc.html'>桩基检测</a></p>
                    <span class="icon_font icon-vertical_line"></span>
                </div>
                <div class="sub-tab hiddenImportant">
                    <p class="tab-item"><a href='/product_index/html/index.html'>商混检测</a></p>
                    <span class="icon_font icon-vertical_line"></span>
                </div>
                <div class="sub-tab hiddenImportant">
                    <p class="tab-item"><a href='#'>企业行为</a></p>
                </div>
            </div>
            <div class="user-info">
                <img src="#" id="avatar"/>
                <select class="input"><option id='op_name'>账号名称</option></select>
            </div>
        </div>`);
    $(".header-item .tab .tab-item:nth-child(3) a").addClass('active');
    // getProjectPileCount();
    getHeadData();
}

function getHeadData(){
    $.ajax({
        url: baseUrl + "/Ajax/Screen/GetHeaderInfo.ashx",
        type: "get",
        dataType: "json",
        success: function(data) {
            setHeadData(data);
        },
        error: function(jqXHR) {
            console.log("发生错误：" + jqXHR.status);
        }
    })
}
function setHeadData(data){
    var menu_key = data.data[0].menu_key.split(',');
    var max = Math.max(...menu_key);
    for(var i=0; i<menu_key.length; i++){
        if(menu_key[i]){
            $("#head-tab .sub-tab:nth-child("+menu_key[i]+")").removeClass("hiddenImportant");
            $("#head-tab .sub-tab:nth-child("+max+") span").addClass("hidden");
        }
    }
    $("#avatar").attr('src', data.data[0].op_avatar);
    $("#op_name").html(data.data[0].op_name);
    $("#area").html(data.data[0].area);
}

function getData() {
    $.ajax({
        url: baseUrl + '/ajax/GetStationCollect.ashx',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        success: function(res) {
            console.log('获取基本信息:', res)
            var datasource = res;
            if (datasource.length > 0) {
                datasource.forEach(ele => {
                    if ($("span[square_type='" + ele.square_type + "'][num='num1']")) {
                        $("span[square_type='" + ele.square_type + "'][num='num1']").text(ele.num1)
                    }
                    if ($("span[square_type='" + ele.square_type + "'][num='num2']")) {
                        $("span[square_type='" + ele.square_type + "'][num='num2']").text(ele.num2)
                    }
                    if ($("span[square_type='" + ele.square_type + "'][num='num3']")) {
                        $("span[square_type='" + ele.square_type + "'][num='num3']").text(ele.num3)
                    }
                    if ($("span[square_type='" + ele.square_type + "'][num='num4']")) {
                        $("span[square_type='" + ele.square_type + "'][num='num4']").text(ele.num4)
                    }
                    if ($("span[square_type='" + ele.square_type + "'][num='num5']")) {
                        $("span[square_type='" + ele.square_type + "'][num='num5']").text(ele.num5)
                    }
                    if ($("span[square_type='" + ele.square_type + "'][num='num6']")) {
                        $("span[square_type='" + ele.square_type + "'][num='num6']").text(ele.num6)
                    }
                })
                getProject_analyze_chart(datasource.filter(ele => {
                    return ele.square_type == 3
                })[0]);
                getPileFoundationDetection_1(0, datasource.filter(ele => {
                    return ele.square_type == 13
                })[0]);
                getPileFoundationDetection_2(0, datasource.filter(ele => {
                    return ele.square_type == 14
                })[0]);
                // 现场结构实体检验
                getSiteStructureTest1(0, datasource.filter(ele => {
                    return ele.square_type == 19
                })[0]);
                getSiteStructureTest2(0, datasource.filter(ele => {
                    return ele.square_type == 20
                })[0]);
                getSiteEnergyTest1(0, datasource.filter(ele => {
                    return ele.square_type == 21
                })[0]);
                getSiteEnergyTest2(0, datasource.filter(ele => {
                    return ele.square_type == 22
                })[0]);
                // getTestUnitAnalyze1(datasource.filter(ele => {
                //     return ele.square_type == 11
                // })[0], datasource.filter(ele => {
                //     return ele.square_type == 12
                // })[0]);
                // getTestUnitAnalyze2(datasource.filter(ele => {
                //     return ele.square_type == 10
                // })[0]);
                getlclkInfo(0, datasource.filter(ele => {
                    return ele.square_type == 23
                })[0], datasource.filter(ele => {
                    return ele.square_type == 24
                })[0], datasource.filter(ele => {
                    return ele.square_type == 25
                })[0]);
            }
        },
        error: function(res) {
            console.log('fail:', res)
        }
    });
}

function getMapData_room() {
    $.ajax({
        url: baseUrl + '/Ajax/GetEquipmentWSD.ashx',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        success: res => {
            // 获取地图legend数量
            $.ajax({
                url: baseUrl + '/Ajax/GetEquWSDCount.ashx',
                dataType: "jsonp",
                async: false,

                jsonp: 'jsonCallBack',
                headers: {
                    'Content-Type': 'application/json;charset=UTF-8'
                },
                success: res => {
                    $('.gdby_num').html(res[0].num1);
                    $('.jcbys_num').html(res[0].num2);
                    $('.lx_num').html(res[0].num3);
                    $('.zc_num').html(res[0].num4);
                    $('.wdyc_num').html(res[0].num5);
                    $('.sdyc_num').html(res[0].num6);
                }
            })
            getMap(1, res);
        }
    })
}
var op_code = '';

function getMapData_people() {
    $.ajax({
        url: baseUrl + '/ajax/GetTestPersonPosition.ashx',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        success: res => {
            console.log('人员地图success：', res);
            getMap(0, res);
            op_code = res[0].op_code;
        },
        error: res => {
            getMap(0, []);
            console.log('人员地图error:', res)
        }
    })
}

function getMapData_ZJJC(){
    $.ajax({
        url: baseUrl + '/ajax/ZJJC/GetStationZJJC.ashx?type=map_info',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        success: res => {
            console.log('桩基地图success：', res);
            // res = [{"SceneTask_id":158697,"pile_no":"K396","test_type":"行标快速(JGJ 106-2014)","max_load":5100.0,"start_time":"2021-12-30 00:50:38","upload_time":"2021-12-30 00:50:38","mapx":120.210792,"mapy":30.246026,"resource_code":null}]
            getMap(2, res);
        },
        error: res => {
            getMap(2, []);
            console.log('桩基地图error:', res)
        }
    })
}

function get_unqua_info_today() {
    $.ajax({
        url: baseUrl + '/ajax/GetUnqualifiedSample.ashx',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        success: res => {
            console.log('tableScroll:', res)
            if (res.length > 0) {
                tableScroll(res);
            } else {
                $('.tbl-body tbody').html('<div style="width:80px;margin-left:calc(50% - 40px);margin-top:40px">暂无数据</div>');
            }
        },
        error: res => {
            console.log('fail:', res)
        }
    })
}
// 累计受理情况饼图1
function get_rt1(type) {
    $.ajax({
        url: baseUrl + '/ajax/GetStationCollect.ashx?type=11',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        success: res => {
            let data1 = res;
            $.ajax({
                url: baseUrl + '/ajax/GetStationCollect.ashx?type=12',
                dataType: "jsonp",
                async: false,

                jsonp: 'jsonCallBack',
                headers: {
                    'Content-Type': 'application/json;charset=UTF-8'
                },
                success: res => {
                    let data2 = res;
                    getTestUnitAnalyze1(type, data1[0], data2[0]);
                }
            })
        }
    })
}
// 累计受理情况饼图2
function get_rt2(type) {
    $.ajax({
        url: baseUrl + '/ajax/GetStationCollect.ashx?type=10',
        dataType: "jsonp",
        async: false,

        jsonp: 'jsonCallBack',
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        success: res => {
            getTestUnitAnalyze2(type, res[0])
        }
    })
}