var map = {
    getMap: function(data, type){
        var options = {
            subdistrict: 0,
            extensions: 'all',
            level: 'province'
        };
        var district = new AMap.DistrictSearch(options);    
        district.search('杭州市', function(status, result) {
            var bounds = result.districtList[0]['boundaries'];
            var mask = [];
            for(var i =0;i<bounds.length;i++){
                mask.push([bounds[i]]);
            }
            var map = new AMap.Map("map", {
                mask: mask,
                expandZoomRange:true,
                mapStyle: 'amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2',
                resizeEnable: true,
                viewMode: '3D',
                showLabel: true
            });
            var district = null;
            var polygons=[];
            function drawBounds() {
                if(!district){
                    var opts = {
                        subdistrict: 0,
                        extensions: 'all',
                        level: 'district'
                    };
                    district = new AMap.DistrictSearch(opts);
                }
                //行政区查询
                district.setLevel('district')
                district.search($("#area").html(), function(status, result) {
                    map.remove(polygons)//清除上次结果
                    polygons = [];
                    var bounds = result.districtList[0].boundaries;
                    if (bounds) {
                        for (var i = 0, l = bounds.length; i < l; i++) {
                            var polygon = new AMap.Polygon({
                                strokeWeight: 1,
                                path: bounds[i],
                                fillOpacity: 0.4,
                                fillColor: '#80d8ff',
                                strokeColor: '#0091ea'
                            });
                            polygons.push(polygon);
                        }
                    }
                    map.add(polygons)
                    map.setFitView(polygons);//视口自适应
                });
            }
            drawBounds();
            var infoWindow = new AMap.InfoWindow({
                offset: new AMap.Pixel(0, -30)
            });
            if(type == 0){
                if(data.data){
                    for(var i = 0; i < data.data.length; i++) {
                        var item = data.data[i];
                        if(item.date_type == 0){ //今日
                            var marker = new AMap.Marker({
                                position: [item.mapx, item.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon_dwi_san.png"
                                }),
                                map: map
                            });
                        }else if(item.date_type == 1){ //本年
                            var marker = new AMap.Marker({
                                position: [item.mapx, item.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon_dwi_yi.png"
                                }),
                                map: map
                            });
                        }
                        marker.content=`<div class='marker-info'>
                            <div class='marker-info-left'>
                                <div class='name'>${item.project_name}</div>
                                <div class='info'>
                                    <div class='img'>
                                        <img src='${imgURL+item.Portrait}' />
                                    </div>
                                    <div class='value'>
                                        <p>部位：${item.sample_part}</p>
                                        <p>样品名称：${item.sample_name}</p>
                                        <p>姓      名：${item.op_name} / ${item.op_mobile}</p>
                                        <p>所属单位：${item.customer_name}</p>
                                    </div>
                                </div>
                            </div>
                            <div class='marker-info-right' onclick="map.getSampleSource('${item.sample_id}', 0)">
                                <p class='icon_font icon-suyuan-01'></p>
                                <p>样品溯源</p>
                            </div>
                        </div>`;
                        marker.on('mouseover', infoOpen);
                        marker.on('click', newMAp);
                    }
                    map.setZoomAndCenter(13, [Number(data.data[0].mapx), Number(data.data[0].mapy)]);
                }
            }else if(type == 1){
                if(data.data){
                    for(var i = 0; i < data.data.length; i++) {
                        var item = data.data[i];
                        if(item.temp_satus == 1 && item.hum_satus == 1){
                            var marker = new AMap.Marker({
                                position: [item.mapx, item.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon_dwi_purple.png"
                                }),
                                map: map
                            });
                        }else if(item.temp_satus == 0 && item.hum_satus == 0){
                            var marker = new AMap.Marker({
                                position: [item.mapx, item.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon_dwi_green.png"
                                }),
                                map: map
                            });
                        }else if(item.temp_satus == 1){
                            var marker = new AMap.Marker({
                                position: [item.mapx, item.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon_dwi_red.png"
                                }),
                                map: map
                            });
                        }else if(item.hum_satus == 1){
                            var marker = new AMap.Marker({
                                position: [item.mapx, item.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon_dwi_yellow.png"
                                }),
                                map: map
                            });
                        }
                        marker.content=`<div class='marker-info' style='height: auto;'>
                            <div class='marker-info-left' style='background: rgba(16, 82, 139, .9);'>
                                <div class='name'>${item.customer_name}</div>
                                <div class='info' style='border: .01rem solid rgba(13, 255, 236, .4); border-width: .01rem 0 .01rem 0; padding: .1rem 0;'>
                                    <div class='item' style='border-right: .01rem solid rgba(13, 255, 236, .4);'><p class='number red-text'>${item.temperature}℃</p><p>温度</p></div>
                                    <div class='item'><p class='number green-text'>${item.humidity}%</p><p>湿度</p></div>
                                </div>
                                <div class='date'>数据更新时间：${item.collect_datetime}</div>
                            </div>
                        </div>`;
                        marker.on('mouseover', infoOpen);
                        marker.on('click', newMAp);
                    }
                    map.setZoomAndCenter(13, [Number(data.data[0].mapx), Number(data.data[0].mapy)]);
                }
            }
            function newMAp(e) {
                var infoWindow = new AMap.InfoWindow({
                    offset: new AMap.Pixel(0, -30)
                });
                infoWindow.setContent(e.target.content);
                infoWindow.open(map, e.target.getPosition());
            }
    
            function infoOpen(e) {
                infoWindow.setContent(e.target.content);
                infoWindow.open(map, e.target.getPosition());
            }

            map.setMapStyle('amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2');
        })
    },
    getSampleSource(sample_id, type){
        $.ajax({
            url: baseURL_jzjc+"GetSampleSource.ashx?sample_id="+sample_id,//+'E9DAC6DC-EC0E-4499-9EE3-B07C6FE711B3',
            type: "post",
            dataType: "json",
            success: function(data) {
                if(type == 0){
                    map.setSampleSource(data);
                }else if(type == 1){
                    $("#popup-info .popup-content3 .content-panel1 .main").html('');
                    if(data.data.test_data){
                        $("#popup-info .popup-content3 .content-panel1 .main").html(data.data.test_data);
                        var iNum = $("#popup-info .popup-content3 .content-panel1 .main .container").length;
                        for (var i = 1; i <= iNum; i++) {
                            var hfID = "#HiddenField" + i;
                            var CID = "#container" + i;
                            var sTitle1 = "#HfTitle1_" + i;
                            var sTitle2 = "#HfTitle" + i;
                            var seriesName = "试验曲线" + i;
                            VnetChart(hfID, CID, sTitle1, sTitle2, "荷载(kN)", seriesName);
                        } 
                    }else{
                        $("#popup-info .popup-content3 .content-panel1 .main").html('<div class="noData">暂无数据</div>');
                    }
                }
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setSampleSource(data){
        var item = data.data;
        // 现场取样
        $("#popup-info .popup-content1 .content-panel2").html(`
            <p>样品编号：${item.sample_no}</p>
            <p>检测项目：${item.jc_item}</p>
            <p>检测单位：${item.customer_name}</p>
            <p>施工单位：${item.sg_unit}</p>
            <p>工程名称：${item.project_name}</p>
            <p>上传时间：${item.upload_time}</p>
            <p>备&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;注：${item.remark}</p>
        `);
        $("#popup-info .popup-content1 .content-panel3").html('');
        if(item.photo_list && item.photo_list.length>0){
            $("#popup-info .popup-content1 .content-panel3").append(`
                ${
                    item.photo_list.map((item1) => {
                        return(`
                            <img class="img" src="${imgURL+item1.file_path}">
                        `)
                    }).join('')
                }
            `);
        }else{
            $("#popup-info .popup-content1 .content-panel3").html(`<div class="noData">暂无数据</div>`);
        }
        map.getYPZSmap(item);

        // 试验图像
        $("#popup-info .popup-content2 .content-panel1").html('');
        if(item.test_photo){
            $("#popup-info .popup-content2 .content-panel1").html(item.test_photo);
        }else{
            $("#popup-info .popup-content2 .content-panel1").html('<div class="noData">暂无数据</div>');
        }

        // 数据曲线
        $("#popup-info .popup-content3 .content-panel1 .select").html('');

        $("#sybh-select").click(function(){
            var myselect=document.getElementById("sybh-select");
            var index=myselect.selectedIndex ; 
            var sample_id = myselect.options[index].value;
            console.log(sample_id)
            map.getSampleSource(sample_id, 1);
        });
        if(item.samples_info && item.samples_info.length>0){
            $("#popup-info .popup-content3 .content-panel1 .select").append(`
                ${
                    item.samples_info.map((item1) => {
                        return(`
                            <option value='${item1.sample_id}+'>${item1.sample_no}</option>
                        `)
                    }).join('')
                }
            `);
        }
        $("#popup-info .popup-content3 .content-panel1 .main").html('');
        if(item.test_data){
            $("#popup-info .popup-content3 .content-panel1 .main").html(item.test_data);
            var iNum = $("#popup-info .popup-content3 .content-panel1 .main .container").length;
            for (var i = 1; i <= iNum; i++) {
                var hfID = "#HiddenField" + i;
                var CID = "#container" + i;
                var sTitle1 = "#HfTitle1_" + i;
                var sTitle2 = "#HfTitle" + i;
                var seriesName = "试验曲线" + i;
                VnetChart(hfID, CID, sTitle1, sTitle2, "荷载(kN)", seriesName);
            } 
        }else{
            $("#popup-info .popup-content3 .content-panel1 .main").html('<div class="noData">暂无数据</div>');
        }

        // 报告信息
        if(item.report_info && item.report_info.length>0){
            if(item.report_info[0].report_print_pdf){
                $("#popup-info .popup-content4 .content-panel1").html(`<iframe src="${item.report_info[0].report_print_pdf}" frameborder="0"></iframe>`);
            }else{
                $("#popup-info .popup-content4 .content-panel1").html(`<div class="noData">暂无数据</div>`);
            }
        }
        $("#popup-info .popup-content4 .content-panel-group").html('');
        if(item.report_info && item.report_info.length>0){
            $("#popup-info .popup-content4 .content-panel-group").append(`
                <div class="content-panel content-panel2">
                    <div class="item"><p class="type">报告编号：</p><p class="value">${item.report_info[0].report_no}</p></div>
                    <div class="item"><p class="type">工程名称：</p><p class="value">${item.report_info[0].project_name}</p></div>
                    <div class="item"><p class="type">检测项目：</p><p class="value">${item.report_info[0].report_title}</p></div>
                    <div class="item"><p class="type">报告日期：</p><p class="value">${item.report_info[0].report_date}</p></div>
                </div>
            `);
        }
        $("#popup-info .popup-content4 .content-panel-group").append('<div class="content-panel content-panel3"></div>');
        if(item.report_curr && item.report_curr.length > 0){
            $("#popup-info .popup-content4 .content-panel-group .content-panel3").append(`
                ${
                    item.report_curr.map((item1) => {
                        return(`
                            <div class="content-panel">
                                <div class="item"><p class="type">操作：</p><p class="value">${item1.op_name}(${item1.curr_datetime})</p></div>
                                <div class="item"><p class="type">结果：</p>
                                    ${item1.curr_kind == '报告签发' ? '<p class="value bgqf bg-icon">'+item1.curr_kind+'</p>' : ''}
                                    ${item1.curr_kind == '报告审核' ? '<p class="value bgsh bg-icon">'+item1.curr_kind+'</p>' : ''}
                                    ${item1.curr_kind == '报告编辑' ? '<p class="value bgbj bg-icon">'+item1.curr_kind+'</p>' : ''}
                                </div>
                            </div>
                        `)
                    }).join('')
                }
            `);
        }else{
            $("#popup-info .popup-content4 .content-panel-group .content-panel3").html('<div class="noData">暂无数据</div>');
        }

        $("#popup-info .sub-menu p").click(function(){
            $("#popup-info .sub-menu p").removeClass("active");
            $(this).addClass("active");
            let id = $(this).attr("data-id");
            $("#popup-info .popup-content").addClass('hiddenImportant');
            $("#popup-info .popup-"+id).removeClass('hiddenImportant');
        })
        layer.open({
            type: 1, 
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>检测全过程追溯</p>",
            area: ['60%', '70%'],
            content: $('#popup-info'),
            end: function(){
                $("#popup-info .sub-menu p").removeClass("active");
                $("#popup-info .sub-menu p:first-child").addClass("active");
                $("#popup-info .popup-content").addClass('hiddenImportant');
                $("#popup-info .popup-content1").removeClass('hiddenImportant');
                $("#popup-info").css('display', 'none');
            }
        }); 
    },
    getYPZSmap(data){
        function computeDis(){
            var lnglat = new AMap.LngLat(data.mapx, data.mapy);
            var myDistance = lnglat.distance([data.unit_mapx, data.unit_mapy]);
            return (myDistance/1000).toFixed(2);
        }
    
        if(data.mapx && data.mapy){
            var map = new AMap.Map("ypzsMap", {
                resizeEnable: true,
                showLabel: true,
                center: [data.mapx, data.mapy]
            });
        }else{
            var map = new AMap.Map("ypzsMap", {
                resizeEnable: true,
                showLabel: true,
                center: [120.152575,30.266619]
            });
        }
        map.setZoom(12);
    
        var infoWindow = new AMap.InfoWindow({
            offset: new AMap.Pixel(0, -30)
        });

        if(data.mapx && data.mapy){
            // 取样地点
            var marker1 = new AMap.Marker({
                position: [Number(data.mapx), Number(data.mapy)],
                icon: new AMap.Icon({
                    size: new AMap.Size(50, 50),
                    image: '../static/images/ico_gdsdyc.gif',
                    imageSize: new AMap.Size(50, 50)
                }),
                offset: new AMap.Pixel(-20, -50),
                map: map
            });
    
            if(data.unit_mapx && data.unit_mapy && data.unit_mapx != 0){
                marker1.setLabel({
                    content: "<div style='padding: .1rem'>起点:取样地点<p style='margin-top: .1rem'>距离"+computeDis()+"km</p></div>",
                    direction: 'right'
                });
            }else{
                marker1.setLabel({
                    content: "<div style='padding: .1rem'>起点:取样地点</div>",
                    direction: 'right'
                });
            }
        }

        if(data.unit_mapx && data.unit_mapy && data.unit_mapx != 0){
            // 终点
            var marker = new AMap.Marker({
                position: [data.unit_mapx,data.unit_mapy],
                icon: new AMap.Icon({
                    size: new AMap.Size(50, 50),
                    image: '../static/images/ico_gdzc.gif',
                    imageSize: new AMap.Size(50, 50)
                }),
                offset: new AMap.Pixel(-30, -50),
                map: map
            });
    
            marker.setLabel({
                content: "<div>终点:试验室</div>",
                direction: 'right'
            });
        }

        if(data.mapx && data.mapy && data.unit_mapx && data.unit_mapy && data.unit_mapx != 0){
            // 绘制轨迹
            var lineArr = [[data.mapx, data.mapy],[data.unit_mapx,data.unit_mapy]];
    
            var polyline = new AMap.Polyline({
                map: map,
                path: lineArr,
                showDir:true,
                strokeColor: "#f9e4c9",  //线颜色
                strokeWeight: 3,      //线宽
            });
    
            // 线条
            var passedPolyline = new AMap.Polyline({
                map: map,
                path: lineArr,
                strokeColor: "#ffb034",  //线颜色
                strokeWeight: 3,      //线宽
            });
    
            // 行人图标
            markerPerson = new AMap.Marker({
                map: map,
                position: [data.mapx, data.mapy],
                icon:new AMap.Icon({
                    size: new AMap.Size(25, 25),
                    image: "../static/images/xingren.png",
                    imageSize: new AMap.Size(25, 25)
                }),
            });
    
            markerPerson.on('moving', function (e) {
                passedPolyline.setPath(e.passedPath);
            });
    
            startAnimation();
        }
        function startAnimation() {
            markerPerson.moveAlong(lineArr, 5000);
        }
        
        map.setMapStyle('amap://styles/ae577d25e14f898373a7c41e4b4e6957');
    }
}

var getLeftData = {
    init: function(){
        this.getSummaryInfo();
    },
    getSummaryInfo: function(){
        $.ajax({
            url: baseURL_jzjc+"GetSummaryInfo.ashx",
            type: "post",
            dataType: "json",
            success: function(data) {
                getLeftData.setSummaryInfo(data);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setSummaryInfo: function(data){
        var wt_gj_total = 0;
        var wt_gj_data = [];
        var wt_hnt_total = 0;
        var wt_hnt_data = [];
        var qy_gj_total = 0;
        var qy_gj_data = [];
        var qy_hnt_total = 0;
        var qy_hnt_data = [];
        var sy_gj_total = 0;
        var sy_gj_data = [];
        var sy_hnt_total = 0;
        var sy_hnt_data = [];

        var xAxis_data = [];
        data.data.forEach(item => {
            wt_gj_total = wt_gj_total + Number(item.wt_gj);
            wt_gj_data.push(Number(item.wt_gj));
            wt_hnt_total = wt_hnt_total + Number(item.wt_hnt);
            wt_hnt_data.push(Number(item.wt_hnt));
            qy_gj_total = qy_gj_total + Number(item.qy_gj);
            qy_gj_data.push(Number(item.qy_gj));
            qy_hnt_total = qy_hnt_total + Number(item.qy_hnt);
            qy_hnt_data.push(Number(item.qy_hnt));
            sy_gj_total = sy_gj_total + Number(item.sy_gj);
            sy_gj_data.push(Number(item.sy_gj));
            sy_hnt_total = sy_hnt_total + Number(item.sy_hnt);
            sy_hnt_data.push(Number(item.sy_hnt));

            xAxis_data.push(item.day);
        });
        $("#wt_gj").html(wt_gj_total);
        $("#wt_hnt").html(wt_hnt_total);
        $("#qy_gj").html(qy_gj_total);
        $("#qy_hnt").html(qy_hnt_total);
        $("#sy_gj").html(sy_gj_total);
        $("#sy_hnt").html(sy_hnt_total);
        getLeftData.getchart('wthz-chart', wt_gj_data, wt_hnt_data, xAxis_data, ['#47DB78', '#FFE92F']);
        getLeftData.getchart('qyhz-chart', qy_gj_data, qy_hnt_data, xAxis_data, ['#3FD9FF', '#F77345']);
        getLeftData.getchart('syhz-chart', sy_gj_data, sy_hnt_data, xAxis_data, ['#7A96F4', '#F9729F']);
    },
    getchart: function(id, gj_data, hnt_data, xAxis_data, numberColor){
        var series_data = [];
        var color = [];
        if(id == 'wthz-chart'){
            series_data = [{
                name: '钢筋',
                type: 'line',
                symbol: "none",
                data: gj_data,
                color: 'rgba(16, 234, 182, .6)',
                areaStyle: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1,[{
                            offset: 0, color: 'rgba(16, 234, 182, .3)'
                        }, {
                            offset: 0.6, color: 'rgba(16, 234, 182, .1)'
                        }, {
                            offset: 1, color: 'rgba(16, 234, 182, .0)'
                        }]
                    ),
                },
                smooth: true
            },{
                name: '混凝土',
                type: 'line',
                symbol: "none",
                data: hnt_data,
                color: 'rgba(19, 197, 218, .6)',
                areaStyle: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1,[{
                            offset: 0, color: 'rgba(19, 197, 218, 0.3)'
                        }, {
                            offset: 0.6, color: 'rgba(19, 197, 218, 0.1)'
                        }, {
                            offset: 1, color: 'rgba(19, 197, 218, 0)'
                        }]
                    ),
                },
            }]
        }else if(id == 'qyhz-chart'){
            series_data = [{
                name: '钢筋',
                data: gj_data,
                type: 'bar',
                barWidth: '12%'
            },{
                name: '混凝土',
                data: hnt_data,
                type: 'bar',
                barWidth: '12%'
            }]
            color = [{
                y2: 1,
                colorStops: [
                    { offset: 0, color: '#309BFF' },
                    { offset: 1, color: '#15D7EE' }]
                },{
                y2: 1,
                colorStops: [
                    { offset: 0, color: '#ED4A5E' },
                    { offset: 1, color: '#E36B4B' }]
            }]
        }else if(id == 'syhz-chart'){
            series_data = [{
                name: '钢筋',
                data: gj_data,
                type: 'bar',
                barWidth: '12%'
            },{
                name: '混凝土',
                type: 'line',
                symbol: "none",
                data: hnt_data,
                areaStyle: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1,[{
                            offset: 0, color: 'rgba(122, 150, 244, .6)'
                        }, {
                            offset: 0.6, color: 'rgba(122, 150, 244, .4)'
                        }, {
                            offset: 1, color: 'rgba(122, 150, 244, .2)'
                        }]
                    ),
                },
            }];
            color = [{
                y2: 1,
                colorStops: [
                    { offset: 0, color: '#309BFF' },
                    { offset: 1, color: '#15D7EE' }]
                },{
                    color: 'rgba(122, 150, 244, .8)'
                }];
        }
        echarts.init(document.getElementById(id)).dispose();
        var dom = document.getElementById(id);
        var myChart = echarts.init(dom);
        var option;
        option = {
            tooltip: {
                show: true,
                trigger: "axis",
                backgroundColor: 'rgba(0, 0, 0, .2)',
                textStyle: {
                    color: '#fff'
                },
                borderColor: 'rgba(0, 0, 0, .2)',
                formatter: (params)=> {
                    return  `<p>钢筋：<span style='color: ${numberColor[0]}'>${params[0].value}</span></p><p>混凝土：<span class='number' style='color: ${numberColor[1]}'>${params[1].value}</span></p>`;
                }
            },
            grid: {
                top: "5%",
                bottom: "5%",
                left: "5%",
                right: "5%",
                containLabel:true
            },
            color: color,
            xAxis: {
                type: 'category',
                interval: 3,
                data: xAxis_data,
                axisLine:{
                    show: true,
                    lineStyle:{
                        color:'rgba(11, 47, 109, .8)'
                    }
                },
                axisLabel: {
                    textStyle: {
                        color: '#A5B5C5',
                        fontSize : 12
                    }
                },
                axisTick: {
                    show: false
                },   
            },
            yAxis: {
                type: 'value',
                axisLine:{
                    show: true,
                    lineStyle:{
                        color:'rgba(11, 47, 109, .8)'
                    }
                },
                axisLabel: {
                    textStyle: {
                        color: '#A5B5C5',
                        fontSize : '12'
                    }
                },
                splitLine: {
                    "show": true,
                    lineStyle:{
                        color:'rgba(255, 255, 255, .2)',
                        type: 'dashed'
                    }
                },
            },
            series: series_data
        };

        myChart.setOption(option);
        $(function(){ 
            window.onresize = function () {
                myChart.resize();
            }
        })
    }
}

var getTopData = {
    init: function(){
        this.toggleTab();
    },
    toggleTab: function(){
        $(".top-item .tab p").click(function(){
            $(".top-item .tab p").removeClass('active');
            $(this).addClass('active');
        })
    }
}

var getCenterData = {
    init: function(){
        this.getSign(0);
    },
    getSign: function(type){
        $("#map").html('');
        if(type == 0){ //动态追溯
            $('.content .center-item').html(`
                <p><span class="icon_font icon-icon_dwi_yi" style="color: #ff9a49;"></span>今日见证检测人员</p>
                <p><span class="icon_font icon-icon_dwi_yi" style="color: #00FFA2;"></span>本月见证检测人员</p>
            `);
            getCenterData.getSamplePosition(type);
        }else if(type == 1){ //智慧养护
            $('.content .center-item').html(`
                <p><span class="icon_font icon-icon_dwi_er-01" style="color: #ff585b;"></span>温度预警</p>
                <p><span class="icon_font icon-icon_dwi_er-01" style="color: #ff9a49;"></span>湿度预警</p>
                <p><span class="icon_font icon-icon_dwi_er-01" style="color: #d366f8;"></span>温湿度预警</p>
                <p><span class="icon_font icon-icon_dwi_er-01" style="color: #01f49e;"></span>养护室正常</p>
            `);
            getCenterData.getCuringRoomPosition(type);
        }
    },
    getSamplePosition: function(type){
        $.ajax({
            url: baseURL_jzjc+"GetSamplePosition.ashx",
            type: "post",
            dataType: "json",
            success: function(data) {
                map.getMap(data, type);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    getCuringRoomPosition: function(type){
        $.ajax({
            url: baseURL_jzjc+"GetCuringRoomPosition.ashx",
            type: "post",
            dataType: "json",
            success: function(data) {
                map.getMap(data, type);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    }
}

var getBottomData = {
    init: function(){
        this.getJZQYCompanyDate();
        this.getProjectTestRankDate();
    },
    getJZQYCompanyDate: function(){
        $("#jzqy-date .begin").html(getNextDate(dateFormat('YYYY-mm-dd',new Date()),-1));
        $("#jzqy-date .end").html(dateFormat('YYYY-mm-dd',new Date()));
        this.getJZQYCompanyList();
    },
    getJZQYCompanyList: function(){
        $.ajax({
            url: baseURL_jzjc+"GetJZQYCompanyList.ashx?begin_date="+$("#jzqy-date .begin").html()+"&end_date="+$("#jzqy-date .end").html(),
            type: "get",
            dataType: "json",
            success: function(data) {
                getBottomData.setJZQYCompanyList(data);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setJZQYCompanyList: function(data){
        $(".content .bottom-item .panel-item1 .list .table-body tbody").html('');
        $(".content .bottom-item .panel-item1 .list .table-body tbody").append(`
            ${
                data.data.map(item => {
                    return(`
                        <tr>
                            <td width="35%">${item.customer_name}</td>
                            <td width="10%">${item.equ_count}</td>
                            <td width="10%">${item.monitor_count}</td>
                            <td width="10%">${item.wsd_count}</td>
                            <td width="10%">${item.project_count}</td>
                            <td width="10%">${item.test_count}</td>
                            <td width="15%" style="color: #FFAA23;">${item.bhg_rate}
                                ${item.trend == 'up' ? '<span class="icon_font icon-shangsheng-01 red-text"></span>' : ''}
                                ${item.trend == 'down' ? '<span class="icon_font icon-wweqg-01 green-text"></span>' : ''}
                                ${item.trend == '' ? '<span class="icon_font icon-ln_hengxiangzhankai"></span>' : ''}
                            </td>
                        </tr>
                    `)
                }).join('')
            }
        `);
    },
    getProjectTestRankDate: function(){
        $("#bhg-date .begin").html(getNextDate(dateFormat('YYYY-mm-dd',new Date()),-1));
        $("#bhg-date .end").html(dateFormat('YYYY-mm-dd',new Date()));
        this.getProjectTestRank();
    },
    getProjectTestRank: function(){
        $.ajax({
            url: baseURL_jzjc+"GetProjectTestRank.ashx?begin_date="+$("#bhg-date .begin").html()+"&end_date="+$("#bhg-date .end").html(),
            type: "get",
            dataType: "json",
            success: function(data) {
                getBottomData.setProjectTestRank(data);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setProjectTestRank: function(data){
        $(".content .bottom-item .panel-item2 .list .table-body tbody").html('');
        $(".content .bottom-item .panel-item2 .list .table-body tbody").append(`
            ${
                data.data.map(item => {
                    return(`
                    <tr>
                    <td width="35%">${item.project_name}</td>
                    <td width="12%">${item.hnt_count}</td>
                    <td width="12%">${item.gj_count}</td>
                    <td width="12%">${item.test_count}</td>
                    <td width="12%"><span class="icon_font icon-xinpian-01-01 ${item.is_code == 0 ? 'blue-xp': 'gray-xp'}"></span></td>
                    <td width="17%" style="color: #FFAA23;">${item.bhg_rate}%
                        ${item.trend == 'up' ? '<span class="icon_font icon-shangsheng-01 red-text"></span>' : ''}
                        ${item.trend == 'down' ? '<span class="icon_font icon-shangsheng-01 green-text"></span>' : ''}
                        ${item.trend == '' ? '<span class="icon_font icon-ln_hengxiangzhankai"></span>' : ''}
                    </td>
                </tr>
                    `)
                }).join('')
            }
        `);
    }
}

var getRightData = {
    init: function(){
        this.getConcreteGuaranteeDate();
        this.getJZQYPhotos();
    },
    // 混凝土保证率
    getConcreteGuarantee: function(){
        $(".content .right-item .panel-item1 .panel-info").html('<div class="noData">暂无数据</div>');
        $.ajax({
            url: baseURL_jzjc+"GetConcreteGuarantee.ashx?begin_date="+$("#hntbzl-date .begin").html()+"&end_date="+$("#hntbzl-date .end").html(),
            type: "get",
            dataType: "json",
            success: function(data) {
                getRightData.setConcreteGuarantee(data);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    getConcreteGuaranteeDate: function(){
        $("#hntbzl-date .begin").html(getNextDate(dateFormat('YYYY-mm-dd',new Date()),-30));
        $("#hntbzl-date .end").html(dateFormat('YYYY-mm-dd',new Date()));
        this.getConcreteGuarantee();
    },
    setConcreteGuarantee(data){
        $(".content .right-item .panel-item1 .panel-info").html('');
        $(".content .right-item .panel-item1 .panel-info").append(`
            ${
                data.data.map(item => {
                    return(`
                        <div class="item">
                            <div class="name">${item.strength_grade}</div>
                            <div class="bar-item">
                                <div class="bar-bg"></div>
                                <div class="bar-rate" style='width: ${100 - item.guarantee_rate}%'></div>
                            </div>
                            <div class="rate">${item.guarantee_rate}%</div>
                        </div>
                    `)
                }).join('')
            }
        `);
    },
    getJZQYPhotos(){
        $(".content .right-item .panel-item1 .panel-info").html('<div class="noData">暂无数据</div>');
        $.ajax({
            url: baseURL_jzjc+"GetJZQYPhotos.ashx",
            type: "get",
            dataType: "json",
            success: function(data) {
                getRightData.setJZQYPhotos(data);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setJZQYPhotos(data){
        $(".content .right-item .panel-item2 .panel-info").html('');
        if(data.data && data.data.length>0){
            $(".content .right-item .panel-item2 .panel-info").append(`
                ${
                    data.data.map(item => {
                        return(`
                            <div class="item">
                                <img src="${imgURL+item.file_path}" />
                                <div class="name">${item.sample_no}</div>
                            </div>
                        `)
                    }).join('')
                }
            `);
        }else{
            $(".content .right-item .panel-item1 .panel-info").html('<div class="noData">暂无数据</div>');
        }
    }
}

$(function(){
    layui.use(['layer', 'laydate'],function(){
        var layer=layui.layer;
        var laydate = layui.laydate;
        laydate.render({ 
            elem: '#jzqy-date .begin'
            ,btns: ['confirm']
            ,done: function(){
                getBottomData.getJZQYCompanyList();
            }
        });
        laydate.render({ 
            elem: '#jzqy-date .end'
            ,btns: ['confirm']
            ,done: function(){
                getBottomData.getJZQYCompanyList();
            }
        });
        laydate.render({ 
            elem: '#hntbzl-date .begin'
            ,btns: ['confirm']
            ,done: function(){
                getRightData.getConcreteGuarantee();
            }
        });
        laydate.render({ 
            elem: '#hntbzl-date .end'
            ,btns: ['confirm']
            ,done: function(){
                getRightData.getConcreteGuarantee();
            }
        });
        laydate.render({ 
            elem: '#bhg-date .begin'
            ,btns: ['confirm']
            ,done: function(){
                getBottomData.getProjectTestRank();
            }
        });
        laydate.render({ 
            elem: '#bhg-date .end'
            ,btns: ['confirm']
            ,done: function(){
                getBottomData.getProjectTestRank();
            }
        });
    });
    getHeader();
    getLeftData.init();
    getTopData.init();
    getCenterData.init();
    getBottomData.init();
    getRightData.init();
}); 