new Vue({
    el: '#app',
    data: function() {
        return {
            access_token: '',
            info: {},
            testSummary: {},
            unitCert: {},
            unusualInfo: [],
            projectData: [],
            IoT: {},
            popType: 1, //1:检测人员列表; 2:企业资质列表, 3:检测设备列表
            data: [],
            pager:{
                page: 1,
                limit: 10,
                pagecount: 1,
                totalcount: 0,
                topage: ''
            },
            zzParam: {
                certificate_kind: -1,
                customer_name: '',
                certificate_no: '',
                certificateData: 
                    [{title: '全部', id: -1}, 
                    {title: '公路甲级', id: 0}, 
                    {title: '公路乙级', id: 1}, 
                    {title: '公路丙级', id: 2}, 
                    {title: '水运甲级', id: 3}, 
                    {title: '水运乙级', id: 4}, 
                    {title: '水运丙级', id: 5}],
            },
            ryParam:{
                sex: -1,
                customer_name: '',
                op_name: '',
                sexData: 
                    [{title: '全部', id: -1}, 
                    {title: '男', id: 0}, 
                    {title: '女', id: 1}]
            },
            sbParam: {
                status: -1,
                customer_name: '',
                equ_no: '',
                equ_name: '',
                statusData: 
                    [{title: '全部', id: -1}, 
                    {title: '停用', id: 0}, 
                    {title: '启用', id: 1}]
            }
        }
    },
    created(){
        this.getToken();
    },
    methods:{
        getToken(){
            let _this = this;
            let timestamp = getTimestamp();
            let sortdata = {
                api_key,
                timestamp,
            }
            var sign = md5(sort(sortdata)+api_secret);
            var data = {
                api_key,
                timestamp,
                sign
            }
            console.log(JSON.stringify(data))
            $.ajax({
                url: baseurl + "auth/access",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                data: JSON.stringify(data),
                success: function (data) {
                    _this.access_token = data.data.access_token;
                    access_token = data.data.access_token;
                    _this.GetSessionInfo();
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        GetSessionInfo(){
            let _this = this;
            let data = {
                token: "ADA90463-7ABE-4564-83A6-B6BB278975D0"
            }
            $.ajax({
                url: baseurl + "screen/GetSessionInfo",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    _this.info = data.data;
                    station_id = data.data.station_id;
                    setTimeout(() => {
                        map.getData();
                    }, 2000);
                    _this.init();
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        init(){
            // 检测汇总
            this.GetTestSummary();
            // 企业资质
            this.GetUnitCert();
            // 异常信息
            this.GetUnusualInfo();
            // 工程数据
            this.GetProjectData();
            // 物联数据
            this.GetIoTData();
        },
        GetTestSummary(){
            let _this = this;
            let data = {
                station_id: _this.info.station_id
            }
            $.ajax({
                url: baseurl + "screen/GetTestSummary",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    _this.testSummary = data.data;
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        GetUnitCert(){
            let _this = this;
            let data = {
                station_id: _this.info.station_id
            }
            $.ajax({
                url: baseurl + "screen/GetUnitCert",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    _this.unitCert = data.data;
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        GetUnusualInfo(){
            let _this = this;
            let data = {
                station_id: _this.info.station_id
            }
            $.ajax({
                url: baseurl + "screen/GetUnusualInfo",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    _this.unusualInfo = data.data;
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        GetProjectData(){
            let _this = this;
            let data = {
                station_id: _this.info.station_id
            }
            $.ajax({
                url: baseurl + "screen/GetProjectData",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    _this.projectData = data.data;
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        GetIoTData(){
            let _this = this;
            let data = {
                station_id: _this.info.station_id
            }
            $.ajax({
                url: baseurl + "screen/GetIoTData",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    _this.IoT = data.data;
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        showPopup(title) {
            this.data = [];
            this.dataInit();
            layui.use('layer', function () {
                var layer = layui.layer;
                layer.open({
                    type: 1,
                    content: $("#app"),
                    shadeClose: true,
                    maxmin: true,
                    title: "<p class='popup-title'>"+title+"</p>",
                    area: ['13rem', '75%'],
                    content: $('#popup-info'),
                    success: function (layero) {
                        //把内容放到遮罩层里
                        var mask = $(".layui-layer-shade");
                        mask.appendTo(layero.parent());
                    },
                    // end: function () {
                    //     $("#popup-info").css('display', 'none');
                    // }
                });
            });
        },
        dataInit(){
            this.pager = {
                page: 1,
                limit: 10,
                pagecount: 1,
                totalcount: 0
            }
        },
        handleCurrentChange(val) {
            console.log(`当前页: ${val}`);
            this.pager.page = val;
            if(this.popType == 1){
                this.GetUnitPersonList(); //人员列表
            }
            if(this.popType == 2){
                this.GetUnitCertList(); //资质列表
            }
            if(this.popType == 3){
                this.GetUnitEquList(); //设备列表
            }
        },
        search(){
            this.handleCurrentChange(1);
        },
        qyzzpopup(id){
            let _this = this;
            _this.popType = 2;
            _this.showPopup('企业资质列表');
            _this.zzParam.certificate_kind = id;
            this.GetUnitCertList();
        },
        GetUnitCertList(){
            let _this = this;
            const loading = this.$loading({
                lock: true,
                text: 'Loading',
                spinner: 'el-icon-loading',
                background: 'rgba(0, 0, 0, 0.7)'
            });
            let data = {
                station_id: _this.info.station_id,
                data: {
                    certificate_kind: _this.zzParam.certificate_kind,
                    customer_name: _this.zzParam.customer_name,
                    certificate_no: _this.zzParam.certificate_no
                },
                pager: _this.pager
            }
            $.ajax({
                url: baseurl + "screen/GetUnitCertList",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    loading.close();
                    _this.data = [];
                    if(data.status == 200){
                        _this.data = data.data;
                        if(_this.data && _this.data.length > 0){
                            _this.pager.pagecount = _this.data[0].pagecount;
                            _this.pager.totalcount = _this.data[0].totalcount;
                        }else{
                            _this.pager.pagecount = 1;
                            _this.pager.totalcount = 0;
                        }
                    }else{
                        _this.$message(data.msg);
                    }
                },
                error: function (jqXHR) {
                    loading.close();
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        jcsbpopup(id){
            let _this = this;
            _this.popType = 3;
            _this.showPopup('检测设备列表');
            _this.sbParam.status = id;
            this.GetUnitEquList();
        },
        GetUnitEquList(){
            let _this = this;
            const loading = this.$loading({
                lock: true,
                text: 'Loading',
                spinner: 'el-icon-loading',
                background: 'rgba(0, 0, 0, 0.7)'
              });
            let data = {
                station_id: _this.info.station_id,
                data: {
                    status: _this.sbParam.status,
                    customer_name: _this.sbParam.customer_name,
                    equ_name: _this.sbParam.equ_name,
                    equ_no: _this.sbParam.equ_no
                },
                pager: _this.pager
            }
            $.ajax({
                url: baseurl + "screen/GetUnitEquList",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    loading.close();
                    _this.data = [];
                    if(data.status == 200){
                        _this.data = data.data;
                        if(_this.data && _this.data.length > 0){
                            _this.pager.pagecount = _this.data[0].pagecount;
                            _this.pager.totalcount = _this.data[0].totalcount;
                        }else{
                            _this.pager.pagecount = 1;
                            _this.pager.totalcount = 0;
                        }
                    }else{
                        _this.$message(data.msg);
                    }
                },
                error: function (jqXHR) {
                    loading.close();
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        jcrypopup(id){
            let _this = this;
            _this.popType = 1;
            _this.showPopup('检测人员列表');
            _this.ryParam.sex = id;
            this.GetUnitPersonList();
        },
        GetUnitPersonList(){
            let _this = this;
            const loading = this.$loading({
                lock: true,
                text: 'Loading',
                spinner: 'el-icon-loading',
                background: 'rgba(0, 0, 0, 0.7)'
              });
            let data = {
                station_id: _this.info.station_id,
                data: {
                    sex: _this.ryParam.sex,
                    customer_name: _this.ryParam.customer_name,
                    op_name: _this.ryParam.op_name
                },
                pager: _this.pager
            }
            $.ajax({
                url: baseurl + "screen/GetUnitPersonList",
                type: "post",
                dataType: "json",
                contentType: "application/json",
                headers:{
                    Authorization: _this.access_token
                },
                data: JSON.stringify(data),
                success: function (data) {
                    loading.close();
                    _this.data = [];
                    if(data.status == 200){
                        _this.data = data.data;
                        if(_this.data && _this.data.length > 0){
                            _this.pager.pagecount = _this.data[0].pagecount;
                            _this.pager.totalcount = _this.data[0].totalcount;
                        }else{
                            _this.pager.pagecount = 1;
                            _this.pager.totalcount = 0;
                        }
                    }else{
                        _this.$message(data.msg);
                    }
                },
                error: function (jqXHR) {
                    loading.close();
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        },
        toPage(url){
            window.open(url);
        }
    }
})

function getTime() {
    var date =  new Date();
    year = date.getFullYear();
    month = date.getMonth() + 1; if(month<10){ month="0"+month; }
    day = date.getDate(); if(day<10){ day="0"+day; }
    hours = date.getHours(); if(hours<10){ hour="0"+hours; }
    minutes = date.getMinutes(); if(minutes<10){ minutes="0"+minutes; }
    seconds = date.getSeconds(); if(seconds<10){ seconds="0"+seconds; }
    document.getElementById("date").innerHTML = year + "年" + month + "月" + day + "日" + "<span>" + hours + ":" + minutes + ":" + seconds + "</span>";
}
getTime();
setInterval("getTime()", 1000);

var scroll = {
    old: -1,
    scrollTimer: '',
    id: '',
    init: function(id){
        scroll.id = id;
        $(scroll.id).hover(function() {
            scroll.stopScroll();
        })
        $(scroll.id).mouseleave(function() {
            scroll.autoScroll();
        })
        this.autoScroll();
    },
    run: function(){
        scroll.old = $(scroll.id)[0].scrollTop;
        $(scroll.id)[0].scrollTop++;
        if(scroll.old == $(scroll.id)[0].scrollTop){
            $(scroll.id)[0].scrollTop = 0;
        }
    },
    autoScroll: function(){
        scroll.scrollTimer = setInterval(scroll.run, 200);
    },
    stopScroll:function(){
        clearInterval(scroll.scrollTimer);
    },
}
var scroll1 = {
    old: -1,
    scrollTimer: '',
    id: '',
    init: function(id){
        scroll1.id = id;
        $(scroll1.id).hover(function() {
            scroll1.stopScroll();
        })
        $(scroll1.id).mouseleave(function() {
            scroll1.autoScroll();
        })
        this.autoScroll();
    },
    run: function(){
        scroll1.old = $(scroll1.id)[0].scrollTop;
        $(scroll1.id)[0].scrollTop++;
        if(scroll1.old == $(scroll1.id)[0].scrollTop){
            $(scroll1.id)[0].scrollTop = 0;
        }
    },
    autoScroll: function(){
        scroll1.scrollTimer = setInterval(scroll1.run, 200);
    },
    stopScroll:function(){
        clearInterval(scroll1.scrollTimer);
    },
}
scroll.init("#projectData");
scroll1.init("#unusualInfo");

var map = {
    getData: function () {
        let _this = this;
        let data = {
            station_id: station_id
        }
        $.ajax({
            url: baseurl + "screen/GetProjectList",
            type: "post",
            dataType: "json",
            contentType: "application/json",
            headers:{
                Authorization: access_token
            },
            data: JSON.stringify(data),
            success: function (data) {
                if (data.data && data.data.length > 0) {
                    _this.data = data.data;
                    map.getMap(data.data);
                } else {
                    map.getMap([]);
                }
            },
            error: function (jqXHR) {
                map.getMap([]);
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    getMap: function (data) {
        var map = new AMap.Map("map", {
            expandZoomRange: true,
            zoom: 7,
            zooms: [5, 20],
            mapStyle: 'amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2',
            resizeEnable: true,
            viewMode: '3D',
            showLabel: true
        });
        var infoWindow = new AMap.InfoWindow({
            offset: new AMap.Pixel(0, -30)
        });
        if (data && data.length > 0) {
            for (var i = 0; i < data.length; i++) {
                let item = data[i];
                var img = '../static/images/gczljc/icn_shiyi.png';
                var marker = new AMap.Marker({
                    position: [item.mapx, item.mapy],
                    icon: new AMap.Icon({
                        size: new AMap.Size(28, 28),
                        image: img
                    }),
                    map: map
                });
                marker.content = `<p class="info-item">${item.project_name}</p>`;
                marker.on('mouseover', infoOpen);
                marker.on('click', newMAp);
            }
            map.setZoomAndCenter(7, [Number(data[0].mapx), Number(data[0].mapy)]);
        }
        function newMAp(e) {
            var infoWindow = new AMap.InfoWindow({
                offset: new AMap.Pixel(0, -30)
            });
            infoWindow.setContent(e.target.content);
            infoWindow.open(map, e.target.getPosition());
        }
        function infoOpen(e) {
            infoWindow.setContent(e.target.content);
            infoWindow.open(map, e.target.getPosition());
        }
        map.setMapStyle('amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2');
    },
}