var projectData = '';
var map = {
    getMap: function (data) {
        var options = {
            subdistrict: 0,
            extensions: 'all',
            level: 'province'
        };
        var district = new AMap.DistrictSearch(options);
        district.search('杭州市', function (status, result) {
            var bounds = result.districtList[0]['boundaries'];
            var mask = [];
            for (var i = 0; i < bounds.length; i++) {
                mask.push([bounds[i]]);
            }
            var map = new AMap.Map("map", {
                mask: mask,
                expandZoomRange: true,
                mapStyle: 'amap://styles/e78d30bf5a98cffcc6b290aabc0dea94',
                resizeEnable: true,
                viewMode: '3D',
                showLabel: true
            });
            var district = null;
            var polygons = [];
            function drawBounds() {
                if (!district) {
                    var opts = {
                        subdistrict: 0,
                        extensions: 'all',
                        level: 'district'
                    };
                    district = new AMap.DistrictSearch(opts);
                }
                //行政区查询
                district.setLevel('district')
                district.search($("#area").html(), function (status, result) {
                    map.remove(polygons)//清除上次结果
                    polygons = [];
                    var bounds = result.districtList[0].boundaries;
                    if (bounds) {
                        for (var i = 0, l = bounds.length; i < l; i++) {
                            var polygon = new AMap.Polygon({
                                strokeWeight: 1,
                                path: bounds[i],
                                fillOpacity: 0.4,
                                fillColor: '#80d8ff',
                                strokeColor: '#0091ea'
                            });
                            polygons.push(polygon);
                        }
                    }
                    map.add(polygons)
                    map.setFitView(polygons);//视口自适应
                });
            }
            drawBounds();
            var infoWindow = new AMap.InfoWindow({
                offset: new AMap.Pixel(0, -30)
            });
            if (data.data) {
                for (var i = 0; i < data.data.length; i++) {
                    for (var j = 0; j < data.data[i].pile_info.length; j++) {
                        var item = data.data[i].pile_info[j];
                        if (item.SceneTask_id != '0') {
                            var marker = new AMap.Marker({
                                position: [item.mapx, item.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon_zjdw.png"
                                }),
                                map: map
                            });
                            marker.content = `<div class='marker-info'>
                                <div class='icon_font icon-icon_zs-01'></div>
                                <div class='icon_font icon-icon_ys-01'></div>
                                <div class='icon_font icon-icon_zx-01'></div>
                                <div class='icon_font icon-icon_yx-01'></div>
                                
                                <div class='top-item'>
                                    <p class='title'>${data.data[i].project_name}</p>
                                    <p class='btn' onclick="getBottomData.showPopup('${data.data[i].project_id}','${item.SceneTask_id}','${item.customer_id}','${item.task_id}','${item.order_id}')">异常录入</p>
                                    <p class='btn' onclick="getRightdata.get_XCJC_Detail(${item.SceneTask_id})">检测溯源</p>
                                </div>
                                <div class='center-item'>
                                    <div class='img'>
                                        <img src='http://detect.cnjsjd.net/${item.op_avatar}'/>
                                        <p class='name'>${item.op_name}</p>
                                    </div>
                                    <div class='info'>
                                        <div><p>检测项目：</p>${item.jc_item}</div>
                                        <div><p>桩号：</p>${item.pile_no}</div>
                                        <div><p>设备：</p>${item.MachineId}</div>
                                        <div><p>检测单位：</p>${data.data[i].customer_name}</div>
                                        <div><p>最后时间：</p>${item.last_datetime}</div>
                                    </div>
                                    <div class='phone' onclick="map.videoConnection('${item.op_code ? item.op_code : ''}')">
                                        <p class='icon_font icon-icon_splx-01'></p>
                                        <p>视频通话</p>
                                    </div>
                                </div>
                                <div class='bottom-item'>
                                ${item.monitor_info.map(item2 => {
                                return (`
                                            <div class='item'>
                                                <div class='name'>${item2.equ_no ? item2.equ_no : '/'}</div>
                                                <div class='status'>
                                                    <p class="${item2.is_online == '1' ? 'active' : ''}" onclick="map.getSnapPictures('${item.pile_id ? item.pile_id : ""}', '${item2.equ_no ? item2.equ_no : ""}', '${item2.is_online ? item2.is_online : ""}')"><span class='icon_font icon-icon_bf_lx-01'></span>播放</p>
                                                    <span class="icon_font icon-vertical_line"></span>
                                                    <p class="${item2.is_historyvideo == '1' ? 'active' : ''}" onclick="map.getHistoryvideo('${item2.equ_no ? item2.equ_no : ""}', '${dateFormat('YYYY-mm-dd', new Date())}')"><span class='icon_font icon-icon_hf_lx-01'></span>回放</p>
                                                </div>
                                            </div>
                                        `)
                            }).join('')
                                }
                                </div>
                            </div>`;
                        } else {
                            var marker = new AMap.Marker({
                                position: [item.mapx, item.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon_zjdw_lx.png"
                                }),
                                map: map
                            });
                            marker.content = `<div class='marker-info'>
                                <div class='top-item'><p class='title' style='width: 100%;'>当前桩基尚未使用现场检测app，无法显示现场检测数据</p></div>
                            </div>`;
                        }
                        marker.on('mouseover', infoOpen);
                        // marker.on('mouseout', infoClose);
                        marker.on('click', newMAp);
                    }
                    map.setZoomAndCenter(11, [119.999269, 30.327779]);
                }
            }

            function newMAp(e) {
                var infoWindow = new AMap.InfoWindow({
                    offset: new AMap.Pixel(0, -30)
                });
                infoWindow.setContent(e.target.content);
                infoWindow.open(map, e.target.getPosition());
            }

            function infoClose(e) {
                infoWindow.close(map, e.target.getPosition());
            }

            function infoOpen(e) {
                infoWindow.setContent(e.target.content);
                infoWindow.open(map, e.target.getPosition());
            }

            $(".left-item .panel-item .panel-info .item, .left-item .panel .panel-info .panel-time").click(function () {
                var mapx = $(this).attr('data-mapx');
                var mapy = $(this).attr('data-mapy');
                var gps_isvalid = $(this).attr('data-gps_isvalid');
                var index1 = Number($(this).attr('data-index1'));
                var index2 = Number($(this).attr('data-index2'));
                var item1 = projectData[index1];
                var item2 = projectData[index1].pile_info[index2];
                if (gps_isvalid == '1') {
                    map.setZoomAndCenter(18, [Number(mapx), Number(mapy)]);
                    if (item2.SceneTask_id != '0') {
                        infoWindow.setContent(`
                            <div class='marker-info'>
                                <div class='icon_font icon-icon_zs-01'></div>
                                <div class='icon_font icon-icon_ys-01'></div>
                                <div class='icon_font icon-icon_zx-01'></div>
                                <div class='icon_font icon-icon_yx-01'></div>
                                <div class='top-item'>
                                    <p class='title'>${item1.project_name}</p>
                                    <p class='btn' onclick="getBottomData.showPopup('${item1.project_id}','${item2.SceneTask_id}','${item2.customer_id}','${item2.task_id}','${item2.order_id}')">异常录入</p>
                                    <p class='btn' onclick="getRightdata.get_XCJC_Detail(${item2.SceneTask_id})">检测溯源</p>
                                </div>
                                <div class='center-item'>
                                    <div class='img'>
                                        <img src='http://detect.cnjsjd.net/${item2.op_avatar}'/>
                                        <p class='name'>${item2.op_name}</p>
                                    </div>
                                    <div class='info'>
                                        <div><p>检测项目：</p>${item2.jc_item}</div>
                                        <div><p>桩号：</p>${item2.pile_no}</div>
                                        <div><p>设备：</p>${item2.MachineId}</div>
                                        <div><p>检测单位：</p>${item1.customer_name}</div>
                                        <div><p>最后时间：</p>${item2.last_datetime}</div>
                                    </div>
                                    <div class='phone' onclick="map.videoConnection('${item2.op_code ? item2.op_code : ''}')">
                                        <p class='icon_font icon-icon_splx-01'></p>
                                        <p>视频通话</p>
                                    </div>
                                </div>
                                <div class='bottom-item'>
                                ${item2.monitor_info.map(item3 => {
                            return (`
                                            <div class='item'>
                                                <div class='name'>${item3.equ_no ? item3.equ_no : '/'}</div>
                                                <div class='status'>
                                                    <p class="${item3.is_online == '1' ? 'active' : ''}" onclick="map.getSnapPictures('${item2.pile_id ? item2.pile_id : ""}', '${item3.equ_no ? item3.equ_no : ""}', '${item3.is_online ? item3.is_online : ""}')"><span class='icon_font icon-icon_bf_lx-01'></span>播放</p>
                                                    <span class="icon_font icon-vertical_line"></span>
                                                    <p class="${item3.is_historyvideo == '1' ? 'active' : ''}" onclick="map.getHistoryvideo('${item3.equ_no ? item3.equ_no : ""}', '${dateFormat('YYYY-mm-dd', new Date())}')"><span class='icon_font icon-icon_hf_lx-01'></span>回放</p>
                                                </div>
                                            </div>
                                        `)
                        }).join('')
                            }
                                </div>
                            </div>
                        `);
                    } else {
                        infoWindow.setContent(`
                            <div class='marker-info'>
                                <div class='top-item'><p class='title' style='width: 100%;'>当前桩基尚未使用现场检测app，无法显示现场检测数据</p></div>
                            </div>
                        `);
                    }
                    infoWindow.open(map, { Q: Number(mapy), R: Number(mapx), lat: Number(mapy), lng: Number(mapx) });
                } else {
                    map.setZoom(11);
                }
            })

            map.setMapStyle('amap://styles/e78d30bf5a98cffcc6b290aabc0dea94');
        })
    },
    // 直播
    getSnapPictures: function (pile_id, equ_no, is_online) {
        if (is_online == '1') {
            $.ajax({
                url: baseURL + "GetSnapPictures.ashx",
                type: "post",
                dataType: "json",
                data: {
                    pile_id,
                    equ_no,
                    type: ''
                },
                success: function (data) {
                    showPopup(data.data[0].url, '直播');
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        } else {
            layer.msg('该设备不在线');
        }
    },
    // 回放
    getHistoryvideo: function (equ_no, date, type = 0) {
        console.log(equ_no, date)
        $.ajax({
            url: baseURL + "GetVideoPlayBack.ashx",
            type: "get",
            dataType: "json",
            data: {
                equ_no,
                date
            },
            success: function (data) {
                map.getHistoryvideoHtml(data, date, equ_no, type);
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    getHistoryvideoHtml: function (data, date, equ_no, type) {
        console.log(data, type);
        if (data.data.historyvideo_url) {
            $("#popup-info").html('');
            $("#popup-info").html(`
                <video controls preload="auto" autoplay="autoplay">
                    <source src="${data.data.historyvideo_url}" type="video/mp4" />
                </video>
                <div class='flex-item'>
                    ${data.data.last_isvalid == 1 ? `<p onclick="map.getHistoryvideo('${equ_no ? equ_no : ""}', '${getNextDate(date, -1)}', 1)">${getNextDate(date, -1)}</p>` : `<p class='notActive'>${getNextDate(date, -1)}</p>`}
                    <p onclick="map.getHistoryvideo('${equ_no ? equ_no : ""}', '${date}', 1)">${date}</p>
                    ${data.data.next_isvalid == 1 ? `<p onclick="map.getHistoryvideo('${equ_no ? equ_no : ""}', '${getNextDate(date, 1)}', 1)">${getNextDate(date, 1)}</p>` : `<p class='notActive'>${getNextDate(date, 1)}</p>`}
                </div>
            `);
            if (type == 0) {
                showPopup('', '回放');
            }
        } else {
            layer.msg('暂无回放');
        }
    },
    // 视频通话
    videoConnection(op_code) {
        showPopup('http://detect.cnjsjd.net/VideoConnection.aspx?target_op_code=' + op_code, '视频通话');
    }
}

// 左侧
var getLeftdata = {
    init: function () {
        this.getProjectPileCount();
        this.getProjectInfo();
    },
    getProjectPileCount: function () {
        $.ajax({
            url: baseURL + "GetProjectPileCount.ashx",
            type: "get",
            dataType: "json",
            success: function (data) {
                getLeftdata.setProjectPileCount(data);
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setProjectPileCount: function (data) {
        $("#zjgc").html(data.data[0].testProject);
        $("#ycgc").html(data.data[0].abnormalProject);
        $("#zjzj").html(data.data[0].testPile);
        $("#yczs").html(data.data[0].abnormalPile);
    },
    getProjectInfo: function () {
        $.ajax({
            url: baseURL + "GetProjectInfo.ashx",
            type: "post",
            dataType: "json",
            data: {
                project_name: $("#project_name").val()
            },
            success: function (data) {
                projectData = data.data;
                getLeftdata.setProjectInfo(data);
                map.getMap(data);
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setProjectInfo: function (data) {
        $(".info-item").html('');
        if (data.data) {
            for (let i = 0; i < data.data.length; i++) {
                var item = data.data[i];
                var info = `
                    <div class="panel-item">
                        <div class="panel-head">
                            <p class="name">【${item.project_no}】${item.project_name}</p>
                        </div>
                        <div class="panel-head">
                            <p class="name">检测单位：${item.customer_name}</p>
                            <p class="name">登记日期：${item.register_date}</p>
                        </div>
                        <div class="panel-info">
                        ${item.pile_info.map((item2, index) => {
                    return (`
                                    <div class="ac-item" id="panel-${i}-${index}" onclick="$('#zjxx .ac-item').removeClass('active');$('#panel-${i}-${index}').addClass('active');">
                                        <div class="item" data-mapx='${item2.mapx}' data-mapy='${item2.mapy}' data-gps_isvalid='${item2.gps_isvalid}' data-index1 = '${i}' data-index2 = '${index}'>
                                            <div class="value" ${item2.end_time ? `onclick="$('.content .right-item').html('');layer.msg('暂无最新抓拍信息');"` : `onclick="getRightdata.GetSnapPictures(${item2.pile_id}, ${item2.SceneTask_id})"`}>
                                                <p>桩号：${item2.pile_no}<span style='margin-left:.15rem'>${item2.test_type}</span></p>
                                                <p></p>设备：${item2.MachineId}</p>
                                            </div>
                                            <div class="status">
                                                <p class="dw icon_font icon-icon_dw_lx-01 ${item2.gps_isvalid == 1 ? 'zx' : ''}"></p>
                                                ${item2.end_time ? `<p class="icon_font icon-icon_jk_lx-01" onclick="$('.content .right-item').html('');layer.msg('暂无最新抓拍信息');"></p>` : `<p class="icon_font icon-icon_jk_lx-01 ${item2.monitor_isvalid == 1 ? 'zx' : ''}"  onclick="getRightdata.GetSnapPictures(${item2.pile_id}, ${item2.SceneTask_id})"></p>`}
                                            </div>
                                        </div>
                                        <div class="panel-time"  data-mapx='${item2.mapx}' data-mapy='${item2.mapy}' data-gps_isvalid='${item2.gps_isvalid}' onclick="getRightdata.GetSnapPictures(${item2.pile_id}, ${item2.SceneTask_id})">${item2.test_start_time ? `<p>检测开始时间：${item2.test_start_time}</p>` : ''}${item2.test_end_time ? `<p style="margin-top: .08rem;">检测结束时间：${item2.test_end_time}</p>` : ''}${item2.data_start_time ? `<p style="margin-top: .08rem;">数据上传时间：${item2.data_start_time}</p>` : ''}${item2.data_end_time ? `<p style="margin-top: .08rem;">数据结束时间：${item2.data_end_time}</p>` : ''}</div>
                                    </div>
                                `)
                }).join('')
                    }
                        </div>
                    </div>
                `;
                $(".info-item").append(info);
            }
        } else {
            $(".info-item").html('<div class="noData">暂无数据</div>');
        }
    }
}

// 右侧
var getRightdata = {
    GetSnapPictures: function (pile_id, SceneTask_id) {
        $(".content .right-item").html('');
        $.ajax({
            url: baseURL + "GetSnapPictures.ashx",
            type: "post",
            dataType: "json",
            data: {
                pile_id,
                type: 0
            },
            success: function (data) {
                getRightdata.setSnapPictures(data, SceneTask_id);
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setSnapPictures: function (data, SceneTask_id) {
        if (data.data) {
            $(".content .right-item").html(`
                <div class="top-item">
                    <p class="active">监控与抓拍</p>
                    <p onclick="getRightdata.get_XCJC_Detail(${SceneTask_id})">检测溯源</p>
                </div>
                <div class="bottom-item"></div>
            `);
            for (var i = 0; i < data.data.length; i++) {
                var item = data.data[i];
                var panel = `
                    <div class="panel-item">
                        <div class="panel-head">
                            <p>${item.equ_no}【${item.createtime ? item.createtime : '/'}】</p>
                            <p class="blue-text" onclick="getRightdata.getHistoryPic('${item.equ_no ? item.equ_no : ''}')">历史抓拍</p>
                        </div>
                        <div class="panel-info">
                            ${item.img ? '<img src=' + item.img + ' onclick="map.getSnapPictures(' + item.pile_id + ', ' + item.equ_no + ', ' + item.is_online + ')" />' : "<div class='noData'>暂无数据</div>"}
                        </div>
                    </div>
                `;
                $(".content .right-item .bottom-item").append(panel);
            }
        } else {
            layer.msg('暂无最新抓拍信息');
        }
    },
    getHistoryPic: function (equ_no, type) {
        $.ajax({
            url: baseURL + "GetHistoryPic.ashx",
            type: "post",
            dataType: "json",
            data: {
                equ_no,
                date: type == 1 ? $("#dateInput").val() : dateFormat('YYYY-mm-dd', new Date())//'2022-04-19'
            },
            success: function (data) {
                getRightdata.setHistoryPic(data, equ_no, type);
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setHistoryPic: function (data, equ_no, type) {
        if (type == 1) {
            $("#popup-info .img-item").html('');
            if (data.data) {
                for (var i = 0; i < data.data.length; i++) {
                    var item = data.data[i];
                    $("#popup-info .img-item").append(`<img src="${item.filepath}">`);
                }
            } else {
                $("#popup-info .img-item").html('<div class="noData">暂无数据</div>');
            }
        } else {
            $("#popup-info").html(`
                <div class="search-item">
                    <p>日期：</p>
                    <input type="text" id="dateInput" class="input">
                    <button class="btn input input-primary" onclick="getRightdata.getHistoryPic('${equ_no}', 1)">查询</button>
                </div>
                <div class="img-item"></div>
                <div class='bigger-img hiddenImportant'></div>
            `);
            $("#dateInput").val(dateFormat('YYYY-mm-dd', new Date()));
            if (data.data && data.data.length > 0) {
                for (var i = 0; i < data.data.length; i++) {
                    var item = data.data[i];
                    $("#popup-info .img-item").append(`<img src="${item.filepath}" onclick="getRightdata.biggerPic('${item.filepath}')">`);
                }
            } else {
                $("#popup-info .img-item").html('<div class="noData">暂无数据</div>');
            }
            showPopup('', '历史抓拍');
        }
        var laydate = layui.laydate;
        laydate.render({
            elem: '#dateInput'
        });
    },
    biggerPic: function (url) {
        $(".popup-info .bigger-img").append(`<div class='img'><div class='item'><p class='icon_font icon-guanbixiao' onclick='getRightdata.closeBiggerImg()'></p><img src='${url}'/></div></div>`);
        $(".popup-info .bigger-img").removeClass('hiddenImportant');
    },
    closeBiggerImg: function () {
        $(".popup-info .bigger-img").html('');
        $(".popup-info .bigger-img").addClass('hiddenImportant');
    },
    get_XCJC_Detail: function (SceneTaskID) {
        $.ajax({
            url: 'http://detect.cnjsjd.net/AppModules/CommonFiles/Scene/XCJC_Detail.aspx?id=' + SceneTaskID,
            type: "get",
            success: function (data) {
                getRightdata.set_XCJC_Detail(data);
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    set_XCJC_Detail: function (data) {
        $("#popup-info").html(data);
        showPopup('', '静载工程数据详情');
    }
}
function getMonthDay(year, month) {
    let days = new Date(year, month + 1, 0).getDate()
    return days
}
var getBottomData = {
    init: function () {
        this.getUnusualDate();
    },
    getUnusualDate: function () {
        $("#bhg-date .begin").html(getNextDate(dateFormat('YYYY-mm-dd', new Date()), Number('-' + new Date().getDate()) + 1));
        $("#bhg-date .end").html(dateFormat('YYYY-mm-dd', new Date()));
        this.getUnusual();
    },
    getPrevMonth: function () {
        var date = new Date($("#bhg-date .begin")[0].innerHTML)
        var year = date.getFullYear()
        var month = date.getMonth() + 1
        if (month == 1) {
            month = 12
            year = year - 1
        } else {
            month = month - 1
            if (month < 10) {
                month = '0' + month
            }
        }
        var lastDay = getMonthDay(year, month)
        console.log(year, month)
        $("#bhg-date .begin").html(year + '-' + month + '-' + '01');
        $("#bhg-date .end").html(year + '-' + month + '-' + lastDay);
        this.getUnusual();
    },
    getNextMonth: function () {
        var date = new Date($("#bhg-date .begin")[0].innerHTML)
        var year = date.getFullYear()
        var month = date.getMonth() + 1
        if (month == 12) {
            month = '01'
            year = year + 1
        } else {
            month = month + 1
            if (month < 10) {
                month = '0' + month
            }
        }
        var lastDay = getMonthDay(year, month)
        console.log(year, month)
        $("#bhg-date .begin").html(year + '-' + month + '-' + '01');
        $("#bhg-date .end").html(year + '-' + month + '-' + lastDay);
        this.getUnusual();
    },
    getUnusual: function () {
        $.ajax({
            url: baseURL_Utility + "UnusualList.ashx?begin_date=" + $("#bhg-date .begin").html() + "&end_date=" + $("#bhg-date .end").html() + "&screen_kind=3",
            type: "get",
            dataType: "json",
            success: function (data) {
                getBottomData.setUnusual(data);
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setUnusual: function (data) {
        $(".panel-item2 .list .table-body tbody").html('');
        $(".panel-item2 .list .table-body tbody").append(`
            ${data.data.map(item => {
            return (`
                    <tr>
                        <td width="11%" title="${item.customer_name}">
                            <div class="ellipsis">
                                ${item.customer_name}
                            </div>
                        </td>
                        <td width="11%" title="${item.project_name}">
                            <div class="ellipsis">
                            ${item.project_name}
                            </div>
                        </td>
                        <td width="11%" title="${item.unusual_reason}">${item.unusual_type_str}</td>
                        <td width="11%">${item.unusual_time}</td>
                        <td width="11%">${item.op_name}</td>
                        <td width="11%" style="color:${item.unusual_status == '1' ? 'red' : '#C0D3E6'}" title="${item.unusual_status == '1' ? item.reply_content : ''}">${item.unusual_status_str}</td>
                </tr>
                    `)
        }).join('')
            }
        `);
    },
    showPopup: function (project_id, table_id, customer_id, task_id, order_id) {
        $(".layui-form")[0].reset()
        this.formData = {
            project_id,
            table_id,
            customer_id,
            task_id,
            order_id
        }
        layer.open({
            type: 1,
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>异常信息录入</p>",
            area: ['8rem', '45%'],
            content: $('#popup-unusual'),
            end: function () {
                $("#popup-unusual").css('display', 'none');
            }
        });
    },
}

$(function () {
    layui.use(['form', 'layer', 'laydate'], function () {
        var layer = layui.layer;
        var laydate = layui.laydate;
        var form = layui.form
        laydate.render({
            elem: '#bhg-date .begin'
            , btns: ['confirm']
            , done: function (value, date, endDate) {
                var startDate = new Date(value).getTime();
                var endTime = new Date($('#bhg-date .end').val()).getTime();
                if (endTime < startDate) {
                    layer.msg('结束时间不能小于开始时间');
                    $('#bhg-date .begin').val($('#bhg-date .end').val());
                    return false
                }
                getBottomData.getUnusual();
            }
        });
        laydate.render({
            elem: '#bhg-date .end'
            , btns: ['confirm']
            , done: function (value, date, endDate) {
                var startDate = new Date($('#bhg-date .begin').val()).getTime();
                var endTime = new Date(value).getTime();
                if (endTime < startDate) {
                    layer.msg('结束时间不能小于开始时间');
                    $('#bhg-date .end').val($('#bhg-date .begin').val());
                    return false
                }
                getBottomData.getUnusual();
            }
        });
        form.verify({
            title: function (value) {
                if (value.length < 5) {
                    return '标题至少得5个字符啊';
                }
            }
            , pass: [
                /^[\S]{6,12}$/
                , '密码必须6到12位，且不能出现空格'
            ]
            , content: function (value) {
                layedit.sync(editIndex);
            }
        });
        form.on('submit(submit-unusual)', function (data) {
            var finalData = $.extend($.extend({
                action: 1,
                screen_kind: 3,
            }, getBottomData.formData), data.field)
            $.ajax({
                url: baseURL_Utility + "UnusualHandle.ashx",
                type: "post",
                dataType: "json",
                data: finalData,
                success: function (data) {
                    console.log(data)
                    layer.closeAll();
                    getBottomData.init();
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })

            return false;
        });
    });
    getHeader();
    getLeftdata.init();
    getBottomData.init();

}); 