function getAccess(cb) {
    var api_secret = "40DB5CA9-9FA7-45E6-95B9-E7E8AF24F699";
    var api_key = "10014";
    var timestamp = new Date().getTime();

    $.ajax({
        url: `${newBaseURL_htjc}access`,
        type: "post",
        contentType: "application/json",
        data: JSON.stringify({
            api_key,
            timestamp,
            sign: md5(`api_key${api_key}timestamp${timestamp}${api_secret}`),
        }),
        success: (res) => {
            if (res.status == 200) {

                $.ajaxSetup({
                    beforeSend: (xhr) => {
                        xhr.setRequestHeader('Authorization', `${res.data.token_type} ${res.data.access_token}`);
                        // 添加其他需要的头部
                    }
                });
                if (cb) {
                    cb()
                }
            }
        }
    })
}




var laydateObj;
var taskList = {
    data: [],
    init: function () {
        this.getData();
    },
    getData: function () {
        let _this = this;
        $.ajax({
            url: baseURL_htjc + "GetTaskList.ashx",
            type: "post",
            dataType: "json",
            data: {
                keywords: $("#rw-keywords").val(),
                date: $("#rw-date").val(),
                page: 1,
                limit: 100
            },
            success: function (data) {
                if (data.data && data.data.length > 0) {
                    _this.data = data.data;
                    _this.setData(data.data);
                    map.getMap(data.data);
                } else {
                    map.getMap([]);
                    $("#rwList").html('<div class="noData">暂无数据</div>');
                }
            },
            error: function (jqXHR) {
                map.getMap([]);
                $("#rwList").html('<div class="noData">暂无数据</div>');
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setData: function (data) {
        var str = '';
        for (var i = 0; i < data.length; i++) {
            var item = data[i];
            str += `
                <div class="panel-item">
                    <div class="panel-head">${item.project_no ? '【' + item.project_no + '】' : ''}${item.project_name}</div>
                    <div class="panel-info">
            `;
            for (var j = 0; j < item.task_list.length; j++) {
                var item2 = item.task_list[j];
                str += `
                    <div class="info-item">
                        <div id="rwInfo-${i}-${j}">
                            <div class="item-head" onclick="listClick('rwInfo-${i}-${j}')" data-mapx="${item2.mapx}" data-mapy="${item2.mapy}" data-index="${i}" data-index2="${j}">
                                <div class="flex-item">
                                    <div class="icon ${item2.abnormal_count > 0 ? 'showTip' : ''}"><img src="../static/images/icon_rwd.png"/></div>
                                    任务单：${item2.task_no}
                                </div>
                                <div class="flex-item">
                                    <div class="number"><p><span>${item2.test_count}</span>&nbsp;/</p>&nbsp;${item2.total_count}</div>
                                    <div class="icon icon2"><img src="../static/images/jiantou.png"/></div>
                                </div>
                            </div>
                            <div class="item-main hidden">
                                ${item2.sample_list.map((item3, index3) => {
                    return (`<div class="flex-item" onclick="detail.listgetsubRightData('${item.project_id}', '${item3.sample_id}', '${j}','${index3}')"><p>${item3.sample_name}</p><p class="desc ${item3.test_status == 1 ? 'green' : item3.test_status == 2 ? 'red' : ''}">${item3.test_status_str}</p></div>`); //0未检测 1已检测 2强度不达标
                }).join('')
                    }
                            </div>
                        </div>
                    </div>
                `;
            }
            str += `
                    </div>
                </div>
            `;
        }
        $("#rwList").html(str);
    },
    prevDate() {
        $("#rw-date").val(getNextDate(($("#rw-date").val()), -1));
        laydateObj.config.value = getNextDate(($("#rw-date").val(), new Date()), -1);
        this.getData();
    },
    nextDate() {
        $("#rw-date").val(getNextDate(($("#rw-date").val()), 1));
        laydateObj.config.value = getNextDate(($("#rw-date").val(), new Date()), 1);
        this.getData();
    }
}
$("#rw-keywords").keydown(function (event) {
    if (event.keyCode == 13) {
        taskList.getData();
    }
});

var testCount = {
    init: function () {
        this.getData();
    },
    getData: function () {
        let _this = this;
        $.ajax({
            url: baseURL_htjc + "GetTestCount.ashx",
            type: "post",
            dataType: "json",
            success: function (data) {
                if (data.data && data.data.length > 0) {
                    _this.setData(data.data);
                } else {
                    $("#zjgc").html('0');
                    $("#ycgc").html('0');
                    $("#yjbw").html('0');
                    $("#bdb").html('0');
                }
            },
            error: function (jqXHR) {
                $("#zjgc").html('0');
                $("#ycgc").html('0');
                $("#yjbw").html('0');
                $("#bdb").html('0');
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setData: function (data) {

        $("#zjgc").html(data[0].today_project_count);
        $("#ycgc").html(data[0].today_abnormal_project_count);
        $("#yjbw").html(data[0].today_test_count);
        $("#bdb").html(data[0].today_abnormal_test_count);
    }
}

var map = {
    getMap: function (data) {
        var options = {
            subdistrict: 0,
            extensions: 'all',
            level: 'province'
        };
        var district = new AMap.DistrictSearch(options);
        district.search($("#province").html(), function (status, result) {
            //district.search('河南省', function (status, result) {
            var bounds = result.districtList[0]['boundaries'];
            var mask = [];
            for (var i = 0; i < bounds.length; i++) {
                mask.push([bounds[i]]);
            }
            var map = new AMap.Map("map", {
                mask: mask,
                expandZoomRange: true,
                zoom: 7,
                zooms: [5, 20],
                mapStyle: 'amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2',
                resizeEnable: true,
                viewMode: '3D',
                showLabel: true
            });
            var district = null;
            var polygons = [];
            function drawBounds() {
                if (!district) {
                    var opts = {
                        subdistrict: 0,
                        extensions: 'all',
                        level: 'district'
                    };
                    district = new AMap.DistrictSearch(opts);
                }
                //行政区查询
                district.setLevel('district')
                district.search($("#area").html(), function (status, result) {
                    //district.search('濮阳市', function (status, result) {
                    map.remove(polygons)//清除上次结果
                    polygons = [];
                    var bounds = result.districtList[0].boundaries;
                    if (bounds) {
                        for (var i = 0, l = bounds.length; i < l; i++) {
                            var polygon = new AMap.Polygon({
                                strokeWeight: 1,
                                path: bounds[i],
                                fillOpacity: 0.4,
                                fillColor: '#80d8ff',
                                strokeColor: '#0091ea'
                            });
                            polygons.push(polygon);
                        }
                    }
                    map.add(polygons)
                    map.setFitView(polygons);//视口自适应
                });
            }
            drawBounds();
            var infoWindow = new AMap.InfoWindow({
                offset: new AMap.Pixel(0, -30)
            });
            if (data && data.length > 0) {
                for (var i = 0; i < data.length; i++) {
                    for (let y = 0; y < data[i].task_list.length; y++) {
                        let item2 = data[i].task_list[y]
                        var img = '../static/images/icon_huang.gif';
                        /**
                         * abnormal_count > 0 ----- 异常
                         * test_count == total_count ----- 已检
                         * test_count < total_count -----在检
                         */
                        if (item2.abnormal_count > 0) {
                            img = 'icon_hong.gif';
                        } else if (item2.test_count == item2.total_count) {
                            img = 'icon_lv.gif';
                        } else if (item2.test_count < item2.total_count) {
                            img = 'icon_huang.gif';
                        }
                        var marker = new AMap.Marker({
                            position: [item2.mapx, item2.mapy],
                            icon: new AMap.Icon({
                                size: new AMap.Size(28, 28),
                                image: '../static/images/' + img
                            }),
                            map: map
                        });
                        marker.content = `
                        <div class="info-item">
                            <p onclick="detail.getData('${data[i].project_id}')" style="padding: 0.2rem .5rem .2rem .3rem">${data[i].project_name}</p>
                            <p class='btn' onclick="getBottomData.showPopup('${data[i].project_id}','${item2.SceneTask_id}','${item2.customer_id}','${item2.task_id}','${item2.order_id}')">异常录入</p>
                        </div>`;
                        marker.on('mouseover', infoOpen);
                        marker.on('click', newMAp);
                    }
                }
                map.setZoomAndCenter(7, [Number(data[0].task_list[0].mapx), Number(data[0].task_list[0].mapy)]);
            }
            function newMAp(e) {
                var infoWindow = new AMap.InfoWindow({
                    offset: new AMap.Pixel(0, -30)
                });
                infoWindow.setContent(e.target.content);
                infoWindow.open(map, e.target.getPosition());
            }
            function infoOpen(e) {
                infoWindow.setContent(e.target.content);
                infoWindow.open(map, e.target.getPosition());
            }

            $("#rwList .item-head").click(function () {
                var mapx = $(this).attr('data-mapx');
                var mapy = $(this).attr('data-mapy');
                if (Math.floor(mapx) == 0 && Math.floor(mapy) == 0) {
                    return false;
                }
                var index = Number($(this).attr('data-index'));
                var item = taskList.data[index];
                var index2 = Number($(this).attr('data-index2'));
                var item2 = taskList.data[index].task_list[index2];
                if (mapx && mapy) {
                    map.setZoomAndCenter(12, [Number(mapx), Number(mapy)]);
                    infoWindow.setContent(`<div class="info-item">
                        <p onclick="detail.getData('${item.project_id}')" style="padding: 0.2rem .5rem .2rem .3rem">${item.project_name}</p>
                        <p class='btn' onclick="getBottomData.showPopup('${item.project_id}','${item2.SceneTask_id}','${item2.customer_id}','${item2.task_id}','${item2.order_id}')">异常录入</p>
                    </div>`);
                    infoWindow.open(map, { Q: Number(mapy), R: Number(mapx), lat: Number(mapy), lng: Number(mapx) });
                }
            })
            map.setMapStyle('amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2');
        })
    },
}

var getBottomData = {
    showPopup: function (project_id, table_id, customer_id, task_id, order_id) {
        $(".layui-form")[0].reset()
        this.formData = {
            project_id,
            table_id,
            customer_id,
            task_id,
            order_id
        }
        layer.open({
            type: 1,
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>异常信息录入</p>",
            area: ['8rem', '45%'],
            content: $('#popup-unusual'),
            end: function () {
                $("#popup-unusual").css('display', 'none');
            }
        });
    },
}

var detail = {
    project_id: '',
    data: [],
    ysjl_list: [],
    sample_id: '',
    selectedTab: 'data-detail', // data-detail=>数据详情    test-location=>检测定位
    getData: function (project_id, sample_id, index, index2) {
        let _this = this;
        _this.project_id = project_id;
        _this.sample_id = sample_id;
        $.ajax({
            url: baseURL_htjc + "GetTaskInfo.ashx",
            type: "post",
            dataType: "json",
            data: {
                project_id,
                date: $("#rw-date").val(),
            },
            success: function (data) {


                if (data.data && data.data.length > 0) {

                    _this.setLeftData(data.data, sample_id, index, index2);
                    _this.setTab(data.data);
                } else {
                    $("#subrwList").html('<div class="noData">暂无数据</div>');
                }
            },
            error: function (jqXHR) {
                $("#subrwList").html('<div class="noData">暂无数据</div>');
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setTab(data) {
        detail.data = data
        let str = (`
            <div class="tabBox">
                <div class="data-detail ${this.selectedTab === 'data-detail' ? 'actived' : ''}" onclick="detail.changeTab('data-detail')" >数据详情</div>
                <div class="test-location ${this.selectedTab === 'test-location' ? 'actived' : ''}" onclick="detail.changeTab('test-location')" >检测定位</div>
            </div
        `)

        $("#popup-info .tab").html(str);
    },
    changeTab(val) {

        this.selectedTab = val
        $('.tabBox').children().removeClass('actived')
        $(`.tabBox .${val}`).addClass('actived')


        $(`#popup-info .data-detail-main`).addClass('hiddenImportant')
        $(`#popup-info .test-location-main`).addClass('hiddenImportant')
        $(`#popup-info .${val}-main`).removeClass('hiddenImportant')

        if (val == 'test-location') {
            testLocationMap.setMap()
        }




    },
    setLeftData: function (data, sample_id, aindex, aindex2) {
        this.data = data;
        var str = '';
        for (var i = 0; i < data.length; i++) {
            var item = data[i];
            str += `
                <div class="info-item">
                    <div id="subrwInfo-${i}">
                        <div class="item-head" onclick="detail.setRightData('${i}', 'subrwInfo-${i}')">
                            <div class="flex-item">
                                <div class="icon ${item.abnormal_count > 0 ? 'showTip' : ''}"><img src="../static/images/icon_rwd.png"/></div>
                                任务单：${item.task_no}
                            </div>
                            <div class="flex-item">
                                <div class="icon icon2"><img src="../static/images/jiantou.png"/></div>
                            </div>
                        </div>
                        <div class="item-tab"><div>已检测：${item.test_count}</div><div>强度不达标：${item.abnormal_count}</div><div>未检测：${item.untest_count}</div></div>
                   
                        <div class="item-main hidden">
                            ${item.sample_list.map((item2, index2) => {
                return (`<div class="flex-item" onclick="detail.getsubRightData('${item2.sample_id}', '${i}','${index2}')"><p>${item2.sample_name}</p><p class="desc ${item2.test_status == 1 ? 'green' : item2.test_status == 2 ? 'red' : ''}">${item2.test_status_str}</p></div>`); //0未检测 1已检测 2强度不达标
            }).join('')
                }
                        </div>
                    </div>
                </div>
            `;
        }
        $("#popup-info .left-item").html(str);
        if (sample_id) {
            detail.getsubRightData(sample_id, aindex, aindex2);
            sublistClick('subrwInfo-' + aindex);


            this.showPopup();
        } else {
            this.setRightData(0, 'subrwInfo-0');
            this.showPopup();
        }
    },
    setRightData(index, id) {
        sublistClick(id);

        var item = this.data[index];
        $("#subrwList .info-item").removeClass("active");
        $("#subrwList .flex-item").removeClass("active");
        $("#popup-info .info-item:nth-child(" + (Number(index) + 1) + ")").addClass("active");
        $("#popup-info .head").html(`${item.project_no ? '【' + item.project_no + '】' : ''}${item.project_name}`);
        $("#popup-info .right-item1").html(`
            <div class="main-item1">
                <div class="flex-item"><div class="value">任务单号：${item.task_no}</div><div class="value">检测单位：${item.customer_name}</div></div>
                <div class="flex-item"><div class="value">开始时间：${item.test_begin_datetime}</div><div class="value">最近数据上传：${item.test_end_datetime}</div></div>
                ${item.report_file && `<div class="flex-item"><div class="value">回弹文件：<a href="${item.report_file}" style="color:#C0D3E6">点击查看</a></div></div>`
            }
                <div class="flex-item flex-item2 over-flex">
                    ${item.faceimg_list && item.faceimg_list.length > 0 ? item.faceimg_list.map((item2) => {
                return (`
                                <div class="box">
                                    <div class="img">
                                        <img src="${item2.image_url}" />
                                    </div>
                                    <div class="item">
                                        <div class="type"><p class="name">人脸识别</p><p>${item2.op_name}</p></div>
                                        <div class="time">${item2.datatime}</div>
                                    </div>
                                </div>
                            `);
            }).join('')
                : ''}
                </div>
            </div>
            <div class="main-item">
                <div class="ma-i">
                    ${item.flow_list.length > 0 ?
                item.flow_list.map((item2, index2) => {
                    return (`
                                <div class="item">
                                    <div class="value">
                                        <div class="blue">第${index2 + 1}步 / ${item2.flowpath_no_str}</div>
                                        <div>检测人员：${item2.op_name}</div>
                                        <div>${item2.create_time}</div>
                                    </div>
                                    <div class="imgArr">
                                        ${item2.file_list.map((item3, index3) => {
                        return (`
                                                    <img src="${item3.file_path}" onclick="detail.imgView('${index}','${index2}','${index3}')"/>
                                                `);
                    }).join('')
                        }
                                    </div>
                                </div>
                            `);
                }).join('')
                : '<div class="noData">暂无数据</div>'
            }
                </div>
            </div>
        `);
        $("#popup-info .right-item2").addClass("hiddenImportant");
        $("#popup-info .right-item1").removeClass("hiddenImportant");
    },
    getsubRightData(sample_id, index, index2) {
        console.log(sample_id, index, index2);
        let _this = this;
        $.ajax({
            url: newBaseURL_htjc + "screen/htjc/sjxq_jcbw",
            type: "get",
            dataType: "json",
            data: {
                sample_id
            },
            success: function (data) {
                if (data.data) {
                    _this.setsubRightData(index, index2, data.data);
                } else {
                    // $("#subrwList").html('<div class="noData">暂无数据</div>');
                }
            },
            error: function (jqXHR) {
                // $("#subrwList").html('<div class="noData">暂无数据</div>');
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setsubRightData(index, index2, data) {

        console.log(data, 'data');
        $("#subrwList .info-item").removeClass("active");
        $("#subrwList .flex-item").removeClass("active");
        $("#subrwList .info-item:nth-child(" + (Number(index) + 1) + ") .flex-item:nth-child(" + (Number(index2) + 1) + ")").addClass("active");
        $("#popup-info .right-item1").addClass("hiddenImportant");
        $("#popup-info .right-item2").removeClass("hiddenImportant");
        var item = data[0];
        this.ysjl_list = item.ysjl_list;
        $("#popup-info .right-item2").html(`
            <div class="flex-item"><div class="value">任务单号：${item.task_no}</div><div class="value">检测单位：${item.customer_name}</div></div>
            <div class="name-item">${item.sample_name}</div>
            <div class="info-item">
                <div class="desc"><p>设计强度：${item.sjqd}</p><p>强度推定值MPa：${item.tdz} / <span class="${item.test_status == 1 ? 'green' : item.test_status == 2 ? 'red' : ''}">${item.test_status_str}</span></p></div>
                <div class="bw-item">
                    ${item.test_status == 1 && item.ysjl_list && item.ysjl_list.length > 0 ?
                item.ysjl_list.map((item2, index2) => {
                    return (`
                        
                    ${item2.ysjl_list ? `
                     <div style="margin-bottom:10px">
                            <div class="flex-item hover-row" style="position:relative;cursor:pointer" onclick="toggleContainer(${index2})">
                                <div class="value">构件名称：${item2.gj_name}</div>${item2.gj_no ? `<div class="value">构件编号：${item2.gj_no}</div>` : ''}
                                <img src="../static/images/jiantou.png" id="block_arrow_${index2}" style="width:10px;height:10px;position:absolute;top:8px;right:10px;transform"/>
                            </div>
                            <div class="item-container" id="block_${index2}" style="display:none;flex-wrap:wrap">
                            ${item2.ysjl_list && item.ysjl_list.length > 0 ? item2.ysjl_list.map((innerItem, innerIndex) => {
                        return `<div class="item ${innerItem.test_status == '1' ? 'common' : 'fail'}"  onmouseover="mouseover(${index2},${innerIndex}, event)" onmouseout="mouseout()">${innerItem.jc_data21 ? innerItem.jc_data21 : '未计算'}
                                    ${modifyChange(innerItem.change_list[0]) > 0 ? '<img class="icon-change" src="../static/images/icon-change.png" />' : ''}
                                </div>`
                    }).join('') : ''}
                                </div>
                              </div >
                    ` : ''}
                        
                       
    `);
                }).join('')
                : '<div class="noData">暂无数据</div>'
            }
                </div>
                <div class="sub-desc"><p>检测人员：${item.op_name || '/'}</p><p>检测时间：${item.test_datetime || '/'}</p><p>检测设备：${item.equ_no || '/'}</p></div>
            </div>
        `);
    },
    listgetsubRightData: function (project_id, sample_id, index, index2) {
        detail.getData(project_id, sample_id, index, index2);
    },
    showPopup: function () {
        layer.open({
            type: 1,
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>工程回弹数据详情</p>",
            area: ['13rem', '75%'],
            content: $('#popup-info'),
            end: function () {
                detail.changeTab('data-detail')
                $("#popup-info").css('display', 'none');

            }
        });
    },
    showPopupChangeList: function (ysjl_id, index, val) {

        $("#popup-info-change-list .content .table .table-body").html('');
        $.ajax({
            url: newBaseURL_htjc + `screen/htjc/xgjl`,
            type: "get",
            data: {
                ysjl_id,
                index
            },
            dataType: "json",
            success: function (data) {

                if (data.data.length) {
                    let arr = data.data
                    for (let i = 0; i < arr.length; i++) {
                        if (i === arr.length - 1) {
                            arr[i].newVal = val
                            break
                        }
                        arr[i].newVal = arr[i + 1].jc_data

                    }



                    $("#popup-info-change-list .content .table .table-body").append(`
                        ${arr.map(item => {
                        return (`
                                <tr>
                                    <td width="25%">${item.update_opname ? item.update_opname : ''}</td>
                                    <td width="25%">${item.update_time}</td>
                                    <td width="25%">${item.jc_data}</td>
                                    <td width="25%">${item.newVal}</td>
                                </tr>
                                `)
                    }).join('')

                        }
                    `);




                }
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })


        layer.open({
            type: 1,
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>数据修改详情</p>",
            area: ['10rem', '70%'],
            content: $('#popup-info-change-list'),
            end: function () {
                $("#popup-info-change-list").css('display', 'none');
            }
        });










    },
    imgView(index, index2, index3) {
        var arr = this.data[index].flow_list[index2].file_list;
        $("#swiper .swiper-wrapper").html("");
        $("#swiper").removeClass("hidden");
        for (var i = 0; i < arr.length; i++) {
            $("#swiper .swiper-wrapper").append('<div class="swiper-slide"><img src="' + arr[i].file_path + '" /></div>');
        }
        var mySwiper = new Swiper('.swiper-container', {
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            observer: true,
            observeParents: true,
            initialSlide: index3
        });
    },
    swiperHide() {
        $("#swiper").addClass("hidden");
    },
    hoverInfoMouseover() {

        clearTimeout(hoverInfoTime)
    },
    hoverInfoMouseout() {
        mouseout()
    }
}

var hoverInfoTime;
var isHoverInfoModal; // 弹窗是否正在显示
function mouseover(index, indexInner, e) {
    if (isHoverInfoModal) {
        return
    }
    var arr = [];
    let notArr = ['jc_data21', 'test_status', 'change_list', 'group_no', 'is_change', 'jc_data26', 'ysjl_id']
    for (i in detail.ysjl_list[index].ysjl_list[indexInner]) {
        if (!notArr.includes(i)) {
            arr.push(detail.ysjl_list[index].ysjl_list[indexInner][i]);
        }
    }


    $("#hoverInfo").html(`
        ${arr.map((item2, index2) => {
        let bool = detail.ysjl_list[index].ysjl_list[indexInner].change_list[0][`is_change${index2 + 1}`] > 0

        return (`
                    <div onClick="detail.showPopupChangeList('${detail.ysjl_list[index].ysjl_list[indexInner].ysjl_id}','${index2 + 1}','${item2}')" class="${bool ? 'modification' : ''}">${item2}</div>
                `);
    }).join('')
        }
    `);
    isHoverInfoModal = true
    setTimeout(() => {
        var divW = $("#hoverInfo").width();
        var screenW = $(window).width();
        if (e.clientX + divW > screenW) {
            $("#hoverInfo").css("left", 'auto').css("right", 0).css("top", e.clientY + 10 + 'px').removeClass("hidden");
        } else {
            $("#hoverInfo").css("left", e.clientX + 10 + 'px').css("right", 'auto').css("top", e.clientY + 10 + 'px').removeClass("hidden");
        }

    }, 30);
}
function mouseout() {

    hoverInfoTime = setTimeout(() => {
        $("#hoverInfo").addClass("hidden").css("left", 0).css("right", 0).css("top", 0);
        isHoverInfoModal = false
    }, 30);
}

function listClick(id) {
    var flag = $("#" + id + " .item-main").hasClass("hidden");
    $("#rwList .item-head").removeClass("active");
    $("#" + id + " .item-head").addClass("active");
    if (flag) {
        $("#rwList .item-main").addClass("hidden");
        $("#rwList .item-head").removeClass("headHover");
        $("#" + id + " .item-head").addClass("headHover");
        $("#" + id + " .item-main").removeClass("hidden");
    } else {
        $("#rwList .item-head").removeClass("headHover");
        $("#rwList .item-main").addClass("hidden");
    }
}

function sublistClick(id) {
    var flag = $("#" + id + " .item-main").hasClass("hidden");
    if (flag) {
        $("#subrwList .item-main").addClass("hidden");
        $("#subrwList .item-head").removeClass("headHover");
        $("#" + id + " .item-head").addClass("headHover");
        $("#" + id + " .item-main").removeClass("hidden");
    } else {
        $("#subrwList .item-head").removeClass("headHover");
        $("#subrwList .item-main").addClass("hidden");
    }
}


var testLocationMap = {
    map: '',
    markerObj: {},
    isShowMarkerObj: {},
    modalBoxTime: '',
    setMap: function () {
        this.map = new AMap.Map("test-location-main", {
            viewMode: '2D', //默认使用 2D 模式
            zoom: 11, //地图级别
            mapStyle: 'amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2',
            center: [detail.data[0].project_mapx, detail.data[0].project_mapy], //地图中心点
        });
        this.setMarker()
        this.setCircle()
        this.markerObj = {}
        this.isShowMarkerObj = {}
        this.modalBoxTime = ''
    },
    setMarker: function () {
        new AMap.Marker({
            position: [detail.data[0].project_mapx, detail.data[0].project_mapy],
            icon: new AMap.Icon({
                size: new AMap.Size(28, 28),
                imageSize: new AMap.Size(28, 28),
                image: '../static/images/icon_dwi_san.png',
                imageOffset: new AMap.Pixel(0, 0)

            }),
            map: this.map
        });

        for (let index = 0; index < detail.data.length; index++) {
            let item = detail.data[index]
            console.log(item, 'item');
            let marker = new AMap.Marker({
                position: [item.mapx, item.mapy],
                icon: new AMap.Icon({
                    size: new AMap.Size(28, 28),
                    imageSize: new AMap.Size(28, 28),
                    image: '../static/images/icon_lv.gif',
                    imageOffset: new AMap.Pixel(0, 0)

                }),
                map: this.map
            });




            marker.on("mouseover", () => {
                this.markerObj[index] = marker
                marker.setLabel({
                    direction: "right",
                    offset: new AMap.Pixel(0, 0), //设置文本标注偏移量
                    content: `<div class="modalBox" onmouseout="testLocationMap.modalBoxMouseout(${index})" onmouseover="testLocationMap.modalBoxMouseover(${index})" >
                        <div class="taskNoBox">
                            <img class="rwdImg" src="../static/images/icon_rwd.png" />
                            任务单：${item.task_no}
                        </div>
                        <div class="countBox">
                            <div>已检测：${item.test_count}</div>
                            <div>强度不达标：${item.abnormal_count}</div>
                            <div>未检测：${item.untest_count}</div>
                        </div>
                       <div class="content">
                            <div class="modalBoxItem">开始时间：${item.test_begin_datetime}</div>
                            <div class="modalBoxItem">最近数据上传：${item.test_end_datetime}</div>
                            <div class="modalBoxItem">检测单位：${item.customer_name}</div>
                            ${item.sample_list.map((item2) => {
                        return (`<div class="modalBoxItem"><p>${item2.sample_name}</p><p class="desc ${item2.test_status == 1 ? 'green' : item2.test_status == 2 ? 'red' : ''}">${item2.test_status_str}</p></div>`); //0未检测 1已检测 2强度不达标
                    }).join('')
                        } 
                       </div>

                    </div>`, //设置文本标注内容
                });
            });
            marker.on("mouseout", () => {

                if (this.isShowMarkerObj[index]) {
                    return;
                }
                this.modalBoxMouseout(index)
            });

        }



    },
    modalBoxMouseover: function (index) {

        clearTimeout(this.modalBoxTime)
        this.isShowMarkerObj[index] = true

    },
    modalBoxMouseout: function (index) {
        clearTimeout(this.modalBoxTime)

        this.modalBoxTime = setTimeout(() => {
            this.markerObj[index].setLabel({
                content: null, //设置文本标注内容
            })
            this.isShowMarkerObj[index] = false
        }, 100)
    },

    setCircle: function () {
        let centerMap = [detail.data[0].project_mapx, detail.data[0].project_mapy]
        let arr = []
        for (let index = 0; index < detail.data.length; index++) {
            let item = detail.data[index]
            let itemMap = [item.mapx, item.mapy]
            arr.push(AMap.GeometryUtil.distance(centerMap, itemMap))

        }


        //设置圆的半径大小
        let addRadius = Math.pow(10, Math.floor(Math.max(...arr)).toString().length)
        let radius = Math.max(...arr) + addRadius;




        let circle = new AMap.Circle({
            center: centerMap, //圆心
            radius: radius, //半径
            borderWeight: 3, //描边的宽度
            strokeColor: "#00FFA2", //轮廓线颜色
            strokeOpacity: 1, //轮廓线透明度
            strokeWeight: 1, //轮廓线宽度
            fillOpacity: 0.2, //多边形填充透明度

            strokeDasharray: [10, 10],
            fillColor: "#00FFA2", //多边形填充颜色
            zIndex: 50, //多边形覆盖物的叠加顺序
        });

        //圆形 Circle 对象添加到 Map
        this.map.add(circle);
        //根据覆盖物范围调整视野
        this.map.setFitView([circle])


    }
}


function init() {
    getHeader();
    layui.use(['form', 'layer', 'laydate'], function () {
        var form = layui.form;
        var layer = layui.layer;
        var laydate = layui.laydate;
        laydateObj = laydate.render({
            elem: '#rw-date'
            , value: ''
            , done: function () {
                taskList.init();
            }
        });
        form.verify({
            title: function (value) {
                if (value.length < 5) {
                    return '标题至少得5个字符啊';
                }
            }
            , pass: [
                /^[\S]{6,12}$/
                , '密码必须6到12位，且不能出现空格'
            ]
            , content: function (value) {
                layedit.sync(editIndex);
            }
        });
        form.on('submit(submit-unusual)', function (data) {
            var finalData = $.extend($.extend({
                action: 1,
                screen_kind: 4,
            }, getBottomData.formData), data.field)
            $.ajax({
                url: baseURL_Utility + "UnusualHandle.ashx",
                type: "post",
                dataType: "json",
                data: finalData,
                success: function (data) {

                    if (data.status == 200) {
                        layer.msg('已录入', { icon: 0 }, function () { });
                        setTimeout(() => {
                            layer.closeAll();
                        }, 1000);

                    } else {
                        layer.msg(data.msg, { icon: 0 }, function () { });
                    }
                },
                error: function (jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })

            return false;
        });
    })
    taskList.init();
    testCount.init();
}

function toggleContainer(index) {
    console.log($(`#block_${index}`).css("display"))
    if ($(`#block_${index}`).css("display") == 'flex') {
        $(`#block_${index}`).css("display", "none")
        $(`#block_arrow_${index}`).css("transform", "none")
    } else {
        $(`#block_${index}`).css("display", "flex")
        $(`#block_arrow_${index}`).css("transform", "rotate(180deg)")

    }
}
function modifyChange(objdata) {
    var total = 0
    for (var i in objdata) {
        total += objdata[i]
    }
    return total
}
getAccess(() => {
    init();

});