var zjData = [];
// 桩基工程数据统计
let leftList = {
    init: function () {
        this.get_data(1);
    },
    get_data: function (type) {
        $("#zjsj-tab .item").removeClass('active');
        $("#zjsj-tab .item"+type).addClass('active');
        let _this = this;
        $.ajax({
            url: baseURL + 'UnitPile/GetProjectPileCount.ashx',
            type: "post",
            data: {
                date_type: type
            },
            success: function (data) {
                data = JSON.parse(data);
                if (data.data[0]) {
                    _this.set_data(data.data)
                } else {
                    $("#get-data").html('<div class="nodata">暂无数据</div>');
                }
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    set_data: function (data) {
        let str = '';
        for (let i = 0; i < data.length; i++) {
            let timeItem = data[i];
            str += `<div class="numberAll">
                <p>在检工程</p>
                <p>${timeItem.test_project}</p>
            </div>
            <div class="numberAll red">
                <p>异常工程</p>
                <p>${timeItem.abnormal_project}</p>
            </div>
            <div class="numberAll green">
                <p>在检桩基</p>
                <p>${timeItem.test_pile}</p>
            </div>
            <div class="numberAll org">
                <p>异常桩基</p>
                <p>${timeItem.abnormal_pile}</p>
            </div>`
            }
        $("#xxx-data").html(str);
    }
}

// 桩基检测记录
let zjjc = {
    init: function () {
        $("#jcjh-date").val(getDate());
        this.get_data();
    },
    get_data: function () {
        let _this = this;
        $("#xcry-count").html(0);
        $.ajax({
            url: baseURL + 'UnitPile/GetUnitPlieList.ashx',
            type: "post",
            data: {
                keywords1: $("#jcjh-item").val(),
                test_date: $("#jcjh-date").val(),
                page: 1,
                limit: 500,
            },
            success: function (data) {
                data = JSON.parse(data);
                map.getMap(data.data)
                if (data.data[0]) {
                    _this.set_data(data.data)
                    $("#xcry-count").html(data.totals);
                } else {
                    $("#message-List").html('<div class="nodata">暂无数据</div>');
                    $("#video-list").html('<div class="nodata">暂无数据</div>');
                }
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    set_data: function (data) {
        $("#video-list").html('<div class="nodata">暂无数据</div>');
        zjData = data;
        let str = '';
        for (let i = 0; i < data.length; i++) {
            str +=  `
                <div class="messageList">
                    <div class="listTop">
                        <p>${data[i].project_no?`【${data[i].project_no}】`:''}${data[i].project_name}</p> 
                    </div>`;
            for (let y = 0; y < data[i].pile_list.length; y++) {
                let timeItem = data[i].pile_list[y];
                str += `
                    <div class="item dwitem" ${timeItem.monitor_isvalid == 1 ? `onclick="jkzp.get_data('${timeItem.pile_id}','${timeItem.equ_no}')"`:''} data-mapx="${timeItem.mapx}" data-mapy="${timeItem.mapy}"data-index="${i}" data-index2="${y}">
                        <div class="listItem">
                            <div class="value-item">
                                <div class="getData">登记日期：&nbsp;<span>${data[i].register_date}</span></div>
                                <div class="getData">桩号：&nbsp;<span>${timeItem.pile_no}</span></div>
                                <div class="getData">设备：&nbsp;<span>${timeItem.equ_no}</span></div>
                            </div>
                            <div class="img-item">
                                <img class='img' src="../static/img2.0/icon_location.png" />
                                <img class='img' src=${timeItem.monitor_isvalid == 1 ? '"../static/img2.0/icon_sxt_on.png"': '"../static/img2.0/icon_sxt_off.png"'} alt=""/>
                            </div>
                        </div>
                        <div class="allGet">
                            <p class="getData3 ${timeItem.test_start_time?'':'hidden'}">检测开始时间：
                            <span class="getData4">${timeItem.test_start_time}</span><p>
                            <p class="getData3 ${timeItem.test_end_time?'':'hidden'}">检测结束时间：
                            <span class="getData4">${timeItem.test_end_time}</span></p>
                        </div>
                    </div>`;
                    if(y == data[i].pile_list.length-1){
                        str += `</div>`;
                    }
            }

        }
        $("#message-List").html(str);
    }
}
// 获取历史图片
let jkzp = {
    init: function () {
        this.get_data();
    },
    get_data: function (pile_id, equ_no) {
        let _this = this;
        $.ajax({
            url: baseURL + 'UnitPile/GetSnapPictures.ashx',
            type: "post",
            data: {
                type: 0,
                // pile_id:58364,
                // equ_no: '8C16A52D-C55A-418F-8DA1-2900919BE2FA',
                pile_id,
                date: $("#jcjh-date").val()
            },
            success: function (data) {
                data = JSON.parse(data);
                if (data.data) {
                    _this.set_data(data.data)
                } else {
                    $("#video-list").html('<div class="nodata">暂无数据</div>');
                }
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    set_data: function (data) {
        let str = '';
        for (let i = 0; i < data.length; i++) {
            let timeItem = data[i];
            str += `
                <div class="videoList">
                    <div class="itemList">
                        <div>
                            <img src="../static/img2.0/icon_sxt_medium.png" alt="" >
                            <span>【${timeItem.equ_no}】</span>
                            </div>
                            <button style="font-size: .12rem;" onclick="oldPicture.get_data('${data[i].equ_no}')">历史抓拍</button>
                        </div>
                        <div class="imgitem">
                            <img src="${timeItem.img}" alt="" class="pictureItem">
                        </div>
                    </div>`
        }
        $("#video-list").html(str);
    }
}


// 地图
var map = {
    getMap: function (data) {
        var options = {
            subdistrict: 0,
            extensions: 'all',
            level: 'province'
        };
        var district = new AMap.DistrictSearch(options);
        district.search(publicData.province, function (status, result) {
            var bounds = result.districtList[0]['boundaries'];
            var mask = [];
            for (var i = 0; i < bounds.length; i++) {
                mask.push([bounds[i]]);
            }
            var map = new AMap.Map("map", {
                mask: mask,
                expandZoomRange: true,
                zoom: 7,
                zooms: [5, 20],
                mapStyle: 'amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2',
                resizeEnable: true,
                viewMode: '3D',
                showLabel: true
            });
            map.setCity(publicData.province, function (e) {
                map.setZoom(8)
            })
            var infoWindow = new AMap.InfoWindow({
                offset: new AMap.Pixel(0, -30)
            });
            if (data) {
                for (var i = 0; i < data.length; i++) {
                    for (let y = 0; y < data[i].pile_list.length; y++) {
                        let addlist = data[i].pile_list[y]
                        // if (addlist.monitor_isvalid == 1) {
                            var marker = new AMap.Marker({
                                position: [addlist.mapx, addlist.mapy],
                                icon: new AMap.Icon({
                                    size: new AMap.Size(28, 28),
                                    image: "../static/images/icon/icon_zj.png"
                                }),
                                map: map
                            });
                            var str = `
                                <div class='marker-info6'>
                                    <div class='marker-top7'>
                                        <div class='title333'>${data[i].pile_list[y].op_name}:${data[i].pile_list[y].op_mobile}</div>
                                        <div class='detail' onclick="suyuan.get_data('${data[i].pile_list[y].SceneTask_id}')">检测溯源</div>
                                    </div>
                                    <div class='marker-main3'>
                                            <div class="img0">
                                                <img src="${data[i].pile_list[y].op_avatar}" />
                                            </div>
                                            <div class="info8">
                                                <div><p>检测项目：${data[i].pile_list[y].jc_item}</p></div>
                                                <div><p>工程名称：${data[i].project_name}</p></div>
                                                <div><p>桩号：${data[i].pile_list[y].pile_no}</p></div>
                                                <div><p>设备：${data[i].pile_list[y].equ_no}</p></div>
                                                <div><p>检测结束时间：${data[i].pile_list[y].test_end_time}</p></div>
                                            </div>
                                    </div>
                                    <div class="marker-foot6">
                            `;
                            for(var z=0; z<addlist.monitor_info.length; z++){
                                str += `
                                    <div class="look">
                                    <div class="look-top">
                                        <span class="lookicon">
                                            <img src="../static/img2.0/icon_sxt_medium.png" alt="">
                                        </span>
                                        <p class="looktext">${addlist.monitor_info[z].equ_no}</p>
                                    </div>
                                    <div class="lookfoot">
                                        <div class="lookwatch" onclick="map.getSnapPictures('${data[i].pile_list[y].pile_id}', '${addlist.monitor_info[z].equ_no}', '${addlist.monitor_info[z].is_online}')">
                                            <span class="watchimg">
                                                <img src="${addlist.monitor_info[z].is_online ==1? '../static/img2.0/icon_play_on.png':'../static/img2.0/icon_play_off.png'}" style="max-width: 100% !important;max-height: 100% !important;">
                                            </span>
                                            <span class="watchtext ${addlist.monitor_info[z].is_online ==1? 'active':''}">播放</span>
                                        </div>
                                        <div class="lookwatch1" onclick="map.getHistoryvideoHtml('${addlist.monitor_info[z].historyvideo_url}')">
                                            <span class="watchimg">
                                                <img src="${addlist.monitor_info[z].is_historyvideo ==1? '../static/img2.0/icon_playback_on.png':'../static/img2.0/icon_playback_off.png'}" style="max-width: 100% !important;max-height: 100% !important;">
                                            </span>
                                            <span class="watchtext ${addlist.monitor_info[z].is_historyvideo ==1? 'active':''}">回放</span>
                                        </div>
                                    </div>
                                </div>
                                `;
                                if(z == addlist.monitor_info.length-1){
                                    str += `</div>`;
                                }
                            }
                            marker.content = str;
                        // } else {
                        //     var marker = new AMap.Marker({
                        //         position: [addlist.mapx, addlist.mapy],
                        //         icon: new AMap.Icon({
                        //             size: new AMap.Size(28, 28),
                        //             image: "../static/images/icon/icon_zj.png"
                        //         }),
                        //         map: map
                        //     });
                        //     marker.content = `<div class='marker-info6' style="padding: .1rem .5rem .1rem .1rem;">
                        //         <div class='top-item'><p class='title' style='width: 100%;'>当前桩基尚未使用现场检测app，无法显示现场检测数据</p></div>
                        //     </div>`;
                        // }
                        marker.on('mouseover', infoOpen);
                        marker.on('click', newMAp);
                    }
                }
                // map.setZoomAndCenter(7, [Number(data[0].pile_list[0].mapx), Number(data[0].pile_list[0].mapy)]);
                map.setZoomAndCenter(7, publicData.xy);
            } else {
                map.setZoomAndCenter(7, publicData.xy);
            }
            function newMAp (e) {
                var infoWindow = new AMap.InfoWindow({
                    offset: new AMap.Pixel(0, -30)
                });
                infoWindow.setContent(e.target.content);
                infoWindow.open(map, e.target.getPosition());
            }

            function infoOpen (e) {
                infoWindow.setContent(e.target.content);
                infoWindow.open(map, e.target.getPosition());
            }

            $("#message-List .messageList .dwitem").click(function(){
                var mapx = $(this).attr('data-mapx');
                var mapy = $(this).attr('data-mapy');
                var index = Number($(this).attr('data-index'));
                var y = Number($(this).attr('data-index2'));
                var item = zjData[index];
                if(mapx && mapy){
                    map.setZoomAndCenter(12, [Number(mapx), Number(mapy)]);
                    let addlist = item.pile_list[y]
                    var str = `
                        <div class='marker-info6'>
                            <div class='marker-top7'>
                                <div class='title333'>${addlist.op_name}:${addlist.op_mobile}</div>
                                <div class='detail' onclick="suyuan.get_data('${addlist.SceneTask_id}')">检测溯源</div>
                            </div>
                            <div class='marker-main3'>
                                    <div class="img0">
                                        <img src="${addlist.op_avatar}" />
                                    </div>
                                    <div class="info8">
                                        <div><p>检测项目：${addlist.jc_item}</p></div>
                                        <div><p>工程名称：${item.project_name}</p></div>
                                        <div><p>桩号：${addlist.pile_no}</p></div>
                                        <div><p>设备：${addlist.equ_no}</p></div>
                                        <div><p>检测结束时间：${addlist.test_end_time}</p></div>
                                    </div>
                            </div>
                            <div class="marker-foot6">
                    `;
                    for(var z=0; z<addlist.monitor_info.length; z++){
                        str += `
                            <div class="look">
                            <div class="look-top">
                                <span class="lookicon">
                                    <img src="../static/img2.0/icon_sxt_medium.png" alt="">
                                </span>
                                <p class="looktext">${addlist.monitor_info[z].equ_no}</p>
                            </div>
                            <div class="lookfoot">
                                <div class="lookwatch" onclick="map.getSnapPictures('${item.pile_list[y].pile_id}', '${addlist.monitor_info[z].equ_no}', '${addlist.monitor_info[z].is_online}')">
                                    <span class="watchimg">
                                        <img src="${addlist.monitor_info[z].is_online ==1? '../static/img2.0/icon_play_on.png':'../static/img2.0/icon_play_off.png'}"  style="max-width: 100% !important;max-height: 100% !important;">
                                    </span>
                                    <span class="watchtext ${addlist.monitor_info[z].is_online ==1? 'active':''}">播放</span>
                                </div>
                                <div class="lookwatch1" onclick="map.getHistoryvideoHtml('${addlist.monitor_info[z].historyvideo_url}')">
                                    <span class="watchimg">
                                        <img src="${addlist.monitor_info[z].is_historyvideo ==1? '../static/img2.0/icon_playback_on.png':'../static/img2.0/icon_playback_off.png'}"  style="max-width: 100% !important;max-height: 100% !important;">
                                    </span>
                                    <span class="watchtext ${addlist.monitor_info[z].is_historyvideo ==1? 'active':''}">回放</span>
                                </div>
                            </div>
                        </div>
                        `;
                        if(z == addlist.monitor_info.length-1){
                            str += `</div>`;
                        }
                    }
                    infoWindow.setContent(str);
                    infoWindow.open(map, {Q: Number(mapy),R: Number(mapx),lat: Number(mapy),lng: Number(mapx)});
                }else{
                    map.setZoom(7);
                }
            })

            map.setMapStyle('amap://styles/d3ce37d9fe39b7cc5f08f48af52802a2');
        })
    },
    getDetail: function (SceneTask_id) {
        $.ajax({
            url: URL + 'AppModules/CommonFiles/Scene/XCJC_Detail.aspx?id=' + SceneTask_id,
            type: "get",
            success: function (data) {
                map.setDetail(data);
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setDetail: function (data) {
        layer.open({
            type: 1,
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>工程检测情况</p>",
            area: ['9rem', '6rem'],
            content: data
        });
    },
    getSnapPictures(pile_id, equ_no, is_online){
        if(is_online == '1'){
            $.ajax({
                url: videoURL+"GetSnapPictures.ashx",
                type: "post",
                dataType: "json",
                data: {
                    pile_id,
                    equ_no,
                    type: 1
                },
                success: function(data) {
                    layer.open({
                        type: 2, 
                        shadeClose: true,
                        maxmin: true,
                        title: "<p class='popup-title'>直播</p>",
                        area: ['9rem', '6rem'],
                        content: data.data[0].url
                    }); 
                },
                error: function(jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        }else{
            layer.msg('该设备不在线');
        }
    },
    getHistoryvideoHtml: function(historyvideo_url){
        if(historyvideo_url){
            $("#popup-info").html('');
            $("#popup-info").html(`
                <video controls preload="auto" autoplay="autoplay">
                    <source src="${historyvideo_url}" type="video/mp4" />
                </video>
            `);
            layer.open({
                type: 2, 
                shadeClose: true,
                maxmin: true,
                title: "<p class='popup-title'>回放</p>",
                area: ['9rem', '6rem'],
                content: historyvideo_url
            }); 
        }else{
            layer.msg('暂无回放');
        }
    },
}

// 历史抓拍图片
let oldPicture = {
    get_data: function (equ_no) {
        $("#popup-info").html(`
            <div class="search-item">
                <p>日期：</p>
                <input type="text" id="lszp-date" readonly placeholder="选择检测日期" class="input">
                <button class="btn input input-primary" onclick="getRightdata.getHistoryPic('${equ_no}', 1)">查询</button>
            </div>
            <div class="img-item"></div>
            <div class='bigger-img hidden></div>
        `);
        let _this = this;
        $.ajax({
            url: baseURL + 'UnitPile/GetHistoryPic.ashx',
            type: "post",
            data: {
                date: $("#jcjh-date").val(),
                equ_no,
            },
            success: function (data) {
                data = JSON.parse(data);
                if (data.data) {
                    _this.set_data(data.data, equ_no)
                } else {
                    $("#popup-info .img-item").html('<div class="nodata">暂无数据</div>');
                }
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    set_data: function (data, equ_no) {
        $("#lszp-date").val($("#jcjh-date").val())
        layui.use(['layer', 'laydate'],function(){
            var laydate = layui.laydate;
            laydate.render({ 
                elem: '#lszp-date'
                ,btns: ['confirm']
                ,done: function(){
                    oldPicture.get_data2(equ_no);
                }
            });
        })
        $("#popup-info .img-item").html('');
        if(data){
            for(var i=0; i<data.length; i++){
                var item = data[i];
                $("#popup-info .img-item").append(`<img src="${item.filepath}">`);
            }   
        }else{
            $("#popup-info .img-item").html('<div class="nodata">暂无数据</div>');
        }
        layer.open({
            type: 1, 
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>历史抓拍</p>",
            area: ['9rem', '6rem'],
            content: $('#popup-info'),
            end: function(){
                $("#popup-info").html('');
                $("#popup-info").css('display', 'none');
            }
        });
    },
    get_data2: function (equ_no) {
        let _this = this;
        $.ajax({
            url: baseURL + 'UnitPile/GetHistoryPic.ashx',
            type: "post",
            data: {
                date: $("#lszp-date").val(),
                equ_no,
            },
            success: function (data) {
                data = JSON.parse(data);
                if (data.data) {
                    _this.set_data2(data.data)
                } else {
                    $("#popup-info .img-item").html('<div class="nodata">暂无数据</div>');
                }
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    set_data2: function (data) {
        $("#popup-info .img-item").html('');
        if(data){
            for(var i=0; i<data.length; i++){
                var item = data[i];
                $("#popup-info .img-item").append(`<img src="${item.filepath}">`);
            }   
        }else{
            $("#popup-info .img-item").html('<div class="nodata">暂无数据</div>');
        }
    }
}

// 检测溯源详情
let suyuan= {
    get_data: function (SceneTask_id) {
        let _this = this;
        $.ajax({
            url: URL + 'AppModules/CommonFiles/Scene/XCJC_Detail.aspx',
            type: "get",
            data: {
                id:SceneTask_id,
            },
            success: function (data) {
                if (data) {
                    _this.set_data(data)
                } else {
                    
                }
            },
            error: function (jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    set_data: function (data) {
        $("#popup-info").html(data);
        layer.open({
            type: 1, 
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>静载工程数据详情</p>",
            area: ['9rem', '6rem'],
            content: $('#popup-info'),
            end: function(){
                $("#popup-info").html('');
                $("#popup-info").css('display', 'none');
            }
        }); 
    }
}
init();
function init () {
    getHeadData().then(() =>{
        // $("#header #tab .item:nth-child(1)").addClass('active');
        zjjc.init();
    })
    leftList.init();

    layui.use(['layer', 'laydate'],function(){
        var laydate = layui.laydate;
        laydate.render({ 
            elem: '#jcjh-date'
            ,btns: ['confirm']
            ,done: function(){
                zjjc.get_data();
            }
        });
    })
}