var map = {
    getMap: function(data){
        var map = new AMap.Map("map", {
            mapStyle: 'amap://styles/ae577d25e14f898373a7c41e4b4e6957',
            resizeEnable: true,
            viewMode: '3D',
            showLabel: true
        });
        // var data = [{mapx:120.107571, mapy:30.217173}, {mapx:120.12405, mapy:30.319768}]
        var infoWindow = new AMap.InfoWindow({
            offset: new AMap.Pixel(0, -30)
        });
        if(data.data){
            for(var i = 0; i < data.data.length; i++) {
                for(var j = 0; j < data.data[i].pile_info.length; j++) {
                    var item = data.data[i].pile_info[j];
                    if(item.SceneTask_id != '0'){
                        var marker = new AMap.Marker({
                            position: [item.mapx, item.mapy],
                            icon: new AMap.Icon({
                                size: new AMap.Size(28, 28),
                                image: "../static/images/icon_zjdw.png"
                            }),
                            map: map
                        });
                        marker.content=`<div class='marker-info'>
                            <div class='icon_font icon-icon_zs-01'></div>
                            <div class='icon_font icon-icon_ys-01'></div>
                            <div class='icon_font icon-icon_zx-01'></div>
                            <div class='icon_font icon-icon_yx-01'></div>
                            <div class='top-item'>
                                <p class='title'>${data.data[i].project_name}</p>
                                <p class='btn' onclick="getRightdata.get_XCJC_Detail(${item.SceneTask_id})">检测溯源</p>
                            </div>
                            <div class='center-item'>
                                <div class='img'>
                                    <img src='${item.op_avatar}'/>
                                    <p class='name'>${item.op_name}</p>
                                </div>
                                <div class='info'>
                                    <div><p>检测项目：</p>${item.jc_item}</div>
                                    <div><p>桩号：</p>${item.pile_no}</div>
                                    <div><p>设备：</p>${item.MachineId}</div>
                                    <div><p>检测单位：</p>${data.data[i].customer_name}</div>
                                    <div><p>最后时间：</p>${item.start_time}</div>
                                </div>
                                <div class='phone' onclick="map.videoConnection('${item.op_code ? item.op_code : ''}')">
                                    <p class='icon_font icon-icon_splx-01'></p>
                                    <p>视频通话</p>
                                </div>
                            </div>
                            <div class='bottom-item'>
                            ${
                                item.monitor_info.map(item2 => {
                                    return(`
                                        <div class='item'>
                                            <div class='name'>${item2.equ_no ? item2.equ_no : '/'}</div>
                                            <div class='status'>
                                                <p class="${item2.is_online == '1' ? 'active': ''}" onclick="map.getSnapPictures('${item.pile_id ? item.pile_id : ""}', '${item2.equ_no ? item2.equ_no : ""}', '${item2.is_online ? item2.is_online : ""}')"><span class='icon_font icon-icon_bf_lx-01'></span>播放</p>
                                                <span class="icon_font icon-vertical_line"></span>
                                                <p class="${item2.is_historyvideo == '1' ? 'active': ''}" onclick="map.getHistoryvideo('${item2.historyvideo_url ? item2.historyvideo_url : ""}', '${item2.is_historyvideo ? item2.is_historyvideo : ""}')"><span class='icon_font icon-icon_hf_lx-01'></span>回放</p>
                                            </div>
                                        </div>
                                    `)
                                }).join('')
                            }
                            </div>
                        </div>`;
                    }else{
                        var marker = new AMap.Marker({
                            position: [item.mapx, item.mapy],
                            icon: new AMap.Icon({
                                size: new AMap.Size(28, 28),
                                image: "../static/images/icon_zjdw_lx.png"
                            }),
                            map: map
                        });
                        marker.content=`<div class='marker-info'>
                            <div class='top-item'><p class='title' style='width: 100%;'>当前桩基尚未使用现场检测app，无法显示现场检测数据</p></div>
                        </div>`;
                    }
                    marker.on('mouseover', infoOpen);
                    // marker.on('mouseout', infoClose);
                    marker.on('click', newMAp);
                }
            }
        }

        function newMAp(e) {
            var infoWindow = new AMap.InfoWindow({
                offset: new AMap.Pixel(0, -30)
            });
            infoWindow.setContent(e.target.content);
            infoWindow.open(map, e.target.getPosition());
        }

        function infoClose(e) {
            infoWindow.close(map, e.target.getPosition());
        }

        function infoOpen(e) {
            infoWindow.setContent(e.target.content);
            infoWindow.open(map, e.target.getPosition());
        }

        $(".left-item .panel-item .panel-info .item, .left-item .panel .panel-info .panel-time").click(function(){
            var mapx = $(this).attr('data-mapx');
            var mapy = $(this).attr('data-mapy');
            var gps_isvalid = $(this).attr('data-gps_isvalid');
            if(gps_isvalid == '1'){
                map.setZoomAndCenter(18, [Number(mapx), Number(mapy)]);
            }else{
                map.setZoom(11);
            }
        })

        map.setMapStyle('amap://styles/ae577d25e14f898373a7c41e4b4e6957');
        map.setZoom(11);
    },
    // 直播
    getSnapPictures: function(pile_id, equ_no, is_online){
        if(is_online == '1'){
            $.ajax({
                url: baseURL+"GetSnapPictures.ashx",
                type: "post",
                dataType: "json",
                data: {
                    pile_id,
                    equ_no,
                    type: ''
                },
                success: function(data) {
                    showPopup(data.data[0].url, '直播');
                },
                error: function(jqXHR) {
                    console.log("发生错误：" + jqXHR.status);
                }
            })
        }else{
            layer.msg('该设备不在线');
        }
    },
    // 回放
    getHistoryvideo: function(url, is_historyvideo){
        if(is_historyvideo == '1'){
            showPopup(url, '回放');
        }else{
            layer.msg('暂无回放');
        }
    },
    // 视频通话
    videoConnection(op_code){
        showPopup('/VideoConnection.aspx?target_op_code='+op_code, '视频通话');
    }
}

// 左侧
var getLeftdata = {
    init: function(){
        this.getProjectPileCount();
        this.getProjectInfo();
    },
    getProjectPileCount: function(){
        $.ajax({
            url: baseURL+"GetProjectPileCount.ashx",
            type: "get",
            dataType: "json",
            success: function(data) {
                getLeftdata.setProjectPileCount(data);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setProjectPileCount: function(data){
        $("#zjgc").html(data.data[0].testProject);
        $("#ycgc").html(data.data[0].abnormalProject);
        $("#zjzj").html(data.data[0].testPile);
        $("#yczs").html(data.data[0].abnormalPile);
        $("#op_name").html(data.data[0].op_name);
        $("#area").html(data.data[0].area);
    },
    getProjectInfo: function(){
        $.ajax({
            url: baseURL+"GetProjectInfo.ashx",
            type: "post",
            dataType: "json",
            data: {
                project_name: $("#project_name").val()
            },
            success: function(data) {
                getLeftdata.setProjectInfo(data);
                map.getMap(data);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setProjectInfo: function(data){
        $(".info-item").html('');
        if(data.data){
            for(let i=0; i<data.data.length; i++){
                var item = data.data[i];
                var info = `
                    <div class="panel-item">
                        <div class="panel-head">
                            <p class="name">【${item.project_no}】${item.project_name}</p>
                        </div>
                        <div class="panel-info">
                        ${
                            item.pile_info.map(item2 => {
                                return(`
                                    <div class="item"  data-mapx='${item2.mapx}' data-mapy='${item2.mapy}' data-gps_isvalid='${item2.gps_isvalid}'>
                                        <div class="value" onclick="getRightdata.GetSnapPictures(${item2.pile_id}, ${item2.SceneTask_id})">
                                            <p>桩号：${item2.pile_no}</p>
                                            <p></p>设备：${item2.MachineId}</p>
                                        </div>
                                        <div class="status">
                                            <p class="dw icon_font icon-icon_dw_lx-01 ${item2.gps_isvalid==1 ? 'zx' : ''}"></p>
                                            <p class="icon_font icon-icon_jk_lx-01 ${item2.monitor_isvalid==1 ? 'zx' : ''}"  onclick="getRightdata.GetSnapPictures(${item2.pile_id}, ${item2.SceneTask_id})"></p>
                                        </div>
                                    </div>
                                    <div class="panel-time"  data-mapx='${item2.mapx}' data-mapy='${item2.mapy}' data-gps_isvalid='${item2.gps_isvalid}' onclick="getRightdata.GetSnapPictures(${item2.pile_id}, ${item2.SceneTask_id})">检测开始时间：${item2.start_time}</div>
                                `)
                            }).join('')
                        }
                        </div>
                    </div>
                `;
                $(".info-item").append(info);
            }
        }else{
            $(".info-item").html('<div class="noData">暂无数据</div>');
        }
    }
}

// 右侧
var getRightdata = {
    GetSnapPictures: function(pile_id, SceneTask_id){
        $(".content .right-item").html('');
        $.ajax({
            url: baseURL+"GetSnapPictures.ashx",
            type: "post",
            dataType: "json",
            data: {
                pile_id,
                type: 0
            },
            success: function(data) {
                getRightdata.setSnapPictures(data, SceneTask_id);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setSnapPictures: function(data, SceneTask_id){
        if(data.data){
            $(".content .right-item").html(`
                <div class="top-item">
                    <p class="active">监控与抓拍</p>
                    <p onclick="getRightdata.get_XCJC_Detail(${SceneTask_id})">检测溯源</p>
                </div>
                <div class="bottom-item"></div>
            `);
            for(var i=0; i<data.data.length; i++){
                var item = data.data[i];
                var panel = `
                    <div class="panel-item">
                        <div class="panel-head">
                            <p>${item.equ_no}【${item.createtime?item.createtime: '/'}】</p>
                            <p class="blue-text" onclick="getRightdata.getHistoryPic('${item.equ_no?item.equ_no:''}')">历史抓拍</p>
                        </div>
                        <div class="panel-info">
                            ${item.img ? '<img src='+item.img+' onclick="map.getSnapPictures('+item.pile_id+', '+item.equ_no+', '+item.is_online+')" />' : "<div class='noData'>暂无数据</div>"}
                        </div>
                    </div>
                `;
                $(".content .right-item .bottom-item").append(panel);
            }
        }else{
            layer.msg('暂无最新抓拍信息');
        }
    },
    getHistoryPic: function(equ_no, type){
        $.ajax({
            url: baseURL+"GetHistoryPic.ashx",
            type: "post",
            dataType: "json",
            data: {
                equ_no,
                date: type == 1 ? $("#dateInput").val() : dateFormat('YYYY-mm-dd',new Date())//'2022-04-19'
            },
            success: function(data) {
                getRightdata.setHistoryPic(data, equ_no, type);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    setHistoryPic: function(data, equ_no, type){
        if(type == 1){
            $("#popup-info .img-item").html('');
            if(data.data){
                for(var i=0; i<data.data.length; i++){
                    var item = data.data[i];
                    $("#popup-info .img-item").append(`<img src="${item.filepath}">`);
                }
            }else{
                $("#popup-info .img-item").html('<div class="noData">暂无数据</div>');
            }
        }else{
            $("#popup-info").html(`
                <div class="search-item">
                    <p>日期：</p>
                    <input type="text" id="dateInput" class="input">
                    <button class="btn input input-primary" onclick="getRightdata.getHistoryPic('${equ_no}', 1)">查询</button>
                </div>
                <div class="img-item"></div>
                <div class='bigger-img hiddenImportant'></div>
            `);
            $("#dateInput").val(dateFormat('YYYY-mm-dd',new Date()));
            if(data.data && data.data.length > 0){
                for(var i=0; i<data.data.length; i++){
                    var item = data.data[i];
                    $("#popup-info .img-item").append(`<img src="${item.filepath}" onclick="getRightdata.biggerPic('${item.filepath}')">`);
                }
            }else{
                $("#popup-info .img-item").html('<div class="noData">暂无数据</div>');
            }
            showPopup('', '历史抓拍');
        }
        var laydate = layui.laydate;
        laydate.render({ 
            elem: '#dateInput'
        });
    },
    biggerPic: function(url){
        $(".popup-info .bigger-img").append(`<div class='img'><div class='item'><p class='icon_font icon-guanbixiao' onclick='getRightdata.closeBiggerImg()'></p><img src='${url}'/></div></div>`);
        $(".popup-info .bigger-img").removeClass('hiddenImportant');
    },
    closeBiggerImg: function(){
        console.log(123)
        $(".popup-info .bigger-img").html('');
        $(".popup-info .bigger-img").addClass('hiddenImportant');
    },
    get_XCJC_Detail: function(SceneTaskID){
        $.ajax({
            url: '/AppModules/CommonFiles/Scene/XCJC_Detail.aspx?id='+SceneTaskID,
            type: "get",
            success: function(data) {
                getRightdata.set_XCJC_Detail(data);
            },
            error: function(jqXHR) {
                console.log("发生错误：" + jqXHR.status);
            }
        })
    },
    set_XCJC_Detail: function(data){
        layer.open({
            type: 1, 
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>静载工程数据详情</p>",
            area: ['9rem', '6rem'],
            content: data
        }); 
    }
}

$('#toggle-header').click(function(){
    if($('#toggle-header').attr('data-type') == 'true'){
        $('#toggle-header').attr('data-type', 'false');
        $(".container").addClass('hide-header');
    }else if($('#toggle-header').attr('data-type') == 'false'){
        $('#toggle-header').attr('data-type', 'true');
        $(".container").removeClass('hide-header');
    }
})

getHeader();
getLeftdata.init();