// 自适应
resetFontSize();
function resetFontSize() {
    var baseFontSize = 100
    var designWidth = 1920
    var width = window.innerWidth;
    var maxWidth = 3280;
    var minWidth = 1260;
    width = Math.min(maxWidth, width);
    width = Math.max(minWidth, width);
    sizeScale = width / designWidth;
    var currentFontSize = Math.ceil(sizeScale * baseFontSize);
    document.getElementsByTagName('html')[0].style.fontSize = currentFontSize + 'px'
}

// 获取指定日期前后几天日期
function getNextDate(date, day) {
    var dd = new Date(date);
    dd.setDate(dd.getDate() + day);
    var y = dd.getFullYear();
    var m = dd.getMonth() + 1 < 10 ? "0" + (dd.getMonth() + 1) : dd.getMonth() + 1;
    var d = dd.getDate() < 10 ? "0" + dd.getDate() : dd.getDate();
    return y + "-" + m + "-" + d;
}

// 日期格式化
function dateFormat(fmt, date) {
    let ret;
    const opt = {
        "Y+": date.getFullYear().toString(),        // 年
        "m+": (date.getMonth() + 1).toString(),     // 月
        "d+": date.getDate().toString(),            // 日
        "H+": date.getHours().toString(),           // 时
        "M+": date.getMinutes().toString(),         // 分
        "S+": date.getSeconds().toString()          // 秒
    };
    for (let k in opt) {
        ret = new RegExp("(" + k + ")").exec(fmt);
        if (ret) {
            fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
        };
    };
    return fmt;
}

function getHeader() {
    $(".header-item").html(`
    <div class="name">
        <p class="icon_font icon-ilogo-2"></p>
        <p class="icon_font icon-vertical_line"></p>
        <p><span id='area' style='display:none;'></span>检测监管云平台</p>
    </div>
    <div class="right-item">
        <div class="tab" id="head-tab">
            <div class="sub-tab hiddenImportant">
                <p class="tab-item" id="jzjc-item"><a href='/screen/pages/jzjc.html'>见证检测</a></p>
                <span class="icon_font icon-vertical_line"></span>
            </div>
            <div class="sub-tab hiddenImportant">
                <p class="tab-item" id="xcjc-item"><a href='/screen/pages/xcjc.html'>现场检测</a></p>
                <span class="icon_font icon-vertical_line"></span>
            </div>
            <div class="sub-tab hiddenImportant">
                <p class="tab-item" id="zjjc-item"><a href='/screen/pages/zjjc.html'>桩基检测</a></p>
                <span class="icon_font icon-vertical_line"></span>
            </div>
            <div class="sub-tab hiddenImportant">
                <p class="tab-item" id="shjc-item"><a href='/product_index/html/index.html'>商混检测</a></p>
                <span class="icon_font icon-vertical_line"></span>
            </div>
            <div class="sub-tab hiddenImportant">
                <p class="tab-item" id="qyxw-item"><a href='#'>企业行为</a></p>
                <span class="icon_font icon-vertical_line"></span>
            </div>
            <div class="sub-tab hiddenImportant">
                <p class="tab-item" id="htjc-item"><a href='/screen/pages/htjc.html'>回弹检测</a></p>
                <span class="icon_font icon-vertical_line"></span>
            </div>
        </div>
        <div class="back-item" onclick="back()">后台管理</div>
        <div class="user-info">
            <img id ='op_avatar'/>
            <select class="input"><option id='op_name'></option></select>
        </div>
    </div>`);

    getHeaderInfo();
}

function getHeaderInfo() {
    $.ajax({
        url: "/Ajax/Screen/GetHeaderInfo.ashx",
        type: "get",
        dataType: "json",
        success: function (data) {
<<<<<<< static/js/public.js
            if(data.status == 500){
                window.location="/LoginDirect.aspx";
                return
            }
=======
            if (data.status == 500) {
                window.location = "/LoginDirect.aspx";
                return
            }

>>>>>>> static/js/public.js
            $("#op_name").html(data.data[0].op_name);
            $("#area").html(data.data[0].area);
            $("#op_avatar").attr('src', data.data[0].op_avatar);
            var menu_key = data.data[0].menu_key.split(',');
            var max = Math.max(...menu_key);
            for (var i = 0; i < menu_key.length; i++) {
                if (menu_key[i]) {
                    $("#head-tab .sub-tab:nth-child(" + menu_key[i] + ")").removeClass("hiddenImportant");
                    $("#head-tab .sub-tab:nth-child(" + max + ") span").addClass("hidden");
                }
            }
        },
        error: function (jqXHR) {
            console.log("发生错误：" + jqXHR.status);
        }
    })
}

function back() {
    window.location.href = "/Main.aspx?from=screen"
}

function showPopup(url, title) {
    if (url) {
        layer.open({
            type: 2,
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>" + title + "</p>",
            area: ['9rem', '6rem'],
            content: url
        });
    } else {
        layer.open({
            type: 1,
            shadeClose: true,
            maxmin: true,
            title: "<p class='popup-title'>" + title + "</p>",
            area: ['9rem', '6rem'],
            content: $('#popup-info'),
            end: function () {
                $("#popup-info").html('');
                $("#popup-info").css('display', 'none');
            }
        });
    }

}
$(function () {
    window.onresize = function () {
        resetFontSize();
    };

    $('#toggle-header').click(function () {
        if ($('#toggle-header').attr('data-type') == 'true') {
            $('#toggle-header').attr('data-type', 'false');
            $(".container").addClass('hide-header');
        } else if ($('#toggle-header').attr('data-type') == 'false') {
            $('#toggle-header').attr('data-type', 'true');
            $(".container").removeClass('hide-header');
        }
    })
});

const imgURL = '/';
const baseURL = '/Ajax/Screen/Pile/';
const baseURL_xcjc = '/Ajax/Screen/XCJC/';
const baseURL_jzjc = '/Ajax/Screen/JZJC/';
const baseURL_htjc = '/Ajax/Screen/HTJC/';

const baseURL_Utility = '/Ajax/Screen/Utility/';

window._AMapSecurityConfig = {
    securityJsCode: '0711374220aba81dbf7515aaac08e50b',
}

layui.use(['layer', 'laydate'], function () {
    var layer = layui.layer;
});