import Vue from 'vue'
import Vuex from 'vuex'
Vue.use(Vuex)

let lifeData = {};

try {
	// 尝试获取本地是否存在lifeData变量，第一次启动APP时是不存在的
	lifeData = uni.getStorageSync('lifeData');
} catch (e) {

}

const store = new Vuex.Store({
	state: {
		nodataImg: '/static/images/other/img_nodata.png',
		imgUrl: 'http://jsjcwswx.cnjsjd.net/images/wx_jzjc/',
		location: [{}, {}, {}],// 河南 新疆 浙江
		title: '智慧工程质量监督',
		siteArr: [{
			name: '新疆地区',
			url: 'https://weixin.cnjsjd.net/WeChat/ZHGCZLZS_XINJIANG/RequestHandle.aspx/',
			latitude: 87.539288,
			longitude: 43.870118,
			type: 7
		}, {
			name: '浙江地区',
			url: 'https://weixin.cnjsjd.net/WeChat/ZJXZJC/RequestHandle.aspx/',
			latitude: 120.2346,
			longitude: 30.225776,
			type: 5
		}, {
			name: '河南地区',
			url: 'https://weixin.cnjsjd.net/WeChat/ZHGCZLZS_HENAN/RequestHandle.aspx/',
			latitude: 113.664776,
			longitude: 34.782159,
			type: 6
		}],
	},
	mutations: {
		$uStore(state, payload) {
			// 判断是否多层级调用，state中为对象存在的情况，诸如user.info.score = 1
			let nameArr = payload.name.split('.');
			let saveKey = '';
			let len = nameArr.length;
			if (len >= 2) {
				let obj = state[nameArr[0]];
				for (let i = 1; i < len - 1; i++) {
					obj = obj[nameArr[i]];
				}
				obj[nameArr[len - 1]] = payload.value;
				saveKey = nameArr[0];
			} else {
				// 单层级变量，在state就是一个普通变量的情况
				state[payload.name] = payload.value;
				saveKey = payload.name;
			}
			// 保存变量到本地，见顶部函数定义
			saveLifeData(saveKey, state[saveKey])
		}
	}
})

export default store
