var util = require('../util/index.js')
var config = require('../../../config/index.js')
const baseUrl = config.default.baseUrl.api

// 接口请求
function getData(name, data, method= 'post') {
	uni.showLoading({
		mask: true,
		title: '玩命加载中'
	})
	var timestamp = util.getTimestamp()
	return new Promise(resolve => {
		// 固定要传的参
		let token = uni.getStorageSync('token'),
			str
		if (token) {
			str = {
				timestamp,
				token: uni.getStorageSync('token')
			}
		} else {
			str = { timestamp }
		}
		// 组合：固定传参 + 额外传参 + 拼接signcode
		let senddata = {}
		senddata = Object.assign(data, str, { signcode: util.sort(Object.assign(data, str)) })
		uni.request({
			url: uni.getStorageSync('baseUrl') + name,
			// url: config.default.baseUrl.api.url + name,
			header: { 'Content-Type': 'application/x-www-form-urlencoded', },
			method,
			data: senddata,
			success: res => {
				uni.hideLoading()
				console.log(name + '=>', senddata)
				console.log('response=>', res)
				var {
					errorcode,
					errormsg,
					data
				} = res.data
				if (errorcode == 0) {
					resolve(data)
				} else if(name == '/GetPreProjectOpList'){

				} else if (errorcode == '10002') {
					// token过期 重新登录
					uni.showModal({
						title: '提示',
						content: '身份校验过期 点击重新登录',
						showCancel: false,
						success: res => {
							if (res.confirm) {
								// 自动登录接口
								// this.getOpenid();
								setTimeout(() => {
									this.autoLogin()
								}, 500)
							}
						}
					})
				} else if (errorcode == '10004') {
					uni.showModal({
						title: '提示',
						content: errormsg,
						showCancel: false,
						success: res => {
							if (res.confirm) {
								uni.navigateTo({ url: '/pages/login/login' })
							}
						}
					})
				} else {
					uni.showToast({
						title: errormsg,
						icon: 'none',
						duration: 1500,
						mask: true
					})
				}
			},
			fail() {
				uni.hideLoading()
			}
		})
	})
}

// 接口请求
function getEntrustData(name, data, method = 'POST', myUrl) {
	uni.showLoading({
		mask: true,
		title: '玩命加载中'
	})
	var timestamp = util.getTimestamp()
	return new Promise(resolve => {
		// 固定要传的参
		let token = uni.getStorageSync('token'),
			str
		if (token) {
			str = {
				timestamp,
				token: uni.getStorageSync('token')
			}
		} else {
			str = { timestamp }
		}
		// 组合：固定传参 + 额外传参 + 拼接signcode
		let senddata = {}
		senddata = Object.assign(data, str, { signcode: util.sort(Object.assign(data, str)) })
		uni.request({
			url: (myUrl || uni.getStorageSync('baseUrl')) + name,
			// url: config.default.baseUrl.api.url + name,
			header: { 'Content-Type': 'application/x-www-form-urlencoded' },
			method,
			data: senddata,
			success: res => {
				console.log(name + '=>', senddata)
				console.log('response=>', res)
				uni.hideLoading()
				// console.log(name + '=>', senddata)
				// console.log(res.data.errorcode)
				// console.log(res.data.data.errorcode)
				var {
					errorcode,
					errormsg,
					data
				} = res.data
				// console.log(res.data)
				// console.log(data)
				if (errorcode == 0) {
					resolve(res.data)
				}
				//  else if (errorcode == '10002') {
				// 	// token过期 重新登录
				// 	uni.showModal({
				// 		title: '提示',
				// 		content: '身份校验过期 点击重新登录',
				// 		showCancel: false,
				// 		success: res => {
				// 			if (res.confirm) {
				// 				// 自动登录接口
				// 				// this.getOpenid();
				// 				setTimeout(() => {
				// 					this.autoLogin()
				// 				}, 500)
				// 			}
				// 		}
				// 	})
				// } else if (errorcode == '10004') {
				// 	uni.showModal({
				// 		title: '提示',
				// 		content: errormsg,
				// 		showCancel: false,
				// 		success: res => {
				// 			if (res.confirm) {
				// 				uni.navigateTo({ url: '/pages/login/login' })
				// 			}
				// 		}
				// 	})
				// } 
				else {
					uni.showToast({
						title: errormsg,
						icon: 'none',
						duration: 1500,
						mask: true
					})
				}
				
			// 	if(res.statusCode === 401) {
			// 	   uni.showToast({
			// 		 title: res.data.errormsg,
			// 		 icon: 'none'
			// 	   })
			// 	} else if(res.data.errorcode === '10002') {
			// 	   uni.setStorageSync('token', '')
			// 	   uni.setStorageSync('userInfo', '')
			// 	   uni.setStorageSync('token_bj', '')
			// 	   uni.setStorageSync('uni_login', '')
			// 	   // token过期 重新登录
			// 	   uni.showModal({
			// 		title: '提示',
			// 		content: '身份校验过期 点击重新登录',
			// 		showCancel: false,
			// 		success: res => {
			// 			if (res.confirm) {
			// 				// 自动登录接口
			// 				// this.getOpenid();
			// 				setTimeout(() => {
			// 					this.autoLogin()
			// 				}, 500)
			// 			}
			// 		}
			// 	   })
			// 	} 
			
			// 	// var {
			// 	// 	errorcode,
			// 	// 	errormsg,
			// 	// 	data
			// 	// } = res.data
			// 	// if (errorcode == 0) {
			// 	// 	resolve(res.data)
			// 	// } else if (errorcode == '10002') {
			// 	// 	// token过期 重新登录
			// 	// 	uni.showModal({
			// 	// 		title: '提示',
			// 	// 		content: '身份校验过期 点击重新登录',
			// 	// 		showCancel: false,
			// 	// 		success: res => {
			// 	// 			if (res.confirm) {
			// 	// 				// 自动登录接口
			// 	// 				// this.getOpenid();
			// 	// 				setTimeout(() => {
			// 	// 					this.autoLogin()
			// 	// 				}, 500)
			// 	// 			}
			// 	// 		}
			// 	// 	})
			// 	 else if (res.data.errorcode == '10004') {
			// 		uni.showModal({
			// 			title: '提示',
			// 			content:res.data.errormsg,
			// 			showCancel: false,
			// 			success: res => {
			// 				if (res.confirm) {
			// 					uni.navigateTo({ url: '/pages/login/login' })
			// 				}
			// 			}
			// 		})
			// 	} else if (res.statusCode == 200 && res.data.errorcode == 0) {
			// 	   resolve(res.data)
			// 	} else {
			// 		uni.showToast({
			// 			title: res.data.errormsg,
			// 			icon: 'none',
			// 			duration: 1500,
			// 			mask: true
			// 		})
			// 	}
			},
			fail() {
				uni.hideLoading()
			}
		})
	})
}




// 获取openid
function getOpenid() {
	uni.login({
		success: res => {
			let js_code = res.code
			var timestamp = util.getTimestamp()
			let data = {
				js_code,
				timestamp,
				key: util.sha1( timestamp + js_code)
			}
			this.getData('getOpenid', data).then(rep => {
				uni.setStorageSync('open_id', rep.openid)
				console.log('获取openid成功', uni.getStorageSync('open_id'))
			})

		}
	})
}
// 自动登录
function autoLogin() {
	var timestamp = util.getTimestamp()
	let openid = uni.getStorageSync('open_id')
	let data = {
		key: util.sha1(openid + timestamp),
		openid,
		timestamp
	}
	data = Object.assign(data, { signcode: util.sort(data) })
	uni.request({
		url: uni.getStorageSync('baseUrl') + '/autoLogin',
		header: { 'Content-Type': 'application/x-www-form-urlencoded', },
		method: 'POST',
		data,
		success: resp => {
			console.log('自动登录',resp)
			// 自动登录成功
			if (resp.data.errorcode == 0) {
				uni.setStorageSync('token', resp.data.data[0].token)
        uni.setStorageSync('userInfo', resp.data.data[0])
        uni.setStorageSync('token_bj', JSON.stringify(resp.data.data[0]))
				// uni.navigateBack({ delta: 0 })
				// uni.switchTab({
				// 	url: '/pages/index/index'
				// })
			} else {
				uni.showModal({
					title: '提示',
					content: resp.data.errormsg,
					showCancel: false,
					success: res => {
						if (res.confirm) {
							uni.navigateTo({ url: '/pages/login/login' })
						}
					}
				})
			}
		},
		fail:res=>{
			console.log('fail:',res)
		}
	})
}

module.exports = {
	getData,
	getOpenid,
	autoLogin,
  getEntrustData
}
