var config = require('../../../config/index.js')
const chipUrl = config.default.baseUrl.chipUrl

// 接口请求
function getData(name, data) {
	uni.showLoading({
		mask: true,
		title: '玩命加载中'
	})
	return new Promise(resolve => {
		// 固定要传的参
		uni.request({
			url: chipUrl + name,
			header: { 'Content-Type': 'application/x-www-form-urlencoded', },
			method: 'POST',
			data,
			success: res => {
				uni.hideLoading()
				console.log(name + '=>', data)
				console.log('response=>', res)
				var { data } = res
				if (data.ret === 1) {
					resolve(data.data)
				} else {
					uni.showToast({
						title: data.info,
						icon: 'none',
						duration: 1500,
						mask: true
					})
				}
			},
			fail() {
				uni.hideLoading()
			}
		})
	})
}

function getOpenid() {
	uni.login({
		success: res => {
			console.log('我是code', res.code)
			this.getData('Mini-GetOpenid', { code: res.code, appid: 'wx37b4be39744dc7c2' }).then(rep => {
				console.log('openid', rep)
				uni.setStorageSync('open_id', rep.openid)
				uni.setStorageSync('sessionkey', rep.sessionkey)
			})
		}
	})
}

module.exports = {
	getData,
	getOpenid
}
