function biggerImgs(urls, index) {
	uni.previewImage({
		urls,
		current: index
	})
}

function biggerImg(url) {
	uni.previewImage({
		urls: [url]
	})
}

function getTimestamp() {
	return new Date().getTime();
}

function phoneCall(tel) {
	uni.makePhoneCall({
		phoneNumber: tel
	})
}

function documentShow(url) {
	uni.showLoading({
		mask: true,
		title: '文档打开中...'
	})
	uni.downloadFile({
		url,
		success: function (res) {
			var filePath = res.tempFilePath;
			uni.openDocument({
				filePath: filePath,
				success: function (res) {
					console.log('打开文档成功');
				},
				fail: res => {
					uni.showToast({
						title: '文档打开失败',
						icon: 'none',
						duration: 2000
					})
				},
				complete() {
					uni.hideLoading();
				}
			});
		},
		fail: res => {
			console.log('res:', res);
			uni.showToast({
				title: res.errMsg,
				icon: 'none',
				duration: 2000
			})
		}
	});
}

function sha1(s) {
	var data = new Uint8Array(encodeUTF8(s))
	var i, j, t;
	var l = ((data.length + 8) >>> 6 << 4) + 16,
		s = new Uint8Array(l << 2);
	s.set(new Uint8Array(data.buffer)), s = new Uint32Array(s.buffer);
	for (t = new DataView(s.buffer), i = 0; i < l; i++) s[i] = t.getUint32(i << 2);
	s[data.length >> 2] |= 0x80 << (24 - (data.length & 3) * 8);
	s[l - 1] = data.length << 3;
	var w = [],
		f = [
			function () {
				return m[1] & m[2] | ~m[1] & m[3];
			},
			function () {
				return m[1] ^ m[2] ^ m[3];
			},
			function () {
				return m[1] & m[2] | m[1] & m[3] | m[2] & m[3];
			},
			function () {
				return m[1] ^ m[2] ^ m[3];
			}
		],
		rol = function (n, c) {
			return n << c | n >>> (32 - c);
		},
		k = [1518500249, 1859775393, -1894007588, -899497514],
		m = [1732584193, -271733879, null, null, -1009589776];
	m[2] = ~m[0], m[3] = ~m[1];
	for (i = 0; i < s.length; i += 16) {
		var o = m.slice(0);
		for (j = 0; j < 80; j++)
			w[j] = j < 16 ? s[i + j] : rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1),
				t = rol(m[0], 5) + f[j / 20 | 0]() + m[4] + w[j] + k[j / 20 | 0] | 0,
				m[1] = rol(m[1], 30), m.pop(), m.unshift(t);
		for (j = 0; j < 5; j++) m[j] = m[j] + o[j] | 0;
	};
	t = new DataView(new Uint32Array(m).buffer);
	for (var i = 0; i < 5; i++) m[i] = t.getUint32(i << 2);

	var hex = Array.prototype.map.call(new Uint8Array(new Uint32Array(m).buffer), function (e) {
		return (e < 16 ? "0" : "") + e.toString(16);
	}).join("");

	return hex;
}

function encodeUTF8(s) {
	var i, r = [],
		c, x;
	for (i = 0; i < s.length; i++)
		if ((c = s.charCodeAt(i)) < 0x80) r.push(c);
		else if (c < 0x800) r.push(0xC0 + (c >> 6 & 0x1F), 0x80 + (c & 0x3F));
		else {
			if ((x = c ^ 0xD800) >> 10 == 0) //对四字节UTF-16转换为Unicode
				c = (x << 10) + (s.charCodeAt(++i) ^ 0xDC00) + 0x10000,
					r.push(0xF0 + (c >> 18 & 0x7), 0x80 + (c >> 12 & 0x3F));
			else r.push(0xE0 + (c >> 12 & 0xF));
			r.push(0x80 + (c >> 6 & 0x3F), 0x80 + (c & 0x3F));
		};
	return r;
};

function sort(obj) {
	var newkey = Object.keys(obj).sort();
	var sortObj = {};
	for (var i = 0; i < newkey.length; i++) {
		sortObj[newkey[i]] = obj[newkey[i]];
	}
	let newObj = [];
	for (let i in sortObj) {
		var arr = {
			key: i,
			value: sortObj[i]
		}
		newObj.push(arr)
	}
	let str = '';
	for (let i = 0; i < newObj.length; i++) {
		if (newObj[i].value !== '' && newObj[i].key !== 'signcode') {
			str += newObj[i].key + newObj[i].value;
		}
	}
	newObj = sha1(getApp().globalData.appkey + str + getApp().globalData.appkey);
	return newObj;
}

function getDeviceInfo() {
	return new Promise(resolve => {
		uni.getSystemInfo({}).then(res => {
			let deviceid = res[1].brand + res[1].version + res[1].language + res[1].SDKVersion;
			let osinfo = res[1].model + res[1].system;
			resolve({
				deviceid,
				osinfo
			});
		})
	})
}

function space(lat1, lng1, lat2, lng2) {
	console.log(lat1, lng1, lat2, lng2)
	var radLat1 = lat1 * Math.PI / 180.0;
	var radLat2 = lat2 * Math.PI / 180.0;
	var a = radLat1 - radLat2;
	var b = lng1 * Math.PI / 180.0 - lng2 * Math.PI / 180.0;
	var s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(
		b / 2), 2)));
	s = s * 6378.137;
	s = Math.round(s * 10000) / 10000;
	return s
}

// 深拷贝
function deepClone(obj) {
	//判断拷贝的要进行深拷贝的是数组还是对象，是数组的话进行数组拷贝，对象的话进行对象拷贝
	var objClone = Array.isArray(obj) ? [] : {};
	//进行深拷贝的不能为空，并且是对象或者是
	if (obj && typeof obj === "object") {
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] && typeof obj[key] === "object") {
					objClone[key] = deepClone(obj[key]);
				} else {
					objClone[key] = obj[key];
				}
			}
		}
	}
	console.log(objClone);
	return objClone;
}
function getDate(type) {
	const date = new Date();

	let year = date.getFullYear();
	let month = date.getMonth() + 1;
	let day = date.getDate();

	if (type === 'start') {
		year = year - 10;
	} else if (type === 'end') {
		year = year + 10;
	}
	month = month > 9 ? month : '0' + month;;
	day = day > 9 ? day : '0' + day;

	return `${year}-${month}-${day}`;
}
//返回上一级并刷新
function backOnLoad() {
	let pages = getCurrentPages();
	let beforePage = pages[pages.length - 2];
	uni.navigateBack({
		success: function () {
			beforePage.onLoad();
		},
	});
}
module.exports = {
	getTimestamp,
	biggerImgs,
	biggerImg,
	phoneCall,
	documentShow,
	getTimestamp,
	sha1,
	encodeUTF8,
	sort,
	getDeviceInfo,
	space,
	deepClone,
	getDate,
	backOnLoad
}

