import axios from 'axios'
import { Message } from 'element-ui';
const civilRequest = axios.create({
    withCredentials: false,
    baseURL: process.env.VUE_APP_CIVIL_API_URL
})

civilRequest.interceptors.request.use(
    config => {
        const Authorization = localStorage.getItem('Authorization')
        const PermitAuthorization = localStorage.getItem('PermitAuthorization')
        if (Authorization) {
            config.headers['Authorization'] = Authorization
        }
        config.headers['key'] = 100001
        config.headers['secret'] = 'CTn5S6z5l9uKMXSw9buEqs1m0JmmViyz4GYD7RGJ'
        if (PermitAuthorization) {
            config.headers['Permit-Authorization'] = PermitAuthorization
        }
        return config
    },
    error => {
        return Promise.reject(new Error(error).message)
    }
)

civilRequest.interceptors.response.use(
    response => {
        if (response.data.status != 200) {
            Message({
                message: response.data.msg,
                type: 'error'
            })
        }

        return response.data
    },
    error => {
        Message({
            message: '服务器错误',
            type: 'error'
        })
        console.log(error)
        return Promise.reject(new Error(error).message)
    }
)

export default civilRequest
