import request from "@/utils/request"

// 地图数据


export async function getMapData(params) {
    return await request({
        url: '/site/index/mapcount',
        method: 'get',
        params, noloading: true
    })
}


// 本年问题分析
export async function getYearQuestion(params) {
    return await request({
        url: '/site/index/yearQuestion',
        method: 'get',
        params
    })
}


// 本年问题等级分析
export async function getLevelQuestion(params) {
    return await request({
        url: '/site/index/levelQuestion',
        method: 'get',
        params
    })
}

// 本年问题处理分析
export async function getStatusQuestion(params) {
    return await request({
        url: '/site/index/statusQuestion',
        method: 'get',
        params
    })
}


// 工程问题情况
export async function getProjectQuestion(params) {
    return await request({
        url: '/site/index/projectQuestion',
        method: 'get',
        params
    })
}


// // 区域问题列表  弃用
// export async function getAreaQuestionByAreaId(areaId) {
//     return await request({
//         url: `/site/index/type`,
//         method: 'get',
//         params: {
//             city_id: areaId
//         }
//     })
// }



// 区域问题列表
export async function getScoreByCity(areaId) {
    return await request({
        url: `/site/index/get_project`,
        method: 'get',
        params: {
            city_id: areaId
        }
    })
}

// 右侧得分
export async function getScoreStatusByCity(areaId) {
    return await request({
        url: `/site/index/getscore`,
        method: 'get',
        params: {
            city_id: areaId
        }
    })
}


// 获取工程列表接口
export async function getProjectList(params, noloading) {
    return await request({
        url: `/site/index/getproject`,
        method: 'get',
        params,
        noloading: noloading,
    })
}

// 获取严重问题列表
export async function getImportantQuestion() {
    return await request({
        url: `/site/index/getLevel`,
        method: 'get',
    })
}
