import axios from 'axios'
import Vue from 'vue'
import { Message, Loading } from 'element-ui';
import _ from 'lodash';
// loading框设置局部刷新，且所有请求完成后关闭loading框
let loadingInstance; //loading 实例
let needLoadingRequestCount = 0; //当前正在请求的数量
import { getAccess } from "@/api/index"
import md5 from "js-md5"
function showLoading() {
    let main = document.querySelector('#app')        //获取dom节点
    if (main) {
        if (needLoadingRequestCount === 0 && !loadingInstance) {
            loadingInstance = Loading.service({
                target: main, text: '正在加载...', background: 'rgba(0,0,0,0.6)', spinner: 'el-icon-loading'
            });
        }
        needLoadingRequestCount++;
    }
}
function closeLoading() {
    Vue.nextTick(() => { // 以服务的方式调用的 Loading 需要异步关闭
        needLoadingRequestCount--;
        needLoadingRequestCount = Math.max(needLoadingRequestCount, 0); // 保证大于等于0
        if (needLoadingRequestCount === 0) {
            if (loadingInstance) {
                hideLoading()
            }
        }
    });
}
//防抖
var hideLoading = _.debounce(() => {
    loadingInstance.close();
    loadingInstance = null;
}, 10);

const request = axios.create({
    withCredentials: false,
    // baseURL: process.env.VUE_APP_API_URL
})

request.interceptors.request.use(
    config => {
        console.log(config)
        // const Authorization = localStorage.getItem('maToken')
        // if (Authorization) {
        // config.headers['Authorization'] = Authorization
        // }
        // config.headers['Authorization'] = 'Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJhdWQiOiI1IiwianRpIjoiZjQ0MjM0NzJlMjI0NzE2NWRjOWI3YzhlMTU5OGM1NGIwYTIxM2UyMDFmNThjYjc0OWNhYjVhZWUzZDE2NzVjMGNhODlkODIzZWM3MDM1ZWMiLCJpYXQiOjE3MzE4OTE5OTQuNDU5OTY0LCJuYmYiOjE3MzE4OTE5OTQuNDU5OTcsImV4cCI6MTc2MzQyNzk5NC4zNTgyNjcsInN1YiI6IjEiLCJzY29wZXMiOlsiKiJdfQ.kHggVPwqqNdp1VBbrGiEEBJHjhN8VCeDbS22C-sIeOMFPbeo-KCxpKpISwbVGpgEuqB57tz_mCtpFUYxcQW9lHIiRkn9YV8looMjZqDnRhLk-lBsKper_9nqhh_dacVMlwyiZZuOo34H-C45IHeDbzxL2vpqYfM2DYPTBgJYw5rexM2jqyiCEQOzYmYEUCeuMvAcjXA7Y7wPVbW1b4JbI5lAnLHPtlB7n3QZ0krH4VfWNj2fKwYGeWEHEkGnnXDlBh7E1IDjbZ_n1RbpM_PBr-rmSCnK3rXOwneICW-yzIiv3oiLE5UMz04LwQZr5p_7zLJQaqkpSREWfUiKVoMdwvXtCjYomhrj4KqxUqkUJNicKDNorKNHbpg7j45b3OLJrp8_8RIL9bWAxykzkFsQCMyt7xHw8oT0ejUmGTLSSKYiAT2ZMV_S0_KWexDiDJvzC6flH0hOK7lPG7e7idjBxC1qD0phmIggn1hcmfnFJ6ZOV_XlS4VHfvTzqoLuQXaUffH_qqKLn9rvci4EedqYDOrlbh957HrrCbvnywYwahh_3R43CfhcmI494zxpdWhUKbhCqo1uNWvlR9MKL3WVP_lvswkd9JlzO17oN9oXqCpt8SPH41tVQ0BxuVUeYrMFmSmxCYuN5026VrFwYKXOF5lMsFdNBnqagIABa6gFyx8'
        if (!config.noloading) {
            showLoading()
        }
        return config
    },
    error => {
        closeLoading()
        return Promise.reject(new Error(error).message)
    }
)

request.interceptors.response.use(
    response => {
        closeLoading()
        if (response.data.status != 200) {
            Message({
                message: response.data.msg,
                type: 'error'
            })
        }

        return response.data
    },
    async (error) => {


        if (error.request.status == 401) {
            closeLoading()
            localStorage.setItem('Authorization', '')
            Message({
                message: '请先登录',
                type: 'error'
            })
            window.location.href = window.location.origin
        }
        closeLoading()
        Message({
            message: '服务器错误',
            type: 'error'
        })

        return Promise.reject(new Error(error).message)
    }
)

export default request
