import request from "@/utils/request"

// 地图数据


export async function getMapData(params) {
    return await request({
        url: '/site/index/mapcount',
        method: 'get',
        params
    })
}


// 本年问题分析
export async function getYearQuestion(params) {
    return await request({
        url: '/site/index/yearQuestion',
        method: 'get',
        params
    })
}


// 本年问题等级分析
export async function getLevelQuestion(params) {
    return await request({
        url: '/site/index/levelQuestion',
        method: 'get',
        params
    })
}

// 本年问题处理分析
export async function getStatusQuestion(params) {
    return await request({
        url: '/site/index/statusQuestion',
        method: 'get',
        params
    })
}


// 工程问题情况
export async function getProjectQuestion(params) {
    return await request({
        url: '/site/index/projectQuestion',
        method: 'get',
        params
    })
}


// 区域问题列表
export async function getAreaQuestionByAreaId(areaId) {
    return await request({
        url: `/site/index/type`,
        method: 'get',
        params: {
            city_id: areaId
        }
    })
}



// 区域问题列表
export async function getScoreByCity(areaId) {
    return await request({
        url: `/site/index/type`,
        method: 'get',
        params: {
            city_id: areaId
        }
    })
}

