import axios from 'axios'
import { Message } from 'element-ui';

const noLoadingrequest = axios.create({
    withCredentials: false,
    baseURL: process.env.VUE_APP_BASE_API,
})

noLoadingrequest.interceptors.request.use(
    config => {
        const Authorization = localStorage.getItem('Authorization')
        if (Authorization) {
            config.headers['Authorization'] = Authorization
        }
        return config
    },
    error => {
        return Promise.reject(new Error(error).message)
    }
)

noLoadingrequest.interceptors.response.use(
    response => {
        if (response.data.status != 200) {
            Message({
                message: response.data.msg,
                type: 'error'
            })
        }
        if (response.data.status == 401) {
            window.location.href = window.location.origin + '/pweb/m/login?is_screen=1'
        }
        return response.data
    },
    error => {
        console.log(error)
        return Promise.reject(new Error(error).message)
    }
)

export default noLoadingrequest
