import Vue from 'vue'
import App from './App.vue'
import router from '@/router/index'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import 'lib-flexible'
import Title from "@/components/Title"
import ShadowContainer from "@/components/ShadowContainer"
import * as echarts from "echarts"
import scroll from 'vue-seamless-scroll'
import "@/assets/iconfont/iconfont.css";

Vue.use(scroll)

Vue.prototype.$echarts = echarts
Vue.config.productionTip = false

Vue.use(ElementUI)
Vue.component('Title', Title)
Vue.component('ShadowContainer', ShadowContainer)
new Vue({
  render: h => h(App),
  router
}).$mount('#app')
