import request from "@/utils/request"

export function getXAccessToken(token) {
    return request({
        url: `/pweb/s/token/${token}`,
        method: 'get',
    })
}
export function getBaseData() {
    return request({
        url: '/pweb/s/project/basedata',
        method: 'get',
    })
}

export function getDeviceStatus() {
    return request({
        url: '/pweb/s/project/device/statis',
        method: 'get',
    })
}

export function getProgressDetail() {
    return request({
        url: '/pweb/s/project/progress',
        method: 'get',
    })
}



// real-name

export function getRealNameStatus() {
    return request({
        url: '/pweb/s/personel/basedata',
        method: 'get',
    })
}
export function getInOutData() {
    return request({
        url: '/pweb/s/personel/latestweek/workinout',
        method: 'get',
    })
}

export function getCurrentAttendance() {
    return request({
        url: '/pweb/s/personel/attendance',
        method: 'get',
    })
}
export function getPersonAreaStatus() {
    return request({
        url: '/pweb/s/personel/area',
        method: 'get',
    })
}
export function getLastWeekAttendance() {
    return request({
        url: '/pweb/s/personel/latestweek/attendance',
        method: 'get',
    })
}

export function getLastWeekWorkType() {
    return request({
        url: '/pweb/s/personel/latestweek/worktype/attendance',
        method: 'get',
    })
}

export function getWorkTypeList() {
    return request({
        url: '/pweb/s/personel/worktype/statis',
        method: 'get',
    })
}



// early-warning
export function getAIdata() {
    return request({
        url: '/pweb/s/aiwarning/basedata',
        method: 'get',
    })
}

export function getWarningList() {
    return request({
        url: '/pweb/s/aiwarning/list',
        method: 'get',
    })
}

export function getMonthWarningStatis() {
    return request({
        url: '/pweb/s/aiwarning/month/statis',
        method: 'get',
    })
}


//noise

export function getDeviceTotalStatus(params) {
    return request({
        url: '/pweb/s/device/basedata',
        method: 'get',
        params
    })
}

export function getNoiseDeviceList(params) {
    return request({
        url: '/pweb/s/device/list',
        method: 'get',
        params
    })
}