import axios from 'axios'
import { Message } from 'element-ui';
const noLoadingrequest = axios.create({
    withCredentials: false,
})

noLoadingrequest.interceptors.request.use(
    config => {
        const Authorization = localStorage.getItem('Authorization')
        const PermitAuthorization = localStorage.getItem('PermitAuthorization')
        if (Authorization) {
            config.headers['Authorization'] = Authorization
        }
        if (PermitAuthorization) {
            config.headers['Permit-Authorization'] = PermitAuthorization
        }
        return config
    },
    error => {
        return Promise.reject(new Error(error).message)
    }
)

noLoadingrequest.interceptors.response.use(
    response => {
        if (response.data.status != 200) {
            Message({
                message: response.data.msg,
                type: 'error'
            })
        }
        if (response.data.status == 401) {
            window.location.href = window.location.origin + '/pweb/m/login?is_screen=1'
        }
        return response.data
    },
    error => {
        Message({
            message: '服务器错误',
            type: 'error'
        })
        console.log(error)
        return Promise.reject(new Error(error).message)
    }
)

export default noLoadingrequest
