const { defineConfig } = require('@vue/cli-service')
module.exports = defineConfig({
  transpileDependencies: true,
  productionSourceMap: false,
  css: {
    loaderOptions: {
      postcss: {
        postcssOptions: {
          plugins: [
            require('postcss-plugin-px2rem')({
              rootValue: 55,
              mediaQuery: false, //（布尔值）允许在媒体查询中转换px。
              minPixelValue: 5 //设置要替换的最小像素值(3px会被转rem)。 默认 0
            }),
          ]
        }

      }
    }
  },
  publicPath: process.env.NODE_ENV == 'production' ? './' : '/',
  devServer: {
    port: 3000,
    proxy: {
      '/api': {
        target: 'http://localhost:8080',
        ws: false,
        changeOrigin: true,
        pathRewrite: {
          '/api': ''
        }
      },
    }
  },
  lintOnSave: true,
  pluginOptions: {
    "style-resources-loader": {
      preProcessor: "less",
      patterns: []
    }
  },
  chainWebpack: (config) => {
    config.module
      .rule('css')
      .test(/\.css$/)
      .oneOf('vue')
      .resourceQuery(/\?vue/)
      .use('px2rem')
      .loader('px2rem-loader')
      .options({
        remUnit: 75
      })
  }
})
