import request from "@/utils/request"


export function getXAccessToken(token) {
    return request({
        url: `/pweb/s/token/${token}`,
        method: 'get',
    })
}
export function getBaseInfo() {
    return request({
        url: `/pweb/s/base`,
        method: 'get',
    })
}
export function getBaseData() {
    return request({
        url: '/pweb/s/project/basedata',
        method: 'get',
    })
}

export function getPersonData() {
    return request({
        url: '/pweb/s/project/person/statis',
        method: 'get',
    })
}

export function getAIWarningData() {
    return request({
        url: '/pweb/s/project/aiwarning/statis',
        method: 'get',
    })
}

export function getDeviceStatus() {
    return request({
        url: '/pweb/s/project/device/statis',
        method: 'get',
    })
}

export function getProgressDetail() {
    return request({
        url: '/pweb/s/project/progress',
        method: 'get',
    })
}



// real-name

export function getRealNameStatus() {
    return request({
        url: '/pweb/s/personel/basedata',
        method: 'get',
    })
}
export function getInOutData() {
    return request({
        url: '/pweb/s/personel/latestweek/workinout',
        method: 'get',
    })
}

export function getCurrentAttendance(params) {
    return request({
        url: '/pweb/s/personel/attendance',
        method: 'get',
        params
    })
}
export function getPersonAreaStatus() {
    return request({
        url: '/pweb/s/personel/area',
        method: 'get',
    })
}
export function getLastWeekAttendance() {
    return request({
        url: '/pweb/s/personel/latestweek/attendance',
        method: 'get',
    })
}

export function getLastWeekWorkType() {
    return request({
        url: '/pweb/s/personel/latestweek/worktype/attendance',
        method: 'get',
    })
}

export function getWorkTypeList() {
    return request({
        url: '/pweb/s/personel/worktype/statis',
        method: 'get',
    })
}

// supervisory
export function getVideoTreeData() {
    return request({
        url: '/pweb/s/camera/listbyarea',
        method: 'get',
    })
}
export function getVideoLiveAddressUrl(cameraId) {
    return request({
        url: `/pweb/s/camera/liveaddress/${cameraId}`,
        method: 'get',
    })
}
export function getAllVideoUrl(params) {
    return request({
        url: `/pweb/s/camera/liveurls`,
        method: 'get',
        params
    })
}



// early-warning
export function getAIdata() {
    return request({
        url: '/pweb/s/aiwarning/basedata',
        method: 'get',
    })
}

export function getWarningList(params) {
    return request({
        url: '/pweb/s/aiwarning/list',
        method: 'get',
        params
    })
}

export function getStatis(params) {
    return request({
        url: '/pweb/s/aiwarning/statis',
        method: 'get',
        params
    })
}


export function getMonthWarningStatis() {
    return request({
        url: '/pweb/s/aiwarning/month/statis',
        method: 'get',
    })
}

// tower 
export function getTowerDevice(params) {
    return request({
        url: '/pweb/s/towercrane/device/statis',
        method: 'get',
        params
    })
}
export function get24hTowerStatis() {
    return request({
        url: '/pweb/s/towercrane/statis/hour',
        method: 'get'
    })
}

export function getTowerWarnings() {
    return request({
        url: '/pweb/s/towercrane/warning/list',
        method: 'get',
    })
}

export function getTowerMonitors() {
    return request({
        url: '/pweb/s/towercrane/warning/list',
        method: 'get',
    })
}

export function getTowerDeviceList() {
    return request({
        url: '/pweb/s/towercrane/device/list',
        method: 'get',
    })
}

export function getCurrentTowerStatis(params) {
    return request({
        url: '/pweb/s/towercrane/device/actual',
        method: 'get',
        params
    })
}
export function getDeviceDetail(deviceId) {
    return request({
        url: `/pweb/s/towercrane/device/${deviceId}`,
        method: 'get',
    })
}

export function getDeviceTodayChart(deviceId) {
    return request({
        url: `/pweb/s/towercrane/device/realtime/statis/${deviceId}`,
        method: 'get',
    })
}

export function getTowerLiveUrl(cameraId) {
    return request({
        url: `/pweb/s/towercrane/camera/liveaddress/${cameraId}`,
        method: 'get',
    })
}



//noise
export function getDeviceTotalStatus(params) {
    return request({
        url: '/pweb/s/env/device/statis',
        method: 'get',
        params
    })
}

export function getNearMonthStatis(params) {
    return request({
        url: '/pweb/s/env/noise/month',
        method: 'get',
        params
    })
}
export function getNoiseDeviceList(params) {
    return request({
        url: '/pweb/s/env/device/list',
        method: 'get',
        params
    })
}

export function getCurrentMonitorStatis(params) {
    return request({
        url: '/pweb/s/env/realtime/data',
        method: 'get',
        params
    })
}

export function getTodayAqiLineChartData() {
    return request({
        url: '/pweb/s/env/statis/hour',
        method: 'get',
    })
}

export function getWarningMessageList(params) {
    return request({
        url: '/pweb/s/env/warning/list',
        method: 'get',
        params
    })
}



// safecap
export function getSafeCapDeviceList(params) {
    return request({
        url: '/pweb/s/safetyhat/device/list',
        method: 'get',
        params
    })
}

export function getSafeCapArea() {
    return request({
        url: '/pweb/s/safetyhat/project/boundary',
        method: 'get',
    })
}
export function getSafeCapRoute(params) {
    return request({
        url: '/pweb/s/safetyhat/patrol/line',
        method: 'get',
        params
    })
}
export function getSafeCapUseRecords(params) {
    return request({
        url: '/pweb/s/safetyhat/device/use/list',
        method: 'get',
        params
    })
}


//fall-protection

export function getBuildingList() {
    return request({
        url: '/pweb/s/linbian/device/list',
        method: 'get',
    })

}
export function get24hourWarningData() {
    return request({
        url: '/pweb/s/linbian/day/statistics',
        method: 'get',
    })

}
export function getFallWarningList() {
    return request({
        url: '/pweb/s/linbian/today/statistics',
        method: 'get',
    })

}

export function getFallWarningStatus() {
    return request({
        url: '/pweb/s/linbian/statistics',
        method: 'get',
    })

}
export function getFallWarningTableList(params) {
    return request({
        url: '/pweb/s/linbian/warning',
        method: 'get',
        params
    })

}
export function getDeviceCurrentStatus(params) {
    return request({
        url: '/pweb/s/linbian/device/realdata',
        method: 'get',
        params
    })
}





