import request from "@/utils/request"
import noLoadingrequest from "@/utils/noloadingRequest"
console.log(window.location)



const getLocationParams = (keyWords) => {
    // 提取路由值（字符串）
    let href = window.location.href;
    // 从占位符开始截取路由（不包括占位符）
    let query = href.substring(href.indexOf("?") + 1);
    // 根据 & 切割字符串
    let vars = query.split("&");
    for (let i = 0; i < vars.length; i++) {
        let pair = vars[i].split("=");
        // 根据指定的参数名去筛选参数值
        if (pair[0] == keyWords) {
            return pair[1];
        }
    }
    return "";
};
let baseUrl = '/pweb/s'
if (getLocationParams("api_type")) {
    baseUrl = baseUrl + `/${getLocationParams("api_type")}`
}
export function getXAccessToken(token) {
    return request({
        url: `${baseUrl}/token/${token}`,
        method: `get`,
    })
}
export function getBaseInfo() {
    return request({
        url: `${baseUrl}/base`,
        method: `get`,
    })
}
export function getBaseData() {
    return request({
        url: `${baseUrl}/project/basedata`,
        method: `get`,
    })
}

export function getPersonData() {
    return request({
        url: `${baseUrl}/project/person/statis`,
        method: `get`,
    })
}

export function getAIWarningData() {
    return request({
        url: `${baseUrl}/project/aiwarning/statis`,
        method: `get`,
    })
}

export function getDeviceStatus() {
    return request({
        url: `${baseUrl}/project/device/statis`,
        method: `get`,
    })
}

export function getProgressDetail() {
    return request({
        url: `${baseUrl}/project/progress`,
        method: `get`,
    })
}

export function getPersonConfig() {
    return request({
        url: `${baseUrl}/project/person/config`,
        method: `get`
    })
}

export function getCheckInList(params) {
    return request({
        url: `${baseUrl}/project/person/list`,
        method: `get`,
        params
    })
}


export function getDeviceConfigOptions() {
    return request({
        url: `${baseUrl}/project/device/config`,
        method: `get`
    })
}

export function getDeviceList(params) {
    return request({
        url: `${baseUrl}/project/device/list`,
        method: `get`,
        params
    })
}



export function getAIWarningConfigOptions() {
    return request({
        url: `${baseUrl}/project/ai/warning/config`,
        method: `get`
    })
}

export function getAIWarningList(params) {
    return request({
        url: `${baseUrl}/project/ai/warning/list`,
        method: `get`,
        params
    })
}




// real-name

export function getRealNameStatus() {
    return request({
        url: `${baseUrl}/personel/basedata`,
        method: `get`,
    })
}
export function getInOutData() {
    return request({
        url: `${baseUrl}/personel/latestweek/workinout`,
        method: `get`,
    })
}

export function getCurrentAttendance(params) {
    return noLoadingrequest({
        url: `${baseUrl}/personel/attendance`,
        method: `get`,
        params
    })
}
export function getPersonAreaStatus() {
    return request({
        url: `${baseUrl}/personel/area`,
        method: `get`,
    })
}
export function getLastWeekAttendance() {
    return request({
        url: `${baseUrl}/personel/latestweek/attendance`,
        method: `get`,
    })
}

export function getLastWeekWorkType() {
    return request({
        url: `${baseUrl}/personel/latestweek/worktype/attendance`,
        method: `get`,
    })
}

export function getWorkTypeList() {
    return request({
        url: `${baseUrl}/personel/worktype/statis`,
        method: `get`,
    })
}

// supervisory
export function getVideoTreeData() {
    return request({
        url: `${baseUrl}/camera/listbyarea`,
        method: `get`,
    })
}
export function getVideoLiveAddressUrl(cameraId) {
    return request({
        url: `${baseUrl}/camera/liveaddress/${cameraId}`,
        method: `get`,
    })
}
export function getAllVideoUrl(params) {
    return request({
        url: `${baseUrl}/camera/liveurls`,
        method: `get`,
        params
    })
}


export function startCameraMove(id, params) {
    return noLoadingrequest({
        url: `${baseUrl}/camera/control/start/${id}`,
        method: `get`,
        params
    })
}
export function stopCameraMove(id) {
    return noLoadingrequest({
        url: `${baseUrl}/camera/control/stop/${id}`,
        method: `get`
    })
}


// early-warning
export function getAIdata() {
    return request({
        url: `${baseUrl}/aiwarning/basedata`,
        method: `get`,
    })
}

export function getWarningList(params) {
    return noLoadingrequest({
        url: `${baseUrl}/aiwarning/list`,
        method: `get`,
        params
    })
}

export function getStatis(params) {
    return request({
        url: `${baseUrl}/aiwarning/statis`,
        method: `get`,
        params
    })
}


export function getMonthWarningStatis() {
    return request({
        url: `${baseUrl}/aiwarning/month/statis`,
        method: `get`,
    })
}

// tower 
export function getTowerDevice(params) {
    return request({
        url: `${baseUrl}/towercrane/device/statis`,
        method: `get`,
        params
    })
}
export function get24hTowerStatis() {
    return request({
        url: `${baseUrl}/towercrane/statis/hour`,
        method: `get`
    })
}

export function getTowerWarnings(params) {
    return noLoadingrequest({
        url: `${baseUrl}/towercrane/warning/list`,
        method: `get`,
        params
    })
}

export function getTowerMonitors() {
    return request({
        url: `${baseUrl}/towercrane/warning/list`,
        method: `get`,
    })
}

export function getTowerDeviceList() {
    return request({
        url: `${baseUrl}/towercrane/device/list`,
        method: `get`,
    })
}

export function getCurrentTowerStatis(params) {
    return noLoadingrequest({
        url: `${baseUrl}/towercrane/device/actual`,
        method: `get`,
        params
    })
}
export function getDeviceDetail(deviceId) {
    return noLoadingrequest({
        url: `${baseUrl}/towercrane/device/${deviceId}`,
        method: `get`,
    })
}

export function getDeviceTodayChart(deviceId) {
    return noLoadingrequest({
        url: `${baseUrl}/towercrane/device/realtime/statis/${deviceId}`,
        method: `get`,
    })
}

export function getTowerLiveUrl(cameraId) {
    return noLoadingrequest({
        url: `${baseUrl}/towercrane/camera/liveaddress/${cameraId}`,
        method: `get`,
    })
}



//noise
export function getDeviceTotalStatus(params) {
    return request({
        url: `${baseUrl}/env/device/statis`,
        method: `get`,
        params
    })
}

export function getNearMonthStatis(params) {
    return request({
        url: `${baseUrl}/env/noise/month`,
        method: `get`,
        params
    })
}
export function getNoiseDeviceList(params) {
    return request({
        url: `${baseUrl}/env/device/list`,
        method: `get`,
        params
    })
}

export function getCurrentMonitorStatis(params) {
    return noLoadingrequest({
        url: `${baseUrl}/env/realtime/data`,
        method: `get`,
        params
    })
}

export function getTodayAqiLineChartData() {
    return request({
        url: `${baseUrl}/env/statis/hour`,
        method: `get`,
    })
}

export function getWarningMessageList(params) {
    return request({
        url: `${baseUrl}/env/warning/list`,
        method: `get`,
        params
    })
}


export function getRecent30DayNoiseDataList(params) {
    return request({
        url: `${baseUrl}/env/day/noise/list`,
        method: `get`,
        params
    })
}



// safecap
export function getSafeCapDeviceList(params) {
    return request({
        url: `${baseUrl}/safetyhat/device/list`,
        method: `get`,
        params
    })
}

export function getSafeCapArea() {
    return request({
        url: `${baseUrl}/safetyhat/project/boundary`,
        method: `get`,
    })
}
export function getSafeCapRoute(params) {
    return request({
        url: `${baseUrl}/safetyhat/patrol/line`,
        method: `get`,
        params
    })
}
export function getSafeCapUseRecords(params) {
    return request({
        url: `${baseUrl}/safetyhat/device/use/list`,
        method: `get`,
        params
    })
}


//fall-protection

export function getBuildingList() {
    return request({
        url: `${baseUrl}/linbian/device/list`,
        method: `get`,
    })

}
export function get24hourWarningData() {
    return request({
        url: `${baseUrl}/linbian/day/statistics`,
        method: `get`,
    })

}
export function getFallWarningList() {
    return request({
        url: `${baseUrl}/linbian/today/statistics`,
        method: `get`,
    })

}

export function getFallWarningStatus() {
    return request({
        url: `${baseUrl}/linbian/warning/statistics`,
        method: `get`,
    })

}
export function getFallWarningTableList(params) {
    return noLoadingrequest({
        url: `${baseUrl}/linbian/warning`,
        method: `get`,
        params
    })

}
export function getDeviceCurrentStatus(params) {
    return noLoadingrequest({
        url: `${baseUrl}/linbian/device/realdata`,
        method: `get`,
        params
    })
}


// unloadingplatform


export function getUnloadingPlatformList() {
    return request({
        url: `${baseUrl}/unload/device/list`,
        method: `get`,
    })
}
export function getPlatformCurrentStatus(params) {
    return noLoadingrequest({
        url: `${baseUrl}/unload/device/realdata`,
        method: `get`,
        params
    })
}
export function getPlatformRunningAnalysis(params) {
    return noLoadingrequest({
        url: `${baseUrl}/unload/device/statistics`,
        method: `get`,
        params
    })
}
export function getPlatformWarningStatus() {
    return request({
        url: `${baseUrl}/unload/warning/statistics`,
        method: `get`
    })
}
export function getPlatformWarningList(params) {
    return noLoadingrequest({
        url: `${baseUrl}/unload/warning`,
        method: `get`,
        params
    })
}


//elevator
export function getElevatorList() {
    return request({
        url: `${baseUrl}/elevator/device/list`,
        method: `get`
    })
}
export function getElevatorWarningList(params) {
    return noLoadingrequest({
        url: `${baseUrl}/elevator/warning`,
        method: `get`,
        params
    })
}

export function getElevatorWarningStatus() {
    return request({
        url: `${baseUrl}/elevator/warning/statistics`,
        method: `get`,
    })
}


export function getElevatorRealData(params) {
    return noLoadingrequest({
        url: `${baseUrl}/elevator/device/realdata`,
        method: `get`,
        params
    })
}


//projectcheck
export function getCurrentMonthCheckStats() {
    return request({
        url: `${baseUrl}/check/current/month/statistics`,
        method: `get`,
    })
}
export function getBlackspotRankingList(params) {
    return noLoadingrequest({
        url: `${baseUrl}/check/item/sort`,
        method: `get`,
        params
    })
}
export function getMonthCheckStatis(params) {
    return request({
        url: `${baseUrl}/check/month/statistics`,
        method: `get`,
        params
    })
}
export function getCorrectRecords(params) {
    return request({
        url: `${baseUrl}/check/danger`,
        method: `get`,
        params
    })
}
export function getCorrectRecordDetail(id) {
    return request({
        url: `${baseUrl}/check/${id}`,
        method: `get`,
    })
}

export function getWarningLogDetail(id) {
    return request({
        url: `${baseUrl}/device/warninglog/${id}`,
        method: `get`,
    })
}





