import request from "@/utils/request";


export async function checkLogin() {
    return await request({
        url: '/wisdom/screen/login/check',
        method: 'get'
    })
}


export async function getInfo() {
    return await request({
        url: '/wisdom/screen/noise/info',
        method: 'get'
    })
}




export async function getPM10Analysis() {
    return await request({
        url: '/wisdom/screen/noise/year/chart',
        method: 'get'
    })
}

export async function getMapData() {
    return await request({
        url: '/wisdom/screen/noise/env/project',
        method: 'get'
    })
}

export async function getPm10RateRank(type) {
    return await request({
        url: `/wisdom/screen/noise/weekpm10/${type}`,
        method: 'get'
    })
}


export async function getVideoImportList() {
    return await request({
        url: `/wisdom/screen/monitor/project`,
        method: 'get'
    })
}

export async function getStatistics() {
    return await request({
        url: `/wisdom/screen/statistics`,
        method: 'get'
    })
}

export async function getProjectDetail(id) {
    return await request({
        url: `/wisdom/screen/project/${id}`,
        method: 'get'
    })
}


export async function getRegions() {
    return await request({
        url: `/wisdom/screen/region`,
        method: 'get'
    })
}

export async function getProjectList(params) {
    return await request({
        url: `/wisdom/screen/project`,
        method: 'get',
        params,
        noloading: true,
    })
}

export async function getRealTimeDustData(id) {
    return await request({
        url: `/wisdom/screen/noise/realtime/${id}`,
        method: 'get',

    })
}

export async function getWarningList(params, id) {
    return await request({
        url: `/wisdom/screen/noise/waring/${id}`,
        method: 'get',
        params,
        noloading: true,

    })
}

export async function getDustHistory(params, id) {
    return await request({
        url: `/wisdom/screen/noise/env/${id}`,
        method: 'get',
        params,
        noloading: true,
    })
}

export async function getDustList(type) {
    return await request({
        url: `/wisdom/screen/noise/${type}`,
        method: 'get'
    })
}


export async function getProjectListByType(type) {
    return await request({
        url: `/wisdom/screen/noise/${type}`,
        method: 'get'
    })
}

