import Vue from 'vue'
import App from './App.vue'
import router from '@/router/index'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import 'lib-flexible'

import store from "@/store/index"
import * as echarts from "echarts"
import scroll from 'vue-seamless-scroll'
import Title from "@/components/common/Title"

import Section from "@/components/common/Section"
import STable from "@/components/common/STable"
import "@/assets/iconfont/iconfont.css";
import "@/assets/common/common.less"
import "@/assets/common/element.less"

import "@/utils/moment.js"

import Dialog from "@/components/common/Dialog.vue"
import DialogTabs from "@/components/common/DialogTabs.vue"
import DialogApiDataTable from "@/components/common/DialogApiDataTable.vue"

window._AMapSecurityConfig = {
  securityJsCode: 'a5006042196de6dda20a434eb443bf45',
}
Vue.use(scroll)

Vue.prototype.$echarts = echarts
Vue.prototype.$eventBus = new Vue();
Vue.config.productionTip = false

Vue.use(ElementUI)
Vue.component('Title', Title)

Vue.component('Section', Section)
Vue.component('STable', STable)
Vue.component('Dialog', Dialog)
Vue.component('DialogTabs', DialogTabs)
Vue.component('DialogApiDataTable', DialogApiDataTable)


new Vue({
  render: h => h(App),
  store,
  router
}).$mount('#app')
