import Vue from 'vue'
import Vuex from 'vuex'
import getters from './getters'
import user from './modules/user'
import mobile from './modules/mobile'
import { getReservoirRealApi, getReservoirBaseApi, getReservoirDayApi } from '@/api/reservoir.js'
import { getTfDxApi, getFutureDxApi, getFutureZiApi, getTfZiApi, getRainCalcZiApi, getRainCalcZiAddApi } from '@/api/flood.js'
Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    legendObj: {
      filterName: ['水平位移'],
      filterStatus: ['正常']
    },
    yearObj: {},
    // 水库基本信息
    reservoirBaseData: {},
    // 水库实时信息
    reservoirRealData: {},
    // 水库当天信息
    reservoirDayData: {},
    // 度汛方案源数据(预报雨量和台风)
    dxData1: [],
    // 度汛方案处理成echarts(预报雨量和台风)
    dxObj1: {
      x: [],
      ru: [],
      xia: [],
      ku: []
    },
    // 雨量自定义计算 0 左边的计算 , 1 右边的计算
    rainCalcFlagLR: 0,
    // 烟花数据

    // // 未来度汛方案源数据
    // futureDxData: [],
    // // 未来度汛方案处理后
    // futureDxObj: {
    //   x: [],
    //   ru: [],
    //   xia: [],
    //   ku: []
    // },
    footerDis: false,
    // 受灾分析需要的数据(预报雨量、烟花台风、自定义雨量左右侧计算)
    szfxData: {},
    // 51
    fiveOne: {
      startDate: '',
      gateCount: 0,
      totalRainFall: 0,
      gk: 1
    },
    fiveOneControl: [],
    // 预报雨量自定义度汛方案信息
    // 雨量预报
    // 受灾分析、预测最高水位、断面水位全部列表
    sz_rainFuture: {},
    // 烟花台风
    // 受灾分析
    sz_infoData: {
      isInfa: true,
      totalRainFall: 0,
      gateCounts1: 0,
      gateCounts2: 0,
      gateCounts3: 0,
      gateCount: 0
    },
    // 预测最高水位
    maxH_infoData: {},

    // 自定义雨量
    // 受灾分析、预测最高水位、断面水位全部列表
    sz_ziData: {
      isInfa: false,
      // 自定义的开始时间
      startDate: '',
      totalRainFall: 0,
      gateCounts1: 0,
      gateCounts2: 0,
      gateCounts3: 0,
      gateCount: 0
    },
    // 自定义雨量增量
    // 受灾分析
    sz_ziAddData: {
      isInfa: false,
      // 自定义增量的开始时间
      startDate: '',
      totalRainFall: 0,
      gateCounts1: 0,
      gateCounts2: 0,
      gateCounts3: 0,
      gateCount: 0
    },
    playerKey: 1,
    // 处理页面一开始读取不到变量↓
    // 真实水位
    rainfall_value: null,
    // 最大下泄
    flowOutMax: {
      fa1: '',
      fa2: '',
      fa3: ''
    },
    // 处理页面一开始读取不到变量 ↑
    // 洪水智能预报的标识
    rTop1Value: 0,
    futureDiaoDuData: {},
    // 台风调度过程预演
    tfDiaoDuData: {},
    rainInput: 0,
    // 雨量自定义-----------------
    // 雨量自定义-雨量预报
    rainZiData: {},
    // 雨量自定义-入库流量
    rainFlowInZiData: {},
    // 雨量自定义-度汛方案
    rainDxZiData: [],
    // 雨量自定义-度汛方案处理后
    rainDxZiObj: {
      x: [],
      ru: [],
      xia: [],
      ku: []
    },
    // 雨量自定义增量-------------
    // 雨量自定义增量-雨量预报
    rainZiAddData: {},
    rainFlowInZiAddData: {},
    rainDxZiAddData: [],
    rainDxZiAddObj: {
      x: [],
      ru: [],
      xia: [],
      ku: []
    },
    // 雨量自定义调度过程预演
    rainZiDiaoDuData: {},
    // 自定义雨量度汛方案自定义
    rainCalcZiData: {},

    // 未来自定义源数据
    futureZiData: {},
    // 未来自定义处理后
    futureZiObj: {
      x: [],
      ru: [],
      xia: [],
      ku: []
    },
    // 烟花台风度汛方案源数据
    tfDxData: [],
    // 烟花台风度汛方案处理后
    tfDxObj: {
      x: [],
      ru: [],
      xia: [],
      ku: []
    },
    // 自定义度汛方案源数据
    dxZiData: {},
    // 自定义度汛方案源数据处理后
    dxZiObj: {
      x: [],
      ru: [],
      xia: [],
      ku: []
    },
    // 烟花台风自定义数据
    tfZiData: {},
    // 烟花台风自定义处理后
    tfZiObj: {
      x: [],
      ru: [],
      xia: [],
      ku: []
    },
    // 自定义度汛方案表单
    // form1
    form1: {},

    // 未来度汛三个方案
    optimalData: [],
    // 洪水度汛三个方案
    hongshui3Data: {},

    loginFlag: false,

    // 未来
    future: false,
    // 台风
    tfFlag: false,
    // 度汛方案自定义处理后
    optimalZiObj: {
      x: [[]],
      ru: [[]],
      xia: [[]],
      ku: [[]]
    },
    optimalZiData2: {},
    // 预测库水位
    ycWater: '',
    maskTxt: false
  },
  getters,
  mutations: {
    setYearObj (state, payload) {
      state.yearObj = payload
    },
    // 储存水库基本信息
    setReservoirBase (state, payload) {
      state.reservoirBaseData = payload
    },
    // 储存水库实时信息
    setReservoirReal (state, payload) {
      state.reservoirRealData = payload
      state.rainfall_value = Number(state.reservoirRealData.rainfall_value).toFixed(2)
    },
    // 储存水库当天信息
    setReservoirDay (state, payload) {
      state.reservoirDayData = payload
    },
    // 储存度汛方案源数据并处理成echarts渲染的格式(预报雨量和台风)
    setDxData (state, payload) {
      state.dxData1 = payload
      state.dxData1.forEach((item1, i) => {
        state.dxObj1.x[i] = []
        state.dxObj1.ru[i] = []
        state.dxObj1.xia[i] = []
        state.dxObj1.ku[i] = []
        item1.regulateResults.forEach((item2) => {
          state.dxObj1.x[i].push(item2.dateTime)
          state.dxObj1.ru[i].push(item2.flowIn)
          state.dxObj1.xia[i].push(item2.flowOut)
          state.dxObj1.ku[i].push(item2.level)
        })
      })
      state.flowOutMax.fa1 = state.dxData1[0].flowOutMax
      state.flowOutMax.fa2 = state.dxData1[1].flowOutMax
      state.flowOutMax.fa3 = state.dxData1[2].flowOutMax
      console.log('度汛方案源数据', state.dxData1)
      console.log('度汛方案处理后', state.dxObj1)
    },
    // 底部禁用
    setFooterDis (state, payload) {
      state.footerDis = payload
    },
    //
    set51control (state, payload) {
      state.fiveOneControl = payload
    },
    set51FiveOne (state, payload) {
      state.fiveOne = payload
    },
    // 判断自定义雨量计算是左边还是右边的
    setRainCalcFlagLR (state, payload) {
      state.rainCalcFlagLR = payload
    },
    // 受灾分析需要的数据储存
    set_szfxData (state, payload) {
      state.szfxData = payload
    },
    // 度汛自定义计算后,阀门总开度储存
    set_szfxData_gateCount (state, payload) {
      state.szfxData.gateCount = payload
    },
    // 预报雨量
    // 受灾分析储存
    set_sz_rainFuture (state, payload) {
      state.sz_rainFuture = payload
    },
    // 闸门总开度储存
    set_sz_rainFuture_gateCount (state, payload) {
      state.sz_rainFuture.gateCount = payload
    },
    // 烟花
    // 受灾分析储存
    set_sz_infoData (state, payload) {
      state.sz_infoData = payload
    },
    set_sz_infoData_gateCount (state, payload) {
      state.sz_infoData.gateCount = payload
    },
    // 自定义雨量
    // 受灾分析储存
    set_sz_ziData (state, payload) {
      state.sz_ziData = payload
    },
    // 自定义雨量闸门总开度储存
    set_sz_ziData_gateCount (state, payload) {
      state.sz_ziData.gateCount = payload
    },
    // 自定义雨量增量
    // 受灾分析储存
    set_sz_ziAddData (state, payload) {
      state.sz_ziAddData = payload
    },
    // 自定义雨量增量闸门总开度储存
    set_sz_ziAddData_gateCount (state, payload) {
      state.sz_ziAddData.gateCount = payload
    },
    // 线路变化
    setPlayerKey (state, payload) {
      state.playerKey = payload
    },
    // 储存不同情况
    setRTop1Value (state, payload) {
      state.rTop1Value = payload
    },
    // 储存雨量预报调度过程预演数据
    setFutureDiaoDuData (state, payload) {
      state.futureDiaoDuData = payload
    },
    // 储存台风调度过程预演数据
    setTfDiaoDuData (state, payload) {
      state.tfDiaoDuData = payload
    },
    // 储存自定义调度过程预演数据(自定义雨量两个计算公用一个)
    setRainZiDiaoDuData (state, payload) {
      state.rainZiDiaoDuData = payload
    },
    // 储存自定义雨量的值
    setRainInput (state, payload) {
      state.rainInput = payload
    },
    // 保存雨量自定义-预测雨量数据
    setRainZiData (state, payload) {
      state.rainZiData = payload
    },
    // 保存雨量自定义-入库流量数据
    setRainFlowInZiData (state, payload) {
      state.rainFlowInZiData = payload
    },
    // 保存雨量自定义-度汛方案数据并处理
    setRainDxZiData (state, payload) {
      console.log('查看雨量自定义传入的', payload)
      state.rainDxZiData = payload
      state.rainDxZiData.forEach((item1, i) => {
        state.rainDxZiObj.x[i] = []
        state.rainDxZiObj.ru[i] = []
        state.rainDxZiObj.xia[i] = []
        state.rainDxZiObj.ku[i] = []
        item1.regulateResults.forEach((item2) => {
          state.rainDxZiObj.x[i].push(item2.dateTime)
          state.rainDxZiObj.ru[i].push(item2.flowIn)
          state.rainDxZiObj.xia[i].push(item2.flowOut)
          state.rainDxZiObj.ku[i].push(item2.level)
        })
      })
      state.flowOutMax.fa1 = state.rainDxZiData[0].flowOutMax
      state.flowOutMax.fa2 = state.rainDxZiData[1].flowOutMax
      state.flowOutMax.fa3 = state.rainDxZiData[2].flowOutMax
      console.log('自定义雨量度汛方案源数据', state.rainDxZiData)
      console.log('自定义雨量度汛方案处理后', state.rainDxZiObj)
    },
    // 保存雨量自定义度汛方案弹窗计算的数据
    setRainCalcZiData (state, payload) {
      console.log('查看结果', payload)
      state.rainCalcZiData = payload
    },
    setRainCalcZiAddData (state, payload) {
      state.rainCalcZiAddData = payload
    },
    // 保存雨量自定义增量 - 预测雨量数据
    setRainZiAddData (state, payload) {
      state.rainZiAddData = payload
      console.log('预测雨量数据', state.rainZiAddData)
    },
    // 保存雨量自定义增量-入库流量数据
    setRainFlowInZiAddData (state, payload) {
      state.rainFlowInZiAddData = payload
    },
    // 保存雨量自定义增量-度汛方案数据并处理
    setRainDxZiAddData (state, payload) {
      console.log('查看雨量自定义增量度汛方案传入的', payload)
      state.rainDxZiAddData = payload
      state.rainDxZiAddData.forEach((item1, i) => {
        state.rainDxZiAddObj.x[i] = []
        state.rainDxZiAddObj.ru[i] = []
        state.rainDxZiAddObj.xia[i] = []
        state.rainDxZiAddObj.ku[i] = []
        item1.regulateResults.forEach((item2) => {
          state.rainDxZiAddObj.x[i].push(item2.dateTime)
          state.rainDxZiAddObj.ru[i].push(item2.flowIn)
          state.rainDxZiAddObj.xia[i].push(item2.flowOut)
          state.rainDxZiAddObj.ku[i].push(item2.level)
        })
      })
      state.flowOutMax.fa1 = state.rainDxZiAddData[0].flowOutMax
      state.flowOutMax.fa2 = state.rainDxZiAddData[1].flowOutMax
      state.flowOutMax.fa3 = state.rainDxZiAddData[2].flowOutMax
      console.log('自定义雨量增量度汛方案源数据', state.rainDxZiAddData)
      console.log('自定义雨量增量度汛方案处理后', state.rainDxZiAddObj)
    },
    hongshui3 (state, payload) {
      state.hongshui3Data = payload
    },
    setForm1 (state, payload) {
      state.form1 = payload
    },
    login (state) {
      state.login = true
    },
    // 如果存在定义方案,则添加到transTfdx中
    addTransTfdx (state) {
      state.tfdxData2.y[0].four = state.optimalZiData2.format.level
      state.tfdxData2.y[1].four = state.optimalZiData2.format.flowOut
    },
    // 处理烟花台风方案成调度过程预演所要的格式
    transTfdx (state, payload) {
      const x = []
      const y = [{
        one: [],
        two: [],
        three: []
      }, {
        one: [],
        two: [],
        three: []
      }]
      // 取出x轴
      payload[0].regulateResults.forEach(item => {
        x.push(item.dateTime)
      })
      payload.forEach((item, index) => {
        if (index === 0) {
          item.regulateResults.forEach(item2 => {
            y[0].one.push(item2.level)
            y[1].one.push(item2.flowOut)
          })
        } else if (index === 1) {
          item.regulateResults.forEach(item2 => {
            y[0].two.push(item2.level)
            y[1].two.push(item2.flowOut)
          })
        } else if (index === 2) {
          item.regulateResults.forEach(item2 => {
            y[0].three.push(item2.level)
            y[1].three.push(item2.flowOut)
          })
        }
      })
      state.tfdxData2.x = x
      state.tfdxData2.y = y
      console.log('调度过程预演echarts', state.tfdxData2)
    },
    // getfutureDxData (state, payload) {
    //   state.futureDxData = payload
    // },

    // 储存未来雨量度汛方案源数据并处理
    setFutureDxData (state, payload) {
      state.futureDxData = payload
      state.futureDxData.forEach((item1, i) => {
        state.futureDxObj.x[i] = []
        state.futureDxObj.ru[i] = []
        state.futureDxObj.xia[i] = []
        state.futureDxObj.ku[i] = []
        item1.regulateResults.forEach((item2) => {
          state.futureDxObj.x[i].push(item2.dateTime)
          state.futureDxObj.ru[i].push(item2.flowIn)
          state.futureDxObj.xia[i].push(item2.flowOut)
          state.futureDxObj.ku[i].push(item2.level)
        })
      })
      state.flowOutMax.fa1 = state.futureDxData[0].flowOutMax
      state.flowOutMax.fa2 = state.futureDxData[1].flowOutMax
      state.flowOutMax.fa3 = state.futureDxData[2].flowOutMax
      console.log('未来度汛方案源数据', state.futureDxData)
      console.log('未来度汛方案处理后', state.futureDxObj)
    },
    // 储存未来的闸门下泄
    setFutureFlowOutMax (state) {
      state.flowOutMax.fa1 = state.futureDxData[0].flowOutMax
      state.flowOutMax.fa2 = state.futureDxData[1].flowOutMax
      state.flowOutMax.fa3 = state.futureDxData[2].flowOutMax
    },
    // 储存烟花台风下泄
    setTfFlowOutMax (state) {
      state.flowOutMax.fa1 = state.dxData[0].flowOutMax
      state.flowOutMax.fa2 = state.dxData[1].flowOutMax
      state.flowOutMax.fa3 = state.dxData[2].flowOutMax
    },
    // 储存未来雨量自定义方案数据并处理
    setFutureZiData (state, payload) {
      console.log('未来自定义源数据', payload)
      state.futureZiData = payload
    },
    setDxZiData (state, payload) {
      console.log('自定义度汛方案源数据', payload)
      state.dxZiData = payload
    },
    // 储存台风度汛方案源数据并处理
    setTfDxData (state, payload) {
      state.tfDxData = payload
      state.tfDxData.forEach((item1, i) => {
        state.tfDxObj.x[i] = []
        state.tfDxObj.ru[i] = []
        state.tfDxObj.xia[i] = []
        state.tfDxObj.ku[i] = []
        item1.regulateResults.forEach(item2 => {
          state.tfDxObj.x[i].push(item2.dateTime)
          state.tfDxObj.ru[i].push(item2.flowIn)
          state.tfDxObj.xia[i].push(item2.flowOut)
          state.tfDxObj.ku[i].push(item2.level)
        })
      })
      state.flowOutMax.fa1 = state.tfDxData[0].flowOutMax
      state.flowOutMax.fa2 = state.tfDxData[1].flowOutMax
      state.flowOutMax.fa3 = state.tfDxData[2].flowOutMax
      console.log('烟花台风度汛方案源数据', state.tfDxData)
      console.log('烟花台风度汛方案处理后', state.tfDxObj)
    },
    // 储存烟花台风自定义方案数据并处理
    setTfZiData (state, payload) {
      console.log('烟花台风自定义源数据', payload)
      state.tfZiData = payload
    },
    // 开启台风
    openTF (state) {
      state.tfFlag = true
    },
    // 关闭台风
    closeTF (state) {
      state.tfFlag = false
    },

    // 设置预测水位
    setYCWater (state, payload) {
      state.ycWater = payload
    },
    // 重置预测水位
    resetYCWater (state) {
      state.ycWater = ''
    },
    // 遮住水印的
    changeMaskTxt (state) {
      state.maskTxt = true
    }
  },
  actions: {
    // 水库三个信息
    async getReservoirAction ({ commit }) {
      try {
        const [res1, res2, res3] = await Promise.all([getReservoirBaseApi(), getReservoirRealApi(), getReservoirDayApi()])
        // 水库基本信息
        commit('setReservoirBase', res1)
        // 水库实时信息
        commit('setReservoirReal', res2)
        // 水库当天
        commit('setReservoirDay', res3)
      } catch (error) {
        console.log(error)
      }
    },
    async getInfoDataAction ({ commit }) {

    },
    // 单独拿水库实时信息
    async getReservoirRealAction ({ commit }) {
      const res = await getReservoirRealApi()
      // 水库实时信息
      commit('setReservoirReal', res)
      console.log('水库实时信息', res)
    },
    // 自定义雨量度汛方案弹窗自定义计算
    async getRainZiDxCalcAction ({ commit }, payload) {
      const res = await getRainCalcZiApi(payload)
      console.log('查看自定义雨量度汛方案自定义计算结果', res)
      commit('setRainCalcZiData', res)
    },
    // 自定义雨量增量度汛弹窗自定义
    async getRainZiAddDxCalcAction ({ commit }, payload) {
      const res = await getRainCalcZiAddApi(payload)
      console.log('查看自定义雨量增量度汛方案自定义计算结果', res)
      // commit('setRainCalcZiAddData', res)
      commit('setRainCalcZiData', res)
    },
    // 未来度汛方案
    async getfutureDxAction ({ state, commit }) {
      console.log('查看水位', state.reservoirRealData.water_level_value)
      const res = await getFutureDxApi(state.reservoirRealData.water_level_value)
      commit('setDxData', res)
    },
    // 烟花台风度汛方案
    async getTfDxAction ({ state, commit }) {
      const res = await getTfDxApi(162.14)
      commit('setTfDxData', res)
    },
    // 未来自定义方案
    async getfutureZiAction ({ commit }, payload) {
      const res = await getFutureZiApi(payload)
      commit('setDxZiData', res)
    },
    // 烟花台风自定义方案
    async getTfZiAction ({ commit }, payload) {
      const res = await getTfZiApi(payload)
      commit('setDxZiData', res)
    }
  },
  modules: {
    user,
    mobile
  }
})
