import service from '@/utils/service'
// 兴利调控控运计划
export function getXingLiFa1Api (level) {
  return service({
    url: '/xinglischeduling/current',
    params: {
      level
    }
  })
}

// 兴利调控推荐方案
export function getXingLiFa2Api (level) {
  return service({
    url: '/xinglischeduling/recommend',
    params: {
      level
    }
  })
}
// 兴利调控自定义方案
export function getXingLiFa3Api (params) {
  return service({
    url: '/xinglischeduling/custom',
    params
  })
}

// 获取水库年度每天的数据
export function getYearlistApi (params) {
  return service({
    url: '/reservoir/yearlist',
    params
  })
}

// 数据采集
export function getWaterStatisticsApi () {
  return service({
    url: '/waterquality/statistics'
  })
}

// 获取水质每天的数据
export function getWaterQualityDayApi (params) {
  return service({
    url: '/waterquality/day',
    params
  })
}

// 获取水质监测点列表
export function getWaterQualityListApi () {
  return service({
    url: '/waterquality'
  })
}
// 获取水质实时数据
export function getWaterQualityApi (id) {
  return service({
    url: '/waterquality/info',
    params: {
      point_id: id
    }
  })
}
// 水资源调度
export function getWatersupplyApi () {
  return service({
    url: '/watersupply/day'
  })
}

// 历史入库流量过程
export function getHisFlowInApi (params) {
  return service({
    url: '/reservoir/daylist',
    params
  })
}

// 水资源优化配置
// 城市供水计划
export function getCityWaterApi () {
  return service({
    url: '/watersupply/plan'
  })
}
// 实际灌溉供水
export function getRealGgWaterApi () {
  return service({
    url: '/waterirrigation'
  })
}
// 计划灌溉供水
export function getPlanGgWaterApi () {
  return service({
    url: '/waterirrigation/plan'
  })
}

// 获取旱情预警 兴利状态与调度图
export function getDroughtApi () {
  return service({
    url: '/xinglischeduling/info'
  })
}

// 获取摄像头列表
export function getXingLiApi () {
  return service({
    url: '/xinglischeduling'
  })
}
