import service from '@/utils/service'

// 上班人员
export function getWorkPeopleApi (params) {
  return service({
    url: '/device/personnels',
    params: {
      page: 1,
      limit: 1000
    }
  })
}

// 雨量水位形势
export function getRainWaterlevelApi (params) {
  return service({
    url: '/reservoir/daylist',
    params
  })
}

// 获取摄像头列表
export function getVideoApi (obj) {
  return service({
    url: '/video',
    params: {
      is_online: 1,
      is_warning: 0,
      is_important: 0,
      limit: 1000
    }
  })
}

// 天气
export function getWeatherApi (date) {
  return service({
    url: '/weather/forecast',
    params: {
      date
    }
  })
}

export function getFutureRainApi (params) {
  return service({
    url: '/future/rainave',
    params
  })
}
