const px2rem = require('postcss-px2rem')
const path = require('path')
const postcss = px2rem({
  remUnit: 80
})

module.exports = {
  publicPath: './',
  outputDir: 'dist',
  devServer: {
    open: true,
    proxy: {
      '/hjsk': {
        target: 'http://skdev.vnet1000.net/clients/v1',
        changeOrigin: true,
        pathRewrite: {
          '^/hjsk': ''
        }
      },
      '/51/': {
        target: 'http://51.guangchuan.org/51world/',
        changeOrigin: true,
        // rewrite: (path) => path.replace('/51/', '')
        pathRewrite: {
          '/51/': ''
        }
        // pathRewrite: path => path.replace('/51/', '')
      },
      '/api/': {
        target: 'http://apiservice.zjszsk.com/api/LiveServicePlay/',
        changeOrigin: true,
        pathRewrite: {
          '/51/': ''
        }
      }
    }
  },
  lintOnSave: true,
  css: {
    loaderOptions: {
      postcss: {
        plugins: [
          postcss
        ]
      }
    }
  },
  pluginOptions: {
    'style-resources-loader': {
      preProcessor: 'scss', // 自动注入less文件到页面style中
      // 指定注入什么文件
      patterns: [
        // __dirname为项目根目录
        path.join(__dirname, './src/styles/common.scss')
      ]
    }
  }

}
