import * as auth from '@/utils/authentication'
import { loginApi, getUserInfoApi } from '@/api/user.js'

export default {
  namespaced: true,
  state: {
    token: auth.getToken(),
    userInfo: {}
  },
  mutations: {
    setToken (state, token) {
      state.token = token
      auth.setToken(token)
    },
    delToken (state) {
      state.token = null
      auth.removeToken()
    },
    setUserInfo (state, userInfo) {
      state.userInfo = userInfo
    },
    delUserInfo (state) {
      state.userInfo = {}
    }
  },
  actions: {
    async getTokenAction ({ commit }, formData) {
      const token = await loginApi(formData)
      console.log('获取token', token)
      const userToken = token.access_token
      commit('setToken', userToken)
    },
    async getUserInfoAction ({ commit }) {
      const userInfo = await getUserInfoApi()
      // const photoInfo = await getUserDetailById(userInfo.userId)
      // console.log('登录人信息和头像', userInfo, photoInfo)
      console.log('登录人信息', userInfo)
      // commit('setUserInfo', { ...userInfo, ...photoInfo })
      commit('setUserInfo', userInfo)
    },
    async logoutAction ({ commit }) {
      commit('delToken')
      commit('delUserInfo')
    }
  }
}
