import Vue from 'vue'
import VueRouter from 'vue-router'
import store from '@/store'

import Layout from '@/layout'
import Login from '@/views/login'
import Jump from '@/layout/jump.vue'
import Engineering from './modules/engineering'
import Flood from './modules/flood'
import Operate from './modules/operate'
// import maintain from './modules/maintain'
import mobileTerminal from './modules/mobile-terminal'

Vue.use(VueRouter)

const whiteList = ['/login', '/404']

const routes = [
  {
    path: '/',
    redirect: '/jump'
  },
  {
    path: '/login',
    component: Login
  },
  {
    path: '/',
    component: Layout,
    children: [
      {
        path: '/home',
        component: () => import('@/views/home'),
        meta: {
          pageName: '孪生底座'
        }
      },
      Engineering,
      Flood,
      Operate,
      {
        path: '/water-zx',
        component: () => import('@/views/operate/components/water-analysis.vue'),
        meta: {
          pageName: '水生态综合治理'
        }
      }
      // {
      //   path: '/water-analysis',
      //   component: () => import('@/views/operate/components/water-analysis.vue'),
      //   meta: {
      //     pageName: '水生态综合治理'
      //   }
      // }
      // maintain
      // {
      //   path: '/maintain',
      //   component: () => import('@/views/maintain'),
      //   meta: {
      //     pageName: '应急决策'
      //   }
      // }
      // {
      //   path: '/manage',
      //   component: () => import('@/views/manage'),
      //   meta: {
      //     pageName: '调度管理'
      //   }
      // },
      // {
      //   path: '/help',
      //   component: () => import('@/views/help'),
      //   meta: {
      //     pageName: '公共服务'
      //   }
      // }
    ]
  },
  mobileTerminal,
  {
    path: '/jump',
    component: Jump
  }
]

const router = new VueRouter({
  routes
})

// 原登录页
// router.beforeEach(async (to, from, next) => {
//   // console.log('当前跳转信息', to, from)
//   if (store.getters.token) {
//     if (to.path === '/login') {
//       next('/')
//     } else {
//       next()
//       if (!store.getters.name) {
//         await store.dispatch('user/getUserInfoAction')
//       }
//     }
//   } else {
//     if (whiteList.includes(to.path)) {
//       next()
//     } else {
//       next('/login')
//     }
//   }
// })

router.beforeEach(async (to, from, next) => {
  // console.log('当前跳转信息', to, from)
  if (store.getters.token) {
    if (to.path === '/login') {
      next('/jump')
    } else {
      next()
      if (!store.getters.name) {
        await store.dispatch('user/getUserInfoAction')
      }
    }
  } else {
    if (whiteList.includes(to.path)) {
      next()
    } else {
      next('/login')
    }
  }
})

// router.afterEach((to, from) => {
//   console.log('页面跳转完了', to, from)
// })

export default router
