import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'

import '@/styles/css-reset.css'
import '@/styles/common.scss'
import '@/styles/iconfont/iconfont.css'
import '@/styles/iconfont2/iconfont.css'
import my from '@/utils/my.js'
import myComponents from '@/components/index.js'
// vant
import Vant, { Lazyload } from 'vant'
import './styles/vant-variables.less'
// element
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import '@/styles/element-variables.scss'
import echartsPlugins from './utils/echartsPlugins'
import dayjsPlugins from './utils/dayjsPlugins'
import scroll from 'vue-seamless-scroll'
import vueAnimateNumber from 'vue-animate-number'
// import '@/utils/flexibleChange.js'
// if (process.env.NODE_ENV === 'production') {
//   console.log = console.table = () => { }
// }
console.log('main.js 查看环境变量', process.env)

Vue.prototype.$eventBus = new Vue()
Vue.use(scroll)
Vue.use(dayjsPlugins)
Vue.use(my)
Vue.use(ElementUI)
Vue.use(Vant)
Vue.use(Lazyload)
Vue.use(vueAnimateNumber)
Vue.use(myComponents)
Vue.use(echartsPlugins)

Vue.config.productionTip = false

new Vue({
  el: '#app',
  router,
  store,
  render: h => h(App)
}).$mount('#app')
