import service from '@/utils/service'
import dayjs from 'dayjs'
// 水库基本信息
export function getReservoirBaseApi () {
  return service({
    method: 'GET',
    url: '/reservoir'
  })
}

// 水库实时信息
export function getReservoirRealApi (data) {
  return service({
    method: 'GET',
    url: '/reservoir/real',
    data
  })
}

// 水库当天数据
export function getReservoirDayApi () {
  return service({
    method: 'GET',
    url: '/reservoir/daydata',
    params: {
      start_date: dayjs(Date.now()).format('YYYY-MM-DD'),
      end_date: dayjs(Date.now()).format('YYYY-MM-DD')
    }
  })
}

// 获取泄洪闸列表
export function getSluicegateApi () {
  return service({
    method: 'GET',
    url: '/sluicegate'
  })
}
