import service from '@/utils/service'

/* 日常巡检 */
// 日常巡查列表
export function getPatrolStageApi (params) {
  return service({
    url: '/patrol/stage',
    params
  })
}
// 日历中哪些已经巡查
export function getPatrolTrajectoryApi (params) {
  return service({
    url: '/patrol/trajectory',
    params
  })
}
// 点击日历查看巡查详情
export function getPatrolApi (id) {
  return service({
    url: '/patrol',
    params: {
      patrol_trajectory_id: id
    }
  })
}

/* 汛前检查 */
export function getJobconfigFloodApi (keywords) {
  return service({
    url: '/patrol/jobconfig/flood',
    params: {
      keywords,
      limit: 15
    }
  })
}

// 年度检查
export function getJobconfigAnnualApi (keywords) {
  return service({
    url: '/patrol/jobconfig/annual',
    params: {
      keywords,
      limit: 15
    }
  })
}

// 特别检查
export function getJobconfigEspecialApi (keywords) {
  return service({
    url: '/patrol/jobconfig/especial',
    params: {
      keywords,
      limit: 15
    }
  })
}
