export const treeData = [
  {
    id: 13,
    parent_id: 0,
    sort: 1,
    label: '漫顶',
    reservoir_id: 3,
    child_num: 4,
    name: '漫顶',
    children: [
      {
        id: 25,
        parent_id: 13,
        sort: 1,
        label: '险情概述',
        reservoir_id: 3,
        child_num: 0,
        name: '险情概述',
        children: [
          {
            label: '漫顶',
            cat_id: 25,
            plan_title: '漫顶',
            id: 3,
            content: '<div class="reason" style="margin: 30px 0px 10px; padding: 0px; border: 0px; vertical-align: baseline;" font-size:18px;color:#ff9900;"="">\n<p class="MsoNormal">\n\t<strong>抢险思路和原则</strong>\n</p>\n<p class="MsoNormal">\n\t1、工程抢险\n</p>\n<p class="MsoNormal">\n\t（1）首先应考虑加大泄洪流量，增加泄洪能力，降低库水位，防止洪水漫顶。\n</p>\n<p class="MsoNormal">\n\t（2）其次也可临时加高坝顶，即根据上游来水、水位上涨等情况，临时增加坝顶高程，防止洪水漫顶。\n</p>\n<p class="MsoNormal">\n\t（3）确有必要时也可在大坝坝顶、下游坡及趾脚设置防护设施后让大坝临时过水。\n</p>\n<p class="MsoNormal">\n\t2、人员等撤离\n</p>\n<p class="MsoNormal">\n\t水库安全影响区内的人员、可移动设备、物资等应紧急转移到安全地带，首先必须确保人员安全。\n</p>\n<p class="MsoNormal">\n\t<strong>注意事项</strong>\n</p>\n<p class="MsoNormal">\n\t（1）首先应将下游人员等安全撤离。\n</p>\n<p class="MsoNormal">\n\t（2）在降低库水位同时，应采取必要措施，确保大坝在库水位骤降工况下上游坝坡的抗滑稳定。\n</p>\n<p class="MsoNormal">\n\t（3）在降低库水位同时，应在下游坝脚增加必要的消能防冲保护。\n</p>\n<p class="MsoNormal">\n\t（4）采用爆破方法时，必须首先将爆破影响区的人员安全撤离，同时应注意爆破的方式、范围及药量，避免由于爆破引发其它险情。\n</p>\n<p class="MsoNormal">\n\t（5）临时加高坝体应抢在洪水之前完成，并做好加高部分的止水工作。指定专人巡视检查，发现问题应及时处理。\n</p>\n<p class="MsoNormal">\n\t（6）水库水位抬高后，大坝（副坝）可能会同步产生其它险情，应密切注意并采取相应措施。\n</p>\n<p class="MsoNormal">\n\t（7）坝顶临时过水应慎用，不到万不得已不应轻易动用。坝体、坝肩、坝脚一定范围内必须全面覆盖土工膜、彩条布。锚固措施牢靠。\n</p>\n<p class="MsoNormal">\n\t（8）破坝泄洪风险较大，应慎用，只有在其它方法难以有效降低水库水位时，才考虑适用。同时必须及时动态掌握水位变化情况、气象资料，采取措施防止溃坝。\n</p>\n\t</div>\n\t<p>\n\t\t<br />\n\t</p>',
            sort: 11,
            reservoir_id: 3,
            update_time: '2021-11-24 10:13:59',
            create_time: '2021-11-22 18:56:06'
          }
        ],
        childrenType: 1
      },
      {
        id: 14,
        parent_id: 13,
        sort: 1,
        label: '降低库水位',
        reservoir_id: 3,
        child_num: 3,
        name: '降低库水位',
        children: [
          {
            id: 17,
            parent_id: 14,
            sort: 1,
            label: '无动力真空虹吸',
            reservoir_id: 3,
            child_num: 0,
            name: '无动力真空虹吸',
            children: [
              {
                label: '无动力真空虹吸',
                cat_id: 17,
                plan_title: '无动力真空虹吸',
                id: 4,
                content: '<p class="MsoNormal">\n\t<strong>发生原因</strong>\n</p>\n<p class="MsoNormal">\n\t大坝防洪标准偏低。\n</p>\n<p class="MsoNormal">\n\t<strong>详情描述</strong>\n</p>\n<p class="MsoNormal">\n\t采用水库防汛无动力真空虹吸溢洪成套设备等方法排水。。\n</p>\n<p class="MsoNormal">\n\t<strong>示意图</strong>\n</p>\n<p class="MsoNormal">\n\t<br />\n</p>\n<p class="MsoNormal" style="text-align:center;vertical-align:baseline;">\n\t<img src="data:image/png;base64,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" alt="" /> \n</p>\n<p>\n\t<br />\n</p>',
                sort: 12,
                reservoir_id: 3,
                update_time: '2021-11-24 10:14:12',
                create_time: '2021-11-23 16:54:07'
              }
            ],
            childrenType: 1
          },
          {
            id: 18,
            parent_id: 14,
            sort: 2,
            label: '非常措施',
            reservoir_id: 3,
            child_num: 0,
            name: '非常措施',
            children: [
              {
                label: '非常措施',
                cat_id: 18,
                plan_title: '非常措施',
                id: 7,
                content: '<strong>发生原因</strong><br />\n大坝防洪标准偏低<br />\n<strong>详情描述</strong><br />\n为保障大坝（或主坝）免遭洪水漫顶溃坝，在紧情况下，为有效加快泄洪流量，使水库转危为安，可采取以下非常措施：<br />\n①用爆破的方式加深、加宽溢洪道，降低溢流堰顶高程；采用该方式时，应做好以下各项准备工作：事先规定引爆信号，或派出专人通知下游危险地区（含淹没区）的村庄及群众，在规定时间以前做好搬迁转移工作。如发生在黑夜、暴雨洪水之时，往往通信中断或桥梁被冲，道路交通受阻，应选派专人排除一切艰险，万无一失地完成全部安全转移工作。人员等转移的同时，准备炸药、雷管等爆破物资，做好爆破计划，选好爆破位置，确保爆破达到预想的效果。人员等安全转移后，及时进行爆破。<br />\n②选择适宜的山凹哑口（或大坝、副坝）破口泄洪。 在山凹哑口（或大坝、副坝）合适部位开槽进行泄洪，坝顶开槽完成后，在槽内四周铺设土工膜防冲。应特别注意防冲材料的四周连接固定，以防被水冲走。有条件时可以采用钢管（如脚手架钢管）网格压住防冲材料，钢管网格采用锚杆深入坝体土中加固。<br />\na、坡坝泄洪特点 可采用大型施工机械施工，速度快；可快速降低水库水位；可根据工程抢险实际需要控制水库水位。<br />\nb、适用范围 在大坝、副坝险情十分严重，下游保护对象比较重要或十分重要，且采取其它简易措施3~5天内无法排除险情的情况下，可采用破坝泄洪。一般应用在坝高比较低的小型土石坝上。<br />\n<p>\n\t<strong>示意图</strong>\n</p>\n<p>\n\t<strong><img src="data:image/png;base64,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',
                sort: 13,
                reservoir_id: 3,
                update_time: '2021-12-01 14:09:15',
                create_time: '2021-12-01 14:08:31'
              }
            ],
            childrenType: 1
          },
          {
            id: 19,
            parent_id: 14,
            sort: 3,
            label: '已有建筑加速泄洪',
            reservoir_id: 3,
            child_num: 0,
            name: '已有建筑加速泄洪',
            children: [
              {
                label: '已有建筑加速泄洪',
                cat_id: 19,
                plan_title: '已有建筑加速泄洪',
                id: 8,
                content: '<p>\n\t<strong>发生原因</strong>\n</p>\n<p>\n\t（1）泄洪设施出险；\n</p>\n（2）大坝防洪标准偏低；<br />\n<p>\n\t<strong>详情描述</strong>\n</p>\n利用已有放水建筑物加速泄洪。可将已有放水建筑物如溢洪道、放水涵管（洞）、电站引水洞、电站闸阀等闸门全部打开，宣泄洪水。如果已有放水建筑物过水能力不大，即使闸门全部打开，仍难以承担应有的泄洪流量时，可考虑将已有的输水隧洞闸门打开，增加泄量，起到保坝作用。<br />\n<p>\n\t<strong>示意图</strong>\n</p>\n<p>\n\t<strong><br />\n</strong>\n</p>',
                sort: 14,
                reservoir_id: 3,
                update_time: '2021-12-01 14:10:35',
                create_time: '2021-12-01 14:10:35'
              }
            ],
            childrenType: 1
          }
        ],
        childrenType: 0
      },
      {
        id: 15,
        parent_id: 13,
        sort: 2,
        label: '临时加高坝顶',
        reservoir_id: 3,
        child_num: 4,
        name: '临时加高坝顶',
        children: [
          {
            id: 20,
            parent_id: 15,
            sort: 1,
            label: '土袋挡水子堰',
            reservoir_id: 3,
            child_num: 0,
            name: '土袋挡水子堰',
            children: [
              {
                label: '土袋挡水子堰',
                cat_id: 20,
                plan_title: '土袋挡水子堰',
                id: 9,
                content: '<p>\n\t<strong>发生原因</strong>\n</p>\n<p>\n\t遭遇超标准洪水\n</p>\n<p>\n\t<strong>详情描述</strong>\n</p>\n<p>\n\t（1）土料子堤\n</p>\n①土料子堤适用于堤顶较宽，就近取土容易，风浪不大的坝工。<br />\n②施工时，先将子堤与原坝顶接触面上的杂草清除，中间开挖一条宽0.5m，深0.2m~0.5m的接合槽，然后分层铺土，铺松土厚度每层控制在0.3m内，并进行必要的夯压，使子堤与原堤顶紧密结合，子堤顶宽一般不小于1.0m~1.5m，内外边坡不小于1：1.5，高度根据实际情况而定。如有风浪，应在子堤迎水面铺设土工膜保护。<br />\n（2）土袋子堤<br />\n土袋子堤适用于坝顶较窄，附近取土较难或土料质量不好，风浪冲击较大的水库。<br />\na、人员组织：应将抢险人员分成取土、装袋、运输、铺设等小组，分头各行其事，做到紧张有序，忙而不乱。<br />\nb、土袋准备：土袋可用编织袋、麻袋，袋内装土七八成满。<br />\nc、铺设进占：在距上游坝肩0.5～1.0m处，将土袋沿坝轴线紧密铺砌，袋口朝向背水面，堰顶高度应超过推算的最高水位0.5～1.0m。堰高不足1.0m的可只铺设单排土袋，较高的子堰应根据高度加宽底层土袋的排数；铺设土袋时，应迅速抢铺完第一层，再铺第二层，上下层土袋应错缝铺砌。<br />\nd、止水：应随同铺砌土袋的同时，进行止水工作。止水方式可采用在土袋迎水面铺土工膜或在土袋后打土堤墙；采用土工膜止水时，膜与膜之间采用折扣搭接，长度不小于0.5m，在土袋底层脚前沿坝轴线挖0.2m深的槽，将土工膜底边埋入槽内，再在土工膜外铺一排土袋，将土工膜夹于两排土袋之间；采用土袋止水时，要在土袋底层边沿坝轴线挖宽0.3m、深0.2m的结合槽，然后分层铺土夯实，土袋边坡不小于1∶1。 e、随着水位的上涨，应始终保持挡水子堰高过洪水位直至洪水下落到原坝顶以下，大坝脱险为止。<br />\n<p>\n\t<strong>示意图</strong>\n</p>',
                sort: 15,
                reservoir_id: 3,
                update_time: '2021-12-01 14:11:38',
                create_time: '2021-12-01 14:11:38'
              }
            ],
            childrenType: 1
          },
          {
            id: 21,
            parent_id: 15,
            sort: 2,
            label: '加固防浪墙',
            reservoir_id: 3,
            child_num: 0,
            name: '加固防浪墙',
            children: [
              {
                label: '加固防浪墙',
                cat_id: 21,
                plan_title: '加固防浪墙',
                id: 10,
                content: '<p>\n\t<strong>发生原因</strong>\n</p>\n<p>\n\t遭遇超标准洪水\n</p>\n<p>\n\t<strong>详情描述</strong>\n</p>\n<p>\n\t土坝坝顶如设有防浪墙，为确保防浪墙在水压力作用下保持稳定，应快速在防浪墙后侧用土袋抢筑临时支撑体，即在防浪墙后堆土夯实，做成子堤，或用土袋在防浪墙后加高加固成子堤。如防浪墙止水性差，为防止漏水，可先在防浪墙迎水面铺设一层土工膜止水截渗，然后在墙后铺筑子堤。\n</p>\n<p>\n\t<strong>示意图</strong>\n</p>\n<p>\n\t<strong><br />\n</strong>\n</p>',
                sort: 16,
                reservoir_id: 3,
                update_time: '2021-12-01 14:12:10',
                create_time: '2021-12-01 14:12:10'
              }
            ],
            childrenType: 1
          },
          {
            id: 22,
            parent_id: 15,
            sort: 3,
            label: '吸水速凝挡水子堤',
            reservoir_id: 3,
            child_num: 0,
            name: '吸水速凝挡水子堤',
            children: [
              {
                label: '吸水速凝挡水子堤',
                cat_id: 22,
                plan_title: '吸水速凝挡水子堤',
                id: 11,
                content: '<p>\n\t<strong>发</strong><strong>生原因</strong>\n</p>\n<p>\n\t遭遇超标准洪水。\n</p>\n<p>\n\t<strong>详情描述</strong>\n</p>\n<p>\n\t吸水速凝挡水子堤是由土工织物做外袋、土工膜做内袋和装在内袋里的高效保水材料以及护垫、加强带、注水孔、防渗带、防渗条等组成，袋体吸（充）水后体积胀大，随即水体凝结成具有一定抗压强度能自立的胶凝体，从而沿坝顶形成一道连续矮墙，即挡水子堤。\n</p>\n①应用范围<br />\n可防止漫溢、防浪，适用于水库挡水、防漫溢抢险工程。<br />\n②子堤尺寸 高：0.8m、1.0m、1.2m；长：3~5m。<br />\n③主要特点 防止洪水漫顶，抗御风浪，具有以下显著特点：<br />\na、子堤高度与形状可按设计要求确定，充水后可快速将液体水变为胶凝体，发挥挡水作用，满足防汛应急需要。<br />\nb、袋内充填物为水体，不需要开挖运送土料，节约大量的人力、物料和运输工作，有利于环保与生态，在缺乏土料的地方，优越性十分明显，并且充水操作迅速、效率高、速度快，在防汛千钧一发的紧急时刻，能快速应对。<br />\nc、高效保水材料是环保型新材料，其无毒、无味、无污染。<br />\nd、充水前的子堤重量轻（7.5kg/m）、体积小（0.05m3/m），人工搬运方便。防潮、密封包装，方便储存。<br />\ne、汛后拆除子堤，只要剖开管袋，胶凝体慢慢泄出，会自动还原成无毒的天然水。<br />\nf、施工时除需要充水水泵、防滑钉与简单工具外，无其它设备要求，无需复杂技术，安装简易。<br />\ng、与充填土料的防汛袋、其它子堤技术相比，安装工程费用低廉。<br />\n④施工方法<br />\na、辅助器材与工具：水泵、锤子、防滑钉。<br />\nb、为使子堤充水后，防止破坏和减少底部渗漏，铺放子堤前应将堤顶杂物清除，刨去尖硬块体和草根，填平凹坑，使子堤与堤顶接触良好。距迎水面坝肩1m~1.65m处，沿堤轴线方向，以石灰划出与堤轴线平行的纵向定位线。沿防渗带摆放线外侧（靠背水面）摆放防渗带，带与带之间重叠0.5m，用射钉枪每隔1m用射钉固定。沿子堤摆放线外侧（靠背水面）纵向摆放单元子堤，子堤中部要压住防渗带接头,子堤前缘对准石灰线，前护垫长1.5m，其中的0.5m护垫可覆盖在坝体迎水面上，拉平放直，整个底部平伏贴于坝顶。各单元子堤端部对接，形成直线。<br />\nc、子堤充水、固定、放置防渗条： 子堤顶部留有注水孔，连接孔口与水泵软管，缓慢往袋内灌水，至灌满袋体积的1/3，暂停进水，检查管袋位置是否正确和整齐呈一条直线，各管袋端部是否挤紧不存在缝隙，如有错位及缝隙，应及时调整，就位后在前后护垫的预设扣眼处打入防滑钉，固定子堤。在单元子堤端向底部横向铺设防渗条，防渗条要侧立放置，夹在子堤端部并紧靠坝顶面。<br />\nd、子堤全高充水，固定加强带 继续充水至全高后，将加强带拉直与迎水面护垫接触后，用防滑钉固定。<br />\ne、子堤质量检查 子堤完工后应进行全线检查。 割破的漏洞以事先准备好的柔软片材阻塞，不平整处以同样材料的充水速凝小块填塞。 子堤使用期间，同样应加强全线巡回检查。<br />\nf、子堤拆除 割破子堤的内、外袋，将淌出的胶凝体推入水库中；将子堤卷起、打捆、运走；将现场的防滑钉拔掉；清除其余垃圾。<br />\n<p>\n\t<strong>示意图</strong>\n</p>',
                sort: 17,
                reservoir_id: 3,
                update_time: '2021-12-01 14:13:38',
                create_time: '2021-12-01 14:13:26'
              }
            ],
            childrenType: 1
          },
          {
            id: 23,
            parent_id: 15,
            sort: 4,
            label: '应急子堤',
            reservoir_id: 3,
            child_num: 0,
            name: '应急子堤',
            children: [
              {
                label: '应急子堤',
                cat_id: 23,
                plan_title: '应急子堤',
                id: 12,
                content: '<p>\n\t<strong>发生原因</strong>\n</p>\n<p>\n\t遭遇超标准洪水。\n</p>\n<p>\n\t<strong>详情描述</strong>\n</p>\n<p>\n\t①应用范围\n</p>\n主要用于应急防漫顶防险，防止由于大坝遭到超标准特大洪水，库水位猛涨并超过大坝坝顶高程而造成漫溢成灾,防止在汛期高水位，由于遭受强风大浪库水翻越坝顶而造成险情。<br />\n②主要特点<br />\n装配板坝式应急挡水子堤突破传统思想模式，摒弃传统筑堤材料、工艺，是一种全新、快捷、廉价、环保型防灾减灾器材。具有以水治水、高效快捷；组坝灵活、适应性强；便于储运、造价低廉；回收复用、绿色环保等特点。<br />\n③子堤组成<br />\n子堤支撑角架：由铝合金型材轴接而成直接使用转动轴安装于挡水面板后部，平时可折叠与面板合而一体，使用时可快速展开做为坝体的支撑框架。横梁连接杆：由铝合金方形材与专用接头联接而成，做为坝体的连接支撑杆件。 折叠式挡水面板：在面板之间使用连接轴将面板相互连接成整体，不用时数块面板可以折叠成一体，减少所占空间。使用时可以瞬间展开 提升组装速度。折叠式挡水面板采用波纹玻璃钢材料、特制的彩钢板、铝合金板、防水型PVC板，通过专用固定装置与横梁连接成一体。<br />\n④板坝式应急挡水子堤指标<br />\n子堤尺寸： 1.2 m×10m。子堤单元宽：1m。适用堤质：沙壤土、壤土、粘土/混凝土、沥青。 子堤高：1.30/1.35m。 挡水高度： 1.0m。 原堤顶宽：4.0m以上。 安全系数k：2.0-3.35。 设计风速：6.0m/s。 设计河面宽/风浪高：4km/0.3m。 产品毛重：260kg。 产品净重：225kg。 构筑速度:60分钟100人/km。<br />\n⑤施工方法<br />\na、人员配置 通常每250m配置30人作为相对独立作业分队（在土基条件下作业时，可增加50人，用于开挖防渗沟槽），每个独立作业分队又分为若干作业小组，其具体人员编成及任务分工是： 中队长、分队长负责本中（分）队的组织指挥工作。 测绘、验收组：组长1名，测绘、技术验收员2名，主要负责测绘标定子堤轴线，确定开槽（软基）或打孔（硬基）位置，检查验收子堤施工质量。 开槽（打孔）组：组长1名，开槽（打孔）操作手若干名，该组主要负责在坝顶开设截渗、防位移沟槽或打孔及放置、紧固膨胀螺栓或夯入道钉。 坝体装配组：组长1名，操作手若干名，主要负责装配钢性坝体。也可与挡水防渗组联合作业。 挡水防渗组：组长1名，操作手若干名，主要负责埋设挡水防渗布。也可与坝体装配组联合作业。<br />\nb、装配 第一步：设计坝轴线（一般情况下，子堤迎水侧沟槽距迎水侧坝顶边沿50cm为宜），平整堤基表面。 第二步：开挖防渗抗位移槽。开设防渗及抗位移沟槽三条（防渗槽一条，抗位移槽一条，防渗兼抗位移槽一条）,并将挖出的土，堆放在沟槽迎水侧备用（必要时，也可只开防渗兼抗位移槽一条）。 第三步：设置刚性支撑体（为提高作业速度，可采取分组装配三角架和横梁，形成单元式结构，待沟槽开设完毕，即可将若干个单元组合放置到预定位置）。 第四步：用土将防渗抗位移沟槽埋实。 第五步：将挡水防渗面板插入防渗沟槽内，并用土埋实。<br />\n<p>\n\t<strong>示意图</strong>\n</p>',
                sort: 18,
                reservoir_id: 3,
                update_time: '2021-12-01 14:14:15',
                create_time: '2021-12-01 14:14:15'
              }
            ],
            childrenType: 1
          }
        ],
        childrenType: 0
      },
      {
        id: 16,
        parent_id: 13,
        sort: 3,
        label: '大坝临时过水',
        reservoir_id: 3,
        child_num: 1,
        name: '大坝临时过水',
        children: [
          {
            id: 24,
            parent_id: 16,
            sort: 1,
            label: '具体做法',
            reservoir_id: 3,
            child_num: 0,
            name: '具体做法',
            children: [
              {
                label: '具体做法',
                cat_id: 24,
                plan_title: '具体做法',
                id: 13,
                content: '<p>\n\t<strong>发生原因</strong>\n</p>\n<p>\n\t泄洪设施出险\n</p>\n<p>\n\t<strong>详情描述</strong>\n</p>\n<p>\n\t在大坝、下游坡及趾脚铺设土工膜、彩条布等后让大坝临时过水。利用坝体临时过水，为防止土工膜、彩条布等被冲走，应特别注意防冲材料的四周连接固定，如采用钢管网格压住土工膜、彩条布等，其中钢管网格采用锚杆深入坝体加固。\n</p>\n（1）主要特点 抢险物资容易准备；技术简单、施工迅速。<br />\n（2）适用范围 考虑到土工膜及彩条布等存在被冲走、下泄水会冲刷膜与膜之间空隙下的土体，威胁大坝安全，因此下游坡为土质边坡宜慎用。一般宜用在下游坡为堆石坡的坝体，且应在短历时洪水、且洪量较小的情况应用，因此需要准确掌握相应的水文、气象等洪水资料。<br />\n（3）注意事项<br />\na、首先应将下游人员等安全撤离。<br />\nb、在降低库水位同时，应采取必要措施，确保大坝在库水位骤降工况下上游坝坡的抗滑稳定。<br />\nc、在降低库水位同时，应在下游坝脚增加必要的消能防冲保护。<br />\nd、采用爆破方法时，必须首先将爆破影响区的人员安全撤离，同时应注意爆破的方式、范围及药量，避免由于爆破引发其它险情。<br />\ne、临时加高坝体应抢在洪水之前完成，并做好加高部分的止水工作。指定专人巡视检查，发现问题应及时处理。<br />\nf、水库水位抬高后，大坝（副坝）可能会同步产生其它险情，应密切注意并采取相应措施。<br />\ng、坝顶临时过水应慎用，不到万不得已不应轻易动用。坝体、坝肩、坝脚一定范围内必须全面覆盖土工膜、彩条布。锚固措施牢靠。<br />\nh、破坝泄洪风险较大，应慎用，只有在其它方法难以有效降低水库水位时，才考虑适用。同时必须及时动态掌握水位变化情况、气象资料，采取措施防止溃坝。<br />\n<p>\n\t<strong>示意图</strong>\n</p>',
                sort: 19,
                reservoir_id: 3,
                update_time: '2021-12-01 14:21:44',
                create_time: '2021-12-01 14:21:44'
              }
            ],
            childrenType: 1
          }
        ],
        childrenType: 0
      }
    ],
    childrenType: 0
  },
  {
    id: 26,
    parent_id: 0,
    sort: 2,
    label: '严重滑坡',
    reservoir_id: 3,
    child_num: 2,
    name: '严重滑坡',
    children: [
      {
        id: 31,
        parent_id: 26,
        sort: 1,
        label: '险情概述',
        reservoir_id: 3,
        child_num: 0,
        name: '险情概述',
        children: [
          {
            label: '严重滑坡',
            cat_id: 31,
            plan_title: '严重滑坡',
            id: 5,
            content: '<p class="MsoNormal" style="vertical-align:baseline;">\n\t<strong>抢险思路和原则</strong>\n</p>\n<p class="MsoNormal" style="vertical-align:baseline;">\n\t一旦出现滑坡迹象时，首先必须判明滑坡仍处于发展阶段还是已经达到稳定阶段，然后确定采取紧急抢护措施或进行永久性加固处理。在抢护或处理前，要查清造成滑坡的原因，针对不同情况，采取相应措施。 造成滑坡的原因是滑动力大于抗滑力，所以应该设法减少滑动力与增加抗滑力。对于发展迅速的滑坡，应采取快速、有效的临时措施，按照“上部削坡减载，下部固脚阻滑”、“增加阻滑力，减少滑动力”的原则及时抢修，阻止滑坡的发展。 对发生在迎水面的滑坡，可在滑动体坡脚部位抛砂石料或砂（土）袋压重固脚，增加抗滑力；在滑动体上部削坡减载，减少滑动力。 对发生在背水坡的滑坡，常采用压重固脚法、滤水土撑法和以沟代撑法进行抢修。 对于因坝体渗流作用造成的滑坡，必须采取“前堵后排”的措施。\n</p>\n<p class="MsoNormal" style="vertical-align:baseline;">\n\t<strong>注意事项</strong>\n</p>\n<p class="MsoNormal">\n\t（1）在滑坡险情出现以及抢护中，还可能伴随出现浑水漏洞、管涌、严重漏水以及再次发生滑坡等险情。在这种复杂紧急情况下，应选定多种适合险情的抢护方法。&nbsp;\n</p>\n<p class="MsoNormal">\n\t（2）在渗水严重的滑坡体上，要尽量避免大量抢护人员践踏，造成险情扩大。如坡脚泥泞，人上不去，可铺土工织物、篷布、芦柴、草袋等，先上去少数人工作。在滑坡抢险过程中，一定要确保人身安全。\n</p>\n<p class="MsoNormal">\n\t（3）压重固脚法是迎水坡抢险的有效方法。但一定要探明水下滑坡的位置，然后在滑坡体外缘进行抛石固脚。严禁在滑动土体上抛石，这不但不能起到阻滑作用，反而加大了向下滑动力，会进一步促使土体滑动。&nbsp;\n</p>\n<p class="MsoNormal">\n\t（4）在滑坡体抢护中，如果基础松软，不能用打桩的方法来阻止土体的滑动，因为在这种情况下桩的阻滑作用很小，且打桩会振松土体，进一步降低土的抗剪强度，恶化险情。&nbsp;\n</p>\n<p class="MsoNormal">\n\t（5）导渗沟开挖应尽可能挖至滑裂面，如情况严重，难以全部挖至滑裂面时，可将沟的上、下端挖至滑裂面，不应全面同时开挖，以免引起坍塌。开挖中松土等应予清除，导渗材料顶部要覆盖保护，防止滤层被堵，以利排水。\n</p>\n<p class="MsoNormal">\n\t（6）出现滑坡性裂缝时，不可采用灌浆方法处理。因浆液中的水分，将降低抗滑力，且灌浆压力也会加速滑坡体下滑。\n</p>',
            sort: 21,
            reservoir_id: 3,
            update_time: '2021-11-24 10:16:17',
            create_time: '2021-11-23 16:56:35'
          }
        ],
        childrenType: 1
      },
      {
        id: 32,
        parent_id: 26,
        sort: 2,
        label: '压重固脚法',
        reservoir_id: 3,
        child_num: 0,
        name: '压重固脚法',
        children: [
          {
            label: '压重固脚法',
            cat_id: 32,
            plan_title: '压重固脚法',
            id: 6,
            content: '<p class="MsoNormal" style="text-indent:32.1500pt;">\n\t<b>发生原因</b><b></b>\n</p>\n<p class="MsoNormal">\n\t<span>坝体结构破坏</span>\n</p>\n<p class="MsoNormal" style="text-indent:32.1500pt;">\n\t<b>详情描述</b><b></b>\n</p>\n<p class="MsoNormal">\n\t<span>该法适用于坝身与基础一起滑动的滑坡；坝区周围有足够可取的当地材料作为压重体，如块石、砂砾石、土料等。</span> <span>压重固脚常用的有镇压台和压坡体两种形式，应根据当地土料、石料资源和滑坡的具体情况采用。镇压台或压坡体应沿滑坡段全面铺筑，并伸出滑坡段两端</span>5<span>～</span><span>10m</span><span>，其宽度和高度视滑坡体的大小和所需压重阻滑力而定。一般石料镇压台的高度为</span><span>3</span><span>～</span><span>5m</span><span>；压坡体的高度一般为滑坡体高度的</span><span>l/2</span><span>左右，边坡为</span><span>1</span><span>：</span><span>3.5</span><span>～</span><span>1</span><span>：</span><span>5</span><span>。当采用土料压坡体时，应先满铺一层厚约</span><span>0.5</span><span>～</span><span>0.8m</span><span>的砂砾石滤层，再回填压坡体土料。堆砌压重体时，应分段清除松土和稀泥，及时堆砌压重体，不允许沿坡脚全面同时开挖后，再堆砌压重体。 在保证坝身有足够的挡水断面的前提下，将滑坡的主裂缝上部进行削坡，以减少下滑荷载。同时在滑动体坡脚外缘抛块石或砂（土）袋等，作为临时压重固脚，以阻止继续滑动。 如滑坡发生在迎水坡且水位不能降低时，可采用经纬仪或全站仪，采用船只向水中抛石固脚。</span>\n</p>\n<p class="MsoNormal">\n\t<b>示意图</b>\n</p>',
            sort: 22,
            reservoir_id: 3,
            update_time: '2021-11-24 10:11:08',
            create_time: '2021-11-23 17:04:13'
          }
        ],
        childrenType: 1
      }
    ],
    childrenType: 0
  },
  {
    id: 27,
    parent_id: 0,
    sort: 3,
    label: '严重漏水',
    reservoir_id: 3,
    child_num: 1,
    name: '严重漏水',
    children: [
      {
        id: 33,
        parent_id: 27,
        sort: 1,
        label: '严重漏水',
        reservoir_id: 3,
        child_num: 0,
        name: '险情概述',
        children: [
          {
            label: '险情概述',
            cat_id: 33,
            plan_title: '严重漏水',
            id: 14,
            content: '<p>\n\t<strong>抢险思路和原则</strong>\n</p>\n<p>\n\t大坝严重渗漏抢险原则是“临水面截渗、背水面导渗”。“临水面截渗”是在大坝上游临水面用不透水材料如土工膜、粘性土截住渗水入口范围，以减少渗漏，控制险情。“背水面导渗”是在背水面用透水材料如土工织物、砂砾石做反滤，使渗漏水集中起来排走，又避免渗漏水带走坝体土颗粒，使险情趋于稳定，确保大坝安全。 严重渗漏险情发生或已出现浑水，水情预报库水位还要上涨则必须立即抢险。 考虑到临水面截渗需要在水下摸索，施工困难，效果不理想，为避免延误抢险时机，一般应先进行“背水面导渗”，视具体情况决定是否再实施“临水面截渗”措施。\n</p>\n<p>\n\t<strong>注意事项</strong>\n</p>\n<p>\n\t1、抢险过程中，背水坡面渗漏抢险不要上大批人，同时应尽量避免在背水坡渗水范围内来回践踏，以免加大加深稀软土体范围，切忌用粘土或不透水料强行阻压和在堤坝坡上打桩堵水，造成施工困难、使险情恶化。&nbsp;\n</p>\n<p>\n\t2、采用砂石料反滤时，应按质量要求铺设，尽量减少在已铺好的层面上践踏，以免降低滤层的作用。\n</p>\n<p>\n\t3、渗水段的坝脚附近如系老河道、塘坑等，抢险时应在该坝脚处抛填块石或土袋固基，以免因坝基渗透变形而使险情扩大。&nbsp;\n</p>\n<p>\n\t4、当必须实施“临水面截渗”措施时，如果库水较浅，可在上游坝面自上而下铺设土工膜，而后用装有土石的编织袋压在土工膜上，使土工膜紧贴坝面；如果库水较浅而现场粘性土料又较丰富，也可在上游坝面抛铺粘性土料。\n</p>\n<p>\n\t5、临水面截渗抢堵后要及时巩固，断流闭气，切忌在漏洞进口直接抛投砖石或硬性钢体物料，防止渗漏复发扩大。&nbsp;\n</p>\n<p>\n\t6、采用各种反滤导渗方法，应严格按反滤要求，分层填筑，不得互相混杂。\n</p>\n<p>\n\t7、探摸和堵塞漏洞进水口时，要采取可靠措施，保护抢险人员的安全。\n</p>',
            sort: 31,
            reservoir_id: 3,
            update_time: '2021-12-01 14:29:13',
            create_time: '2021-12-01 14:29:13'
          }
        ],
        childrenType: 1
      }
    ],
    childrenType: 0
  },
  {
    id: 28,
    parent_id: 0,
    sort: 4,
    label: '管涌',
    reservoir_id: 3,
    child_num: 1,
    name: '管涌',
    children: [
      {
        id: 34,
        parent_id: 28,
        sort: 1,
        label: '险情概述',
        reservoir_id: 3,
        child_num: 0,
        name: '险情概述',
        children: [
          {
            label: '管涌',
            cat_id: 34,
            plan_title: '管涌',
            id: 15,
            content: '<p>\n\t<strong>抢险思路和原则</strong>\n</p>\n<p>\n\t根据产生管涌险情险情的机理，抢险应按照“反滤导渗、控制涌水、给渗水留有出路”的原则进行。 发生管涌险情后，为了控制渗水来源，首先需要考虑尽量降低库水位，并设法封堵和拦截临水面的入渗点。当发生管涌时，渗透水流的入渗点在大坝上游面，由于水深，难以检查和封堵。出险处在下游面坝脚附近，一般在大坝下游面抢险，抢险时应采用反滤导渗的方式，给渗出来的水留有出路，又使地基土的细颗粒不再随渗透水流流失。\n</p>\n<p>\n\t<strong>注意事项</strong>\n</p>\n<p>\n\t（1）在大坝背水坡附近抢护时，切忌使用不透水材料堵塞，以免截断排水出路，造成渗透坡降加大，使险情恶化。&nbsp;\n</p>\n<p>\n\t（2）使用土工织物作反滤材料时，应注意不要被泥土淤塞，阻碍渗水流出。&nbsp;\n</p>\n<p>\n\t（3）流土为另一种渗透变形形式。在非粘性土中流土表现为颗粒群的同时运动，如泉眼群、沙沸、土体翻滚等最终被渗流托起；在粘性土中，表现为土块隆起，膨胀、浮动、断裂等险情。抢护方法与管涌同。&nbsp;\n</p>\n<p>\n\t（4）管涌险情的发展，将导致大坝裂缝、沉陷。在抢护管涌的同时，应迅速抢护大坝险情。外侧闭渗，防洪水沿裂缝渗漏，加固加高坝身，防洪水漫顶。\n</p>',
            sort: 41,
            reservoir_id: 3,
            update_time: '2021-12-01 14:30:22',
            create_time: '2021-12-01 14:30:22'
          }
        ],
        childrenType: 1
      }
    ],
    childrenType: 0
  },
  {
    id: 29,
    parent_id: 0,
    sort: 5,
    label: '贯穿性裂缝',
    reservoir_id: 3,
    child_num: 1,
    name: '贯穿性裂缝',
    children: [
      {
        id: 35,
        parent_id: 29,
        sort: 1,
        label: '险情概述',
        reservoir_id: 3,
        child_num: 0,
        name: '险情概述',
        children: [
          {
            label: '贯穿性裂缝',
            cat_id: 35,
            plan_title: '贯穿性裂缝',
            id: 16,
            content: '<p>\n\t<strong>抢险思路和原则</strong>\n</p>\n<p>\n\t对大坝裂缝抢险要综合性地把握三个要点，即 （1）总体上应对裂缝截断封堵，恢复坝体的完整性。 （2）对贯穿性裂缝应迅速处理。 （3）对裂缝处理一般都要“开肠破肚”，作为汛期裂缝抢险必须密切注意库水位、水情和雨情的预报，要备足抢险物料，抓住无雨天气，突击完成，确保大坝安全。 贯穿性裂缝一般采用横墙隔断法处理。\n</p>\n<p>\n\t<strong>注意事项</strong>\n</p>\n<p>\n\t1、对伴有滑坡、塌陷等险情除险的裂缝，应抢险护坡、处理塌陷。\n</p>\n<p>\n\t2、当采用横墙割断法抢护裂缝险情时，必须密切注意上游水情和雨情的预报，并备足物料，抓住晴天，保证质量，突击完成。\n</p>',
            sort: 51,
            reservoir_id: 3,
            update_time: '2021-12-01 14:32:18',
            create_time: '2021-12-01 14:32:18'
          }
        ],
        childrenType: 1
      }
    ],
    childrenType: 0
  },
  {
    id: 30,
    parent_id: 0,
    sort: 6,
    label: '滑坡堵塞溢洪道',
    reservoir_id: 3,
    child_num: 1,
    name: '滑坡堵塞溢洪道',
    children: [
      {
        id: 36,
        parent_id: 30,
        sort: 1,
        label: '险情概述',
        reservoir_id: 3,
        child_num: 0,
        name: '险情概述',
        children: [
          {
            label: '滑坡堵塞溢洪道',
            cat_id: 36,
            plan_title: '滑坡堵塞溢洪道',
            id: 17,
            content: '<p>\n\t<strong>抢险思路和原则</strong>\n</p>\n对山体滑坡堵塞溢洪道要把握三个要点，即 （1）安排专业人员做好滑坡体的观测，确定滑坡是否已经稳定。 （2）对于已经稳定的滑坡体，安排挖掘机、自卸汽车、人员迅速清理溢洪道内的滑坡体，清理后对受损的溢洪道工程部分及时修复。 （3）对不稳定的滑坡体，处理滑坡、溢洪道内的滑坡体同步进行。 滑坡体稳定性初判：滑坡后，在野外，从宏观角度观察滑坡体，可以根据一些外表迹象和特征，可粗略的判断它的稳定性。 （1）已稳定滑坡体的迹象 ①后壁较高且稳定。 ②滑坡平台宽大、且已夷平，土体密实，有沉陷现象。 ③滑坡前缘的斜坡较陡，土体密实，无松散崩塌现象。前缘有被库水冲刷过的现象。 ④滑坡体舌部的坡脚有清晰的泉水流出等。 （2）不稳定滑坡体的迹象 ①滑坡体表面总体坡度较陡，而且延伸很长，坡面高低不平。 ②有滑坡平台、面积不大，且有向下缓倾和未夷平现象。 ③滑坡表面有泉水、湿地，且有新生冲沟。 ④滑坡表面有不均匀沉陷的局部平台，参差不齐。 ⑤滑坡前缘土石松散，小型坍塌时有发生，并面临库冲刷的危险。<br />\n<p>\n\t<strong>注意事项</strong>\n</p>\n<p>\n\t1、滑坡体处理时，应安排专人清理边坡上的可能滚落的石块，必须注意施工人员、设备的安全。\n</p>\n<p>\n\t2、发生滑坡后的山体应设置永久观测设施。\n</p>\n<p>\n\t3、滑坡与强降雨同步导致库水位猛涨的，在处理滑坡、采取其它泄洪措施的同时，必须同步采取水库漫顶的应对措施。\n</p>',
            sort: 61,
            reservoir_id: 3,
            update_time: '2021-12-01 14:33:13',
            create_time: '2021-12-01 14:33:13'
          }
        ],
        childrenType: 1
      }
    ],
    childrenType: 0
  }
]
