import Vue from 'vue'
import VueRouter from 'vue-router'
import store from '@/store'

import Layout from '@/layout'
import Login from '@/views/login'
import Jump from '@/layout/jump.vue'
import Engineering from './modules/engineering'
import Flood from './modules/flood'
import Operate from './modules/operate'
import Maintain from './modules/maintain'
import mobileTerminal from './modules/mobile-terminal'
// import Bhgl from './modules/bhgl'

Vue.use(VueRouter)

const whiteList = ['/login', '/404']

const routes = [
  {
    path: '/',
    redirect: '/jump'
  },
  {
    path: '/login',
    component: Login
  },
  {
    path: '/',
    component: Layout,
    children: [
      {
        path: '/home',
        component: () => import('@/views/home'),
        meta: {
          pageName: '综合驾驶舱'
        }
      },
      // Bhgl,
      Engineering,
      Flood,
      Operate,
      Maintain
      // {
      //   path: '/yjjc',
      //   component: () => import('@/views/yjjc'),
      //   meta: {
      //     pageName: '应急决策'
      //   }
      // }
      // {
      //   path: '/manage',
      //   component: () => import('@/views/manage'),
      //   meta: {
      //     pageName: '调度管理'
      //   }
      // },
      // {
      //   path: '/help',
      //   component: () => import('@/views/help'),
      //   meta: {
      //     pageName: '公共服务'
      //   }
      // }
    ]
  },
  mobileTerminal,
  {
    path: '/jump',
    component: Jump
  }
]

const router = new VueRouter({
  routes
})

// 原登录页
// router.beforeEach(async (to, from, next) => {
//   // console.log('当前跳转信息', to, from)
//   if (store.getters.token) {
//     if (to.path === '/login') {
//       next('/')
//     } else {
//       next()
//       if (!store.getters.name) {
//         await store.dispatch('user/getUserInfoAction')
//       }
//     }
//   } else {
//     if (whiteList.includes(to.path)) {
//       next()
//     } else {
//       next('/login')
//     }
//   }
// })

router.beforeEach(async (to, from, next) => {
  // console.log('当前跳转信息', to, from)
  if (store.getters.token) {
    if (to.path === '/login') {
      next('/jump')
    } else {
      next()
      if (!store.getters.name) {
        await store.dispatch('user/getUserInfoAction')
      }
    }
  } else {
    if (whiteList.includes(to.path)) {
      next()
    } else {
      next('/login')
    }
  }
})

// router.afterEach((to, from) => {
//   console.log('页面跳转完了', to, from)
// })

export default router
