import service from '@/utils/service'
import axios from 'axios'

const fiveOneServe = axios.create({
  baseURL: 'https://open.guangchuan.org',
  withCredentials: false // 默认 false,表示跨域请求时是否需要使用凭证
})
// 雨情预报
export function getRainregimeApi () {
  return service({
    url: '/rain/rainregime'
  })
}
// 水情预警
export function getWaterregimeApi () {
  return service({
    url: '/rain/waterregime'
  })
}
// 雨量自定义增量列表
export function getRainZiAddListApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/customrain/rianlist',
    data
  })
}

// 雨量自定义增量计算入库流量
export function getRainZiAddFlowinApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/customrain/listflowin',
    data
  })
}
// 雨量自定义增量计算度汛方案
export function getRainZiAddDxApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/customrain/listoptimal',
    data
  })
}
// 台风列表
export function getTfListApi () {
  return service({
    url: '/floodcontrolplan/hist/typhoon',
    params: {
      page: 1,
      limit: 10000
    }
  })
}

// 获取未来雨量数据
export function getFutureRainApi () {
  return service({
    url: '/floodcontrolplan/forecast/totalrain'
  })
}

// 获取未来入库流量数据
export function getFutureFlowInApi (level) {
  return service({
    url: '/floodcontrolplan/forecast/flowin',
    params: {
      level
    }
  })
}

// 获取未来雨量度汛数据
export function getFutureDxApi (level) {
  return service({
    url: '/floodcontrolplan/forecast/optimal',
    params: {
      level
    }
  })
}

// 获取未来自定义洪水调度
export function getFutureZiApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/forecast/flood',
    data
  })
}

// 获取烟花雨量累计值
export function getTfHisRainAllApi () {
  return service({
    url: '/floodcontrolplan/hist/averagerain'
  })
}

// 获取烟花雨量数据
export function getTfHisRainApi () {
  return service({
    url: '/floodcontrolplan/hist/totalrain'
  })
}
// 获取烟花入库流量数据
export function getTfHisFlowInApi (params) {
  return service({
    url: '/floodcontrolplan/hist/flowin',
    params
  })
}
// 获取烟花台风度汛方案列表
export function getTfDxApi (level) {
  return service({
    url: '/floodcontrolplan/hist/optimal',
    params: {
      level
    }
  })
}

// 获取自定义洪水调度
export function getTfZiApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/hist/flood',
    data
  })
}

// 大坝运行预警
export function getDamWarmApi () {
  return service({
    url: '/item'
  })
}

// 自定义雨量-雨量预报
export function getRainZiApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/customrain/dispatch',
    data
  })
}

// 自定义雨量-入库流量
export function getFlowInZiApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/customrain/flowin',
    data
  })
}

// 自定义雨量-度汛方案
export function getRainDxZiApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/customrain/optimal',
    data
  })
}

// 自定义雨量-度汛方案计算
export function getRainCalcZiApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/customrain/flood',
    data
  })
}

// 自定义雨量增量-度汛方案计算
export function getRainCalcZiAddApi (data) {
  return service({
    method: 'POST',
    url: '/floodcontrolplan/customrain/listflood',
    data
  })
}

// 断面水位过程
// export function getDisasterApi (params) {
//   return service({
//     url: '/disaster/sectionbyareaname',
//     params
//   })
// }

// 受灾区域分析
export function getTotalrainApi (params) {
  return service({
    url: '/disaster/analysis',
    params
  })
}

// 河道断面预测最高水位
export function getMaxwaterlevelApi (params) {
  return service({
    url: '/disaster/maxwaterlevel',
    params
  })
}

// 断面水位过程全部
export function getRiversectionlistApi (params) {
  return service({
    url: '/disaster/riversectionlist',
    params
  })
}

// 获取监测点列表
export function getRainZListApi (type) {
  return service({
    url: '/point',
    params: {
      page: 1,
      limit: 10000,
      type_val: type
    }
  })
}
export function getFutureFlowApi (params) {
  return service({
    url: '/future/rainave',
    params
  })
}

// 获取 51 controlArr

export function getFiveOneControlArrApi (params) {
  return fiveOneServe({
    // url: 'https://open.guangchuan.org/disaster/listArea?projectId=125&isInfa=false&gk=2&startDate=2022-02-02%2002:02:02&gateCount=22&totalRainFall=222&token=gqp7ade01wyeiqzgnxp9agsh1roqruz7bdl1jwatmj2jar4vkbjay73p9g0se22l',
    url: '/disaster/listArea',
    params
  })
}
